/*
 * chemtab - a periodic table data base (C) 1990 Jim King (pulsar@lsrhs)
 *
 * ptabl.c	Print the Periodic Table with sorted elements in place
 */

#include <curses.h>
#include "windows.h"
#include <stdio.h>
#include "variables.h"
#include "tune.h"
#include "element.h"

/* helps to print out where the elements go */
int	horz[10] = { 0, 2, 4, 6, 8, 10, 12, 14, 18, 20 };

/*
 * ptabl() - no input
 *
 * purpose:	To print the periodic table then fill in spaces with
 *		appropriate ''selected'' elements.
 */
ptabl()
{
	FILE	*fd;		/* Periodic table is in a file */
	char	foo[80];	/* And we need to read it into something */
	int	n;		/* element number reference */

	if ((fd = fopen(TABLE, "r")) == NULL) {
		bot("Cannot open Periodic Table for reading..");
		sleep(2);
		bot(" ");
		return(0);
	}

	clear(); refresh();
	for (i = 0; i < 22; i++) {	/* read in the table */
		fgets(foo, 80, fd);
		mvwaddstr(graph, i, 0, foo);
		wrefresh(graph);
	}				/* and output to WINDOW *graph */
	fclose(fd);
	tablsort();			/* Put characteristics on screen */
	for (i = 1; i < gtot+1; i++) {	/* format and print element sym. */
		n = sub1[i];
		if (e[n].anum > 56 && e[n].anum < 72)
			wmove(graph, horz[8], (13 + ((e[n].fam - 1) * 3)));
		else if (e[n].anum > 88 && e[n].anum < 104)
			wmove(graph, horz[9], (13 + ((e[n].fam - 1) * 3)));
		else
			wmove(graph, horz[e[n].row], (1 + ((e[n].fam - 1) * 3)));

		wstandout(graph);
		wprintw(graph, "%2s", e[n].sym);
		wrefresh(graph);
		wstandend(graph);
	}
	wrefresh(graph);
	capture(graph, 0, 0);
	spc();
	wclear(graph); wrefresh(graph);
	clear();
	refresh();
	return(0);
}
