/*
 * chemtab - a periodic table data base (C) 1990 Jim King (pulsar@lsrhs)
 *
 * dogph.c	Contains graphing procedures
 */

#include <curses.h>
#include "windows.h"
#include <stdio.h>
#include <math.h>
#include "tune.h"
#include "variables.h"
#include "element.h"
#include "graph.h"

/*
 * numr(ch)
 *	input:	ch - char - input to determine output
 *	output:	return() - int
 *
 * purpose:	to print the top line of the graph, x vs. y, we need
 *		the array number of the chosen function, array gname[]
 *		found in graph.h.. octal move wouldn't work.
 */
numr(ch)
char	ch;
{
	switch(ch) {
		case 'a':	return(1);
		case 'b':	return(2);
		case 'c':	return(3);
		case 'd':	return(4);
		case 'e':	return(5);
		case 'f':	return(6);
		case 'g':	return(7);
		case 'h':	return(8);
		case 'i':	return(9);
		case 'j':	return(10);
		default:	return(0);
	}
}

fixup(win)
WINDOW	*win;
{
	wmove(win, 0, 0);
	wmove(btm, 0, 0);
	wmove(win, 0, 0);
	move(0, 0);
	refresh();
	wrefresh(win);
	wrefresh(btm);
}

/*
 * dogph() - no input
 *
 * purpose:	This is the main graphing routine.
 */
dogph()
{
	char	c, str[80];
	int	which = 2;
	for (i = 0; i < 70; i++)		/* clear the x axis points */
		xaxis[i] = 0;
	for (i = 0; i < 21; i++)		/* clear the y axis points */
		yaxis[i] = 0;
	wclear(graph); wrefresh(graph); clear(); refresh();
	if (gtot != 0) {
		mvwaddstr(mn, 0, 0, "Would you like to use:");
		mvwaddstr(mn, 2, 10, "a] Elements you have already selected OR");
		mvwaddstr(mn, 3, 10, "b] All of the elements");
		wmove(mn, 5, 0); wclrtoeol(mn); wrefresh(mn);
thrd:		mvwaddstr(mn, 5, 0, "To graph with? ");
		wrefresh(mn);
		noecho(); crmode();
		c = wgetch(mn);
		if (c == 'a')	which = 1;
		else if (c == 'b')	which = 2;
		else {
			mvwaddstr(mn, 5, 0, "To graph with?   (choose 'a' or 'b')");
			goto thrd;
		}
		wclear(mn);
	}
	mvwaddstr(mn, 0, 0, "a] Atomic Number");
	mvwaddstr(mn, 1, 0, "b] Atomic Mass");
	mvwaddstr(mn, 2, 0, "c] Melting Temp.");
	mvwaddstr(mn, 3, 0, "d] Boiling Temp.");
	mvwaddstr(mn, 4, 0, "e] Ionization Energy");
	mvwaddstr(mn, 5, 0, "f] Electronegativity");
	wrefresh(mn);
	wmove(mn, 6, 0);
	wclrtoeol(mn);
	mvwaddstr(mn, 6, 0, "g] Specific Heat");
	wrefresh(mn);
	mvwaddstr(mn, 7, 0, "h] Density");
	mvwaddstr(mn, 8, 0, "i] Atomic Radius");
	mvwaddstr(mn, 9, 0, "j] Discovery Year");
	mvwaddstr(mn, 10, 0, "Graphing by this, across the X axis.");
	mvwaddstr(mn, 12, 0, "*** Due to lack of information at this time, graphs beyond");
	mvwaddstr(mn, 13, 0, "*** Atomic number 86 may be misleading.  The program is designed");
	mvwaddstr(mn, 14, 0, "*** to compensate, but nothing is perfect.");
first:	mvwaddstr(mn, 11, 0, "Your choice: ");
	wrefresh(mn);				/* collect their choices */
	crmode();
	noecho();
	c1 = getchar();	/* X axis chc */
	if (c1 < 'a' || c1 > 'j')
		goto first;
	for (i = 12; i < 15; i++) {
		wmove(mn, i, 0); wclrtoeol(mn);
	}

	for (i = 0; i <= MAXLM; i++) {
		switch(c1) {
			case 'a': x = e[i].anum; break;
			case 'b': x = e[i].amass; break;
			case 'c': x = e[i].melt; if (x == MEL) continue; break;
			case 'd': x = e[i].boil; if (x == BOI) continue; break;
			case 'e': x = e[i].fio; if (x == FIO) continue; break;
			case 'f': x = e[i].eneg; if (x == ENG) continue; break;
			case 'g': x = e[i].spht; if (x == SPHT) continue; break;
			case 'h': x = e[i].dens; if (x == DENS) continue; break;
			case 'i': x = e[i].arad; if (x == ARD) continue; break;
			case 'j': x = e[i].year; if (x == YEA) continue; break;
		}
		if (i == 1)
			xmax = xmin = x;
		else {
			if (x > xmax) xmax = x;
			if (x < xmin) xmin = x;
		}	
	}

	mvwaddstr(mn, 10, 0, "If you would rather use the maximum and minimum values of");
	mvwaddstr(mn, 11, 0, "all the elements, hit RETURN once.");
	wmove(mn, 12, 0); wprintw(mn, "All the element's values: Minimum %f, Maximum %f", xmin, xmax);
	mvwaddstr(mn, 13, 0, "What range, X Minimum? ");
	wrefresh(mn);
	echo(); nocrmode();
	gets(str);
	if (!strlen(str)) {
		xmin = -999;
		goto nt;
	}
	xmin = atof(str);
	fixup(mn);
	mvwaddstr(mn, 13, 0, "What range, X Maximum?                ");
	mvwaddstr(mn, 13, 0, "What range, X Maximum? ");
	wrefresh(mn);
	scanf("%f", &xmax);
	fixup(mn);
	getchar();	/* scanf does not eat the \n */
	
nt:	wmove(mn, 10, 0); wclrtoeol(mn); wmove(mn, 11, 0); wclrtoeol(mn);
	mvwaddstr(mn, 10, 0, "Graphing by this, down the Y axis.   ");
scnd:	wmove(mn, 12, 0); wclrtoeol(mn); wmove(mn, 13, 0); wclrtoeol(mn);
	mvwaddstr(mn, 11, 0, "Your choice: ");
	wrefresh(mn);
	noecho(); crmode();
	c2 = wgetch(mn); /* Y axis chc */
	if (c2 < 'a' || c2 > 'j')
		goto scnd;
	noecho();

	wclear(mn); wrefresh(mn);

	/* Here we find the x axis max and min values */

	if (xmin != -999)
		goto ystuff;

	for (i = 1; i <= MAXLM; i++) {
		switch(c1) {
			case 'a': x = e[i].anum; break;
			case 'b': x = e[i].amass; break;
			case 'c': x = e[i].melt; if (x == MEL) continue; break;
			case 'd': x = e[i].boil; if (x == BOI) continue; break;
			case 'e': x = e[i].fio; if (x == FIO) continue; break;
			case 'f': x = e[i].eneg; if (x == ENG) continue; break;
			case 'g': x = e[i].spht; if (x == SPHT) continue; break;
			case 'h': x = e[i].dens; if (x == DENS) continue; break;
			case 'i': x = e[i].arad; if (x == ARD) continue; break;
			case 'j': x = e[i].year; if (x == YEA) continue; break;
		}
		if (i == 1)
			xmax = xmin = x;
		else {
			if (x > xmax) xmax = x;
			if (x < xmin) xmin = x;
		}
	}
	/* Here we find the y axis min and max values */

ystuff:	if (which == 2) {
		for (i = 1; i < MAXLM; i++) {
			switch(c2) {
				case 'a': x = e[i].anum; break;
				case 'b': x = e[i].amass; break;
				case 'c': x = e[i].melt; if (x == MEL) continue; break;
				case 'd': x = e[i].boil; if (x == BOI) continue; break;
				case 'e': x = e[i].fio; if (x == FIO) continue; break;
				case 'f': x = e[i].eneg; if (x == ENG) continue; break;
				case 'g': x = e[i].spht; if (x == SPHT) continue; break;
				case 'h': x = e[i].dens; if (x == DENS) continue; break;
				case 'i': x = e[i].arad; if (x == ARD) continue; break;
				case 'j': x = e[i].year; if (x == YEA) continue; break;
			}
			if (i == 1)
				ymax = ymin = x;
			else {
				if (x > ymax) ymax = x;
				if (x < ymin) ymin = x;
			}
		}
	} else {
		for (i = 0; i <= gtot; i++) {
			switch(c2) {
				case 'a': x = e[sub1[i]].anum; break;
				case 'b': x = e[sub1[i]].amass; break;
				case 'c': x = e[sub1[i]].melt; if (x == MEL) continue; break;
				case 'd': x = e[sub1[i]].boil; if (x == BOI) continue; break;
				case 'e': x = e[sub1[i]].fio; if (x == FIO) continue; break;
				case 'f': x = e[sub1[i]].eneg; if (x == ENG) continue; break;
				case 'g': x = e[sub1[i]].spht; if (x == SPHT) continue; break;
				case 'h': x = e[sub1[i]].dens; if (x == DENS) continue; break;
				case 'i': x = e[sub1[i]].arad; if (x == ARD) continue; break;
				case 'j': x = e[sub1[i]].year; if (x == YEA) continue; break;
			}
			if (i == 1)
				ymax = ymin = x;
			else {
				if (x > ymax) ymax = x;
				if (x < ymin) ymin = x;
			}
		}
	}

	/* Now we have min & maxs we have to put a number in
	   each slot on both axes using a scale */

	scale = (xmax - xmin) / 69; /* 69 is # of slots in X axis */

	xaxis[1] = xmin;
	for (i = 2; i < 70; i++)
		xaxis[i] = xaxis[i-1] + scale;

	scale = (ymax - ymin) / 20; /* 20 is # of slots in Y axis */

	yaxis[20] = ymin;
	for (i = 19; i > 1; i--)
		yaxis[i] = yaxis[i+1] + scale;

	sprintf(str, "%s (x-axis) vs. %s (y-axis)", gname[numr(c1)], gname[numr(c2)]);
	mvwaddstr(graph, 0, (40 - (strlen(str) / 2)), str);
	wrefresh(graph);	/* That is the top graph line */
	for (i = 20; i > 1; i--) {		/* The y axis line */
		mvwaddstr(graph, i, 10, "|");
		wrefresh(graph);
	}
	for (i = 11; i < 80; i++) {		/* The x axis line */
		mvwaddstr(graph, 21, i, "-");
		wrefresh(graph);
	}
	mvwaddstr(graph, 21, 10, "+");		/* The corner */
	wrefresh(graph);
	for (i = 20; i > 1; i -= 5) {		/* Y axis points */
		if (c2 < 'f' || c2 > 'i')
			sprintf(str, "%d ->", (int)(yaxis[i]+.5));
		else
			sprintf(str, "%4.2f ->", yaxis[i]);
		mvwaddstr(graph, i, 0, str);
	}
	for (i = 1; i < 79; i += 10) {		/* X axis points */
		if (c1 < 'f' || c1 > 'i')
			sprintf(str, "^%d", (int)(xaxis[i]+.5));
		else
			sprintf(str, "^%4.2f", xaxis[i]);
		mvwaddstr(graph, 22, i+10, str);
	}
	/* The actual find & graph */

	if (which == 2) {
		for (i = 1; i < MAXLM; i++) {
			switch(c1) {	/* This should become a library function */
				case 'a': x = e[i].anum; break;
				case 'b': x = e[i].amass; break;
				case 'c': x = e[i].melt; if (x == MEL) continue; break;
				case 'd': x = e[i].boil; if (x == BOI) continue; break;
				case 'e': x = e[i].fio; if (x == FIO) continue; break;
				case 'f': x = e[i].eneg; if (x == ENG) continue; break;
				case 'g': x = e[i].spht; if (x == SPHT) continue; break;
				case 'h': x = e[i].dens; if (x == DENS) continue; break;
				case 'i': x = e[i].arad; if (x == ARD) continue; break;
				case 'j': x = e[i].year; if (x == YEA) continue; break;
			}
			if (x < xmin)
				continue;
			else if (x < xaxis[2])
				xspot = 1;
			else {
				for (j = 2; j < 70; j++) {
					if (x > xaxis[j])
						continue;
					else
						break;
				}
				xspot = j - 1;
				if (x > xmax)
					continue;
			}

			/* Found where it goes on the x, now the y */

			switch(c2) {
				case 'a': x = e[i].anum; break;
				case 'b': x = e[i].amass; break;
				case 'c': x = e[i].melt; if (x == MEL) continue; break;
				case 'd': x = e[i].boil; if (x == BOI) continue; break;
				case 'e': x = e[i].fio; if (x == FIO) continue; break;
				case 'f': x = e[i].eneg; if (x == ENG) continue; break;
				case 'g': x = e[i].spht; if (x == SPHT) continue; break;
				case 'h': x = e[i].dens; if (x == DENS) continue; break;
				case 'i': x = e[i].arad; if (x == ARD) continue; break;
				case 'j': x = e[i].year; if (x == YEA) continue; break;
			}

			if (x < yaxis[19])
				yspot = 20;
			else {
				for (j = 19; j > 1; j--) {
					if (x > yaxis[j])
						continue;
					else
						break;
				}
				yspot = j;
			}

			/* Align and put the dot where X marks the spot */

			mvwaddstr(graph, yspot, xspot+10, "o");
			wrefresh(graph);
		}
	} else {
		for (i = 1; i < gtot; i++) {
			switch(c1) {	/* This should become a library function */
				case 'a': x = e[sub1[i]].anum; break;
				case 'b': x = e[sub1[i]].amass; break;
				case 'c': x = e[sub1[i]].melt; if (x == MEL) continue; break;
				case 'd': x = e[sub1[i]].boil; if (x == BOI) continue; break;
				case 'e': x = e[sub1[i]].fio; if (x == FIO) continue; break;
				case 'f': x = e[sub1[i]].eneg; if (x == ENG) continue; break;
				case 'g': x = e[sub1[i]].spht; if (x == SPHT) continue; break;
				case 'h': x = e[sub1[i]].dens; if (x == DENS) continue; break;
				case 'i': x = e[sub1[i]].arad; if (x == ARD) continue; break;
				case 'j': x = e[sub1[i]].year; if (x == YEA) continue; break;
			}
			if (x < xmin)
				continue;
			else if (x < xaxis[2])
				xspot = 1;
			else {
				for (j = 2; j < 70; j++) {
					if (x > xaxis[j])
						continue;
					else
						break;
				}
				xspot = j - 1;
				if (x > xmax)
					continue;
			}

			/* Found where it goes on the x, now the y */

			switch(c2) {
				case 'a': x = e[sub1[i]].anum; break;
				case 'b': x = e[sub1[i]].amass; break;
				case 'c': x = e[sub1[i]].melt; if (x == MEL) continue; break;
				case 'd': x = e[sub1[i]].boil; if (x == BOI) continue; break;
				case 'e': x = e[sub1[i]].fio; if (x == FIO) continue; break;
				case 'f': x = e[sub1[i]].eneg; if (x == ENG) continue; break;
				case 'g': x = e[sub1[i]].spht; if (x == SPHT) continue; break;
				case 'h': x = e[sub1[i]].dens; if (x == DENS) continue; break;
				case 'i': x = e[sub1[i]].arad; if (x == ARD) continue; break;
				case 'j': x = e[sub1[i]].year; if (x == YEA) continue; break;
			}

			if (x < yaxis[19])
				yspot = 20;
			else {
				for (j = 19; j > 1; j--) {
					if (x > yaxis[j])
						continue;
					else
						break;
				}
				yspot = j;
			}

			/* Align and put the dot where X marks the spot */

			mvwaddstr(graph, yspot, xspot+10, "o");
			wrefresh(graph);
		}
	}
	/* fu is a goto for elements with an undefined var */

	capture(graph, 1, 0);
	spc();		/* Space to continue? */
	wclear(graph);
	wrefresh(graph);
}
