.TH CALC 1L "24 February 1988" " " " "

.de AI   \"Init annotation environment.
.PD 0
.nf
.na
.ta .5i
..
.de AU	\"Uninit annotation environment.
.PD
.fi
.ad
..
.de BA	\"Begin annotation
.fi
.IP "\\$1" 25
..
.de EA	\"End annotation
.nf
.PP
..

.SH NAME
calc \- a command line calculator

.SH SYNOPSIS
.B calc
[ 
.B \-d \-h \-o \-b \-@ 
.BI \-p n 
.B
\-e \- 
] 
[
.I expression 
]

.SH DESCRIPTION
.I calc 
evaluates mathematical expressions.

An expression is any decimal number in integer or real format.  It may
also be a binary, octal or hexidecimal integer prefixed by,
respectively,
.I b, 
.I o, 
or 
.I h, 
or an ASCII character, prefixed by 
.I @.

An expression is also any expression preceded by one of
the following:

.nf
.ta 1i 2i 3i
	sin	log	- (unary minus)
	cos	ln	+ (unary plus)
	tan	sqrt	~ (one's complement)
	atan	exp
.fi

or any two expressions separated by one of the following operators:

.nf
.ta 2i +.5i +.5i
.RS 1i
Exponentiation:	:
Multiplication:	*	x	X
	(none: implied multiplication)
Division:	/
Modulo:	%
Addition:	+
Subtraction:	-
Left shift:	<
Right shift:	>
Bitwise AND:	&
Bitwise XOR:	^
BitWise OR:	|
.RE
.fi

An expression is any expression preceded by an opening delimeter:

.nf
.ta 1i +.5i +.5i
	{	[	(
.fi

and followed by a closing delimeter:


.nf
.ta 1i +.5i +.5i
	}	]	)
.fi

The special symbols "pi" and "PI" are also valid expressions.  So is
"prev" which returns the value of the previous equation
(multiple-expression mode only).

If the expression is omitted from the command line, then the
program will be in multiple-expression mode and repeatedly read
expressions from the standard input until it encounters an empty
line or an end of file.

.SH OPTIONS
.IP\fB\-d\fP
(The default mode.)  The answer is printed as a decimal
number, or in scientific format if it is very large.
.IP\fB\-o\fP
The answer is printed in octal, rounded down to the
nearest integer.
.IP\fB\-h\fP
The answer is printed in hexadecimal, rounded down to the
nearest integer.
.IP\fB\-b\fP
The answer is printed in binary, rounded down to the
nearest integer.
.IP\fB\-@\fP
The answer is printed as an ASCII character (modulo 128).
.IP\fB\-p\fP\fIn\fP
Only meaningful in decimal and binary mode.  Specifies the
precision (the number of digits appearing after the decimal point)
for a decimal number, or the number of minimum number of digits
appearing in a binary number.  (In order to line up the columns when
multiple calculations are being performed.)  There
must not be a space between the ``\fBp\fP'' and 
.I n.
.IP\fB\-e\fP
Will cause
.I calc 
to exit when a bad expression is entered.  This is only
meaningful in multiple-expression mode.
.IP\fB\-\fP
Indicates the end of the argument list.  This is used
when the beginning of the expression might accidently be
interpreted as an option.  (See EXAMPLES below.)

.SH USAGE NOTES
Arguments to trig functions are specified in degrees.

All binary operators group left-to-right, unary operators and functions
group right-to-left.  Priority of functions and operators is almost
identical to that of C (except modulo is slightly lower here):

.RS .5i
.nf
.ta 1.5i +1.75i
Highest:	Unary Op's	Functions
	Exponentiation
	Multiplication	Division
	Modulo
	Addition	Subtraction
	Left shift	Right shift
	And
	Xor
Lowest:	Or
.fi
.RE

The C shell use many of
.IRcalc 's 
symbols for its own evil purposes.  These include all three
pairs of delimeters, and the asterisk.  Whenever
you need a delimeter, you are advised to enclose the entire
expression in double quotes to keep the shell from messing with
it.  Alternatively, you can omit the expression from the command
line, and have 
.I calc 
prompt you for it, in which case the shell
will never see what is typed.

Computations are performed using double precision floating point numbers
with the following exceptions: The modulo operation (%) rounds its
arguments to the nearest integer.  Bitwise and bit shift operations
expect (or will truncate to) positive integers.  Hex and octal modes
expect (or will truncate to) the nearest integer.
When an integer is expected, it must be less than the
largest long integer allowed on the machine (typically,
.if t 2\u\s-231\s0\d).  
.if n 2:31).  
You will get undefined results if you go sticking large
numbers where they don't belong.

.SH EXAMPLES
.AI
calc  2 + 5 x 6
	 32

.BA "calc '(2 + 5) x 6'"
Parens quoted to hide them from the shell.
.EA
	 42

calc -p2 "atan(tan(45))"
	 45.00

calc -h  20
	h14

calc -o @A
	o101

.BA "calc -b  2:8 + 3"
Exponentiation takes precidence over addition.
.EA
	b100000011

calc  b101 - hc
	-7

.BA "calc  -  -h4ff"
``\fB-\fP'' used so ``\fB-h\fP'' won't be interpreted as an option
.EA
	-1279
.AU

.SH DIAGNOSTICS
.I calc 
prints its error messages on the 
.B standard output.  
Normally, when an error occurs 
.I calc 
terminates with an exit status of 1.  The exception is when in
multiple-expression mode if the 
.I e 
option has
.B not 
been specified.  In this case, 
.I calc 
will simply report the error and move on to the next input.

The error messages are:
.RS .5i
.na
.IP "bad argument to -p option"
Option must be followed by an integer argument with no
intervening spaces.
.IP "missing expression"
An operator of function expected an expression and didn't find one.
.IP "division by zero"
Right-hand expression to the division operator evaluated to zero.
.IP "bad argument to modulo"
Right-hand expression to the modulo operator was zero, or was
greater than or equal to 
.if t 2\u\s-231\s0\d.
.if n 2:31.
.IP "illegal expression"
An expression couldn't be parsed.
.IP "unmatched open paren"
A parenthesized expression was opened, but never closed.
.IP "bad binary digit"
An expression preceded by a ``\fBb\fP'' contained a character
other than ``1'' and ''0''.
.ad
.RE

.SH BUGS
Ascii format (-@, and @) doesn't do anything to pretty up control
characters.  For example, "calc -@ 12" may have a disconcerting result.


.SH AUTHOR
Wayne Mesard, MESARD@BBN.COM
