/* This program was snagged off the USENET comp.lang.c mailing list 22 July 1987 */

/* The contents of the following program are copyright 1987 by John Cowan.
It is hereby released to the public domain.

This program emits C #define statements to the standard output describing
the machine it is executing on.  The following #defines are generated:
        Mch_Csz -       size of a char, in bits
        Mch_Ssz -       size of a short int, in bits
        Mch_Isz -       size of a plain int, in bits
        Mch_Lsz -       size of a long int, in bits
        Mch_BE -        defined if the machine is big-endian; that is, if
                        the most significant byte in a number appears first.
        Mch_LE -        defined if the machine is little-endian; that is, if
                        the least significant byte in a number appears first.
        Mch_PDP -       defined if the machine uses PDP-11 byte ordering;
                        LE for bytes-in-a-word and BE for words-in-a-long.
        Mch_ONE -       defined if the machine uses one's complement arithmetic.
        Mch_sgc -       defined if characters can be signed.
*/

#include <stdio.h>

char bittest[9] = "\001\001\001\001\001\001\001\001"; /*Changed from [6] for CRAY X-MP -WM*/
char endtest[6] = "\001\002\003\004\005";
long be = 1;
long le = 1;
long pdp;
int byteoff;
int bytesize;
long longval;

main()
        {
        int i;

        byteoff = (*(int *) bittest & 2047) - 1;
        switch (byteoff) {
        case 256: bytesize = 8; break;
        case 512: bytesize = 9; break;
        case 1024: bytesize = 10; break;
        default: fprintf(stderr, "mch: bogus byte size\n"); exit(1);
                }
        printf("#define Mch_Csz %d\n", bytesize);
        printf("#define Mch_Ssz %d\n", sizeof(short) * bytesize);
        printf("#define Mch_Isz %d\n", sizeof(int) * bytesize);
        printf("#define Mch_Lsz %d\n", sizeof(long) * bytesize);
        longval = *(long *) endtest;
        for (i = 0; i < sizeof(long); i++) {
                be *= byteoff;
                be += endtest[i];
                }
        for (i = sizeof(long) - 1; i >= 0; i--) {
                le *= byteoff;
                le += endtest[i];
                }
        pdp = 0x02010403;
        if (longval == be)
                printf("#define Mch_BE 1\n");
        else if (longval == le)
                printf("#define Mch_LE 1\n");
        else if (longval == pdp)
                printf("#define Mch_PDP 1\n");
        else {
                fprintf(stderr, "mch: bogus endianism\n");
                exit(1);
                }
        if (~0 == 0)
                printf("#define Mch_ONE 1\n");
        if ('\377' < 0)       /* modified 1987/07/22 R. Dhesi */
                printf("#define Mch_sgc 1\n");
        }
