/* ***************************************************** */
/* file rbp.h:  contains definitions for the rbp program */
/*              that uses 64-bit floating point weights  */
/*                                                       */
/* Copyright (c) 1990 by Donald R. Tveter                */
/*                                                       */
/* *******************************************************/

#define maxformat 21
#define buffsize 257

#define WTTYPE double         /* 64-bit floating point */
#define WTSIZE 8              /* reals uses 8 bytes */
#define HCODE -32768          /* code number for a layer h (2) unit */
#define ICODE -32767          /* code number for a layer i (3) unit */
#define JCODE -32766          /* code number for a layer j (4) unit */
#define KCODE -32765          /* code number for a layer k (5) unit */
#define GT 0                  /* a symbol meaning > */
#define GE 1                  /* a symbol meaning >= */
#define scale(x) x            /* scale not used in real version */
#define unscale(x) x          /* unscale not used in real version */
#define unscaleint(x) x       /* unscaleint not used in real version */

typedef struct patnode
   {
     WTTYPE val;              /* input or output pattern */
     struct patnode *next;    /* pointer to next node */
   } PATNODE;
typedef struct patlist
   {
     int bypass;              /* number of times to bypass pattern */
     PATNODE *pats;           /* the list of patterns */
     struct patlist *next;    /* the next pattern */
   } PATLIST;
typedef struct unit
   {
     short layernumber;       /* layer number of the unit */
     short unitnumber;        /* position within layer */
     double error;            /* to sum error factors */
     WTTYPE oj;               /* state of activation of node */
     WTTYPE tj;
     struct unit *wtlist;     /* to list of weights to prev layer */
     struct unit *next;       /* link to next unit in this layer */
   } UNIT;

typedef struct wtnode
   {
#ifdef SYMMETRIC
     WTTYPE *weight;          /* weight from here to backunit */
     WTTYPE *olddw;           /* delta wji from previous iteration */
     WTTYPE *total;           /* total of changes for batch updates */
     WTTYPE *eta;             /* the eta of the DBD method */
#else
     WTTYPE weight;           /* weight from here to backunit */
     WTTYPE olddw;            /* delta wji from previous iterataion */
     WTTYPE total;            /* total of changes for batch updates */
     WTTYPE eta;              /* the eta of the DBD method */
#endif
     struct wtnode *next;     /* link to next node */
     struct UNIT *backunit;   /* ptr to unit the weight comes from */
   } WTNODE;

typedef struct layer
   {
     int unitcount;           /* number of units in this layer */
     struct layer *backlayer; /* pointer to previous layer */
     struct layer *next;      /* pointer to next layer */
     struct UNIT *units;      /* start of list of units in this layer */
     PATLIST *patstart;       /* to the list of patterns */
     PATLIST *currentpat;     /* the current pattern */
   } LAYER;
