/* ****************************************************** */
/* file ibp.h: contains definitions for programs that use */
/*             16-bit integer weights                     */
/*                                                        */
/* Copyright (c) 1990 by Donald R. Tveter                 */
/*                                                        */
/* ****************************************************** */

#define maxformat 21          /* maximum number of format breaks */
#define buffsize 257          /* maximum size of an input line */
#define WTTYPE short          /* a 16-bit integer */
#define WTSIZE 2              /* shorts are two bytes */
#define HCODE -32768          /* code number for a layer h (2) unit */
#define ICODE -32767          /* code number for a layer i (3) unit */
#define JCODE -32766          /* code number for a layer j (4) unit */
#define KCODE -32765          /* code number for a layer k (5) unit */
#define GT 0                  /* a symbol meaning > */
#define GE 1                  /* a symbol meaning >= */

typedef struct patnode
   {
     WTTYPE val;              /* input or output pattern */
     struct patnode *next;    /* pointer to next node */
   } PATNODE;
typedef struct patlist
   {
     int bypass;              /* number of times to bypass pattern */
     PATNODE *pats;           /* the list of patterns */
     struct patlist *next;    /* the next pattern */
   } PATLIST;
typedef struct unit
   {
     short layernumber;       /* layer number of the unit */
     short unitnumber;        /* position within layer */
     int error;               /* to sum error factors */
     WTTYPE oj;               /* state of activation of node */
     struct wtnode *wtlist;   /* the list of weights */
     struct unit *next;       /* link to next unit in this layer */
   } UNIT;

typedef struct wtnode
   {
#ifdef SYMMETRIC
     WTTYPE *weight;          /* ptr to weight */
     WTTYPE *olddw;           /* ptr to delta wji */
     WTTYPE *eta;             /* ptr to eta for the DBD method */
     int *total;              /* ptr to total of weight changes */
#else
     WTTYPE weight;           /* weight from here to backunit */
     WTTYPE olddw;            /* delta wji from previous iteration */
     WTTYPE eta;              /* the eta for the DBD method */
     int total;               /* total weight changes for batch mode */
#endif
     struct wtnode *next;     /* link to next node */
     struct UNIT *backunit;   /* ptr to unit the weight comes from */
   } WTNODE;

typedef struct layer
   {
     int unitcount;           /* number of units in this layer */
     struct layer *backlayer; /* pointer to previous layer */
     struct layer *next;      /* pointer to next layer */
     struct UNIT *units;      /* start of list of units in this layer */
     PATLIST *patstart;       /* to the list of patterns */
     PATLIST *currentpat;     /* the current pattern */
   } LAYER;
