/*
 * File matching program run by the list-file-completions and file-complete
 * commands of atty(1).
 *
 * Copyright (C) 1989 by Kenneth Almquist.  All rights reserved.
 * This file is part of atty, which is distributed under the terms specified
 * by the Atty General Public License.  See the file named LICENSE.
 */

#include <stdio.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/dir.h>


#ifndef __STDC__
#define const /* empty */
#endif
#define ARB 4


int list;			/* true if -l option given */
int completion;			/* true if -c option given */
char *dirname;			/* directory being searched */
int basenamelen;		/* number of characters of name specified */


#ifdef __STDC__
char **listfiles(char *);
int compar(char **, char **);
void printlist(char **);
void complete(char **);
int prefix(const char *, const char *);
#else
char **listfiles();
int compar();
void printlist();
void complete();
int prefix();
#endif

#ifdef __STDC__
void *malloc(unsigned);
void *realloc(void *, unsigned);
#else
char *malloc();
char *realloc();
#endif


#define equal(s1, s2)	(strcmp(s1, s2) == 0)



main(argc, argv)
      char **argv;
      {
      char **ap;
      char *p;
      char **flist;

      if (argc <= 1) {
usage:	    fputs("Usage: fmatch -cl file_prefix\n", stdout);
	    exit(2);
      }
      ap = argv + 1;
      p = *ap;
      if (*p == '-') {
	    ap++;
	    p++;
	    while (*p) {
		  switch (*p++) {
		  case 'c':
			completion++;
			break;
		  case 'l':
			list++;
			break;
		  default:
			goto usage;
		  }
	    }
      }
      if (*ap == NULL)
	    goto usage;
      if (! completion)
	    list++;
      flist = listfiles(*ap);
      if (list)
	    printlist(flist);
      if (completion)
	    complete(flist);
      return 0;
}


char **
listfiles(name)
      char *name;
      {
      char *p;
      char *basename;
      char *dir;
      DIR *dp;
      struct direct *dirp;
      struct stat statb;
      char **flist;
      int listsize;
      int nfiles;

      basename = NULL;
      for (p = name ; *p ; p++) {
	    if (*p == '/')
		  basename = p;
      }
      if (basename == NULL) {
	    basename = name;
	    dir = ".";
      } else if (basename == name) {
	    basename++;
	    dir = "/";
      } else {
	    *basename++ = '\0';
	    dir = name;
      }
      if (! equal(dir, ".")
       && (stat(dir, &statb) < 0 || (statb.st_mode & S_IFMT) != S_IFDIR)) {
	    fputs(dir, stdout);
	    fputs(": no such directory\n", stdout);
	    if (completion)
		  putc('\7', stdout);
	    exit(2);
      }
      if ((dp = opendir(dir)) == NULL) {
	    fputs(dir, stdout);
	    fputs(": cannot open\n", stdout);
	    if (completion)
		  putc('\7', stdout);
	    exit(2);
      }
      listsize = 20;
      if ((flist = (char **)malloc(listsize * sizeof (char *))) == NULL) {
nospace:    fputs("fmatch: out of space\n", stdout);
	    exit(2);
      }
      nfiles = 0;
      while ((dirp = readdir(dp)) != NULL) {
	    if (*basename) {
		  if (*dirp->d_name != *basename
		   || ! prefix(basename, dirp->d_name))
			continue;
	    } else {
		  if (*dirp->d_name == '.')
			continue;
	    }
	    if (nfiles >= listsize - 1) {
		  listsize += listsize >= 100? 40 : 20;
		  if ((flist = (char **)realloc(flist,
					listsize * sizeof (char *))) == NULL) {
			goto nospace;
		  }
	    }
	    if ((p = malloc(strlen(dirp->d_name) + 1)) == NULL)
		  goto nospace;
	    strcpy(p, dirp->d_name);
	    flist[nfiles++] = p;
      }
      flist[nfiles] = NULL;
      dirname = dir;
      basenamelen = strlen(basename);
      return flist;
}


int
compar(a, b)
      char **a, **b;
      {
      return strcmp(*a, *b);
}


void
printlist(flist)
      char **flist;
      {
      char **pp;
      int maxlen;
      int nfiles;
      int len;
      int ncolumns;
      int sep;
      int line;
      int col;
      int fnum;
      int colwidth;
      int i;

      if (flist[0] == NULL)
	    fputs("No match", stdout);
      nfiles = 0;
      maxlen = 0;
      for (pp = flist ; *pp ; pp++) {
	    len = strlen(*pp);
	    if (maxlen < len)
		  maxlen = len;
	    nfiles++;
      }
      if (nfiles == 0)
	    return;
      qsort((char *)flist, nfiles, sizeof (char *), compar);
      ncolumns = 80 / (maxlen + 2);
      if (ncolumns == 0)
	    ncolumns = 1;
      colwidth = 80 / ncolumns;
      sep = (nfiles + ncolumns - 1) / ncolumns;
      for (line = 0 ; line < sep ; line++) {
	    for (col = 0 ; ; ) {
		  fnum = col * sep + line;
		  if (fnum >= nfiles)
			break;
		  fputs(flist[fnum], stdout);
		  if (++col >= ncolumns)
			break;
		  for (i = colwidth - strlen(flist[fnum]) ; --i >= 0 ; )
			putc(' ', stdout);
	    }
	    putc('\n', stdout);
      }
}


void
complete(flist)
      char **flist;
      {
      char *first;
      int nmatch;
      char **pp;
      char *p, *q;
      struct stat statb;

      if ((first = *flist) == NULL) {
	    putc('\7', stdout);
	    return;
      }
      nmatch = strlen(first);
      statb.st_mode = 0;
      if (flist[1] == NULL) {
	    if ((p = malloc(strlen(dirname) + nmatch + 3)) == NULL) {
		  fputs("Out of space\n", stdout);
		  exit(2);
	    }
	    strcpy(p, dirname);
	    strcat(p, "/");
	    strcat(p, first);
	    stat(p, &statb);
      } else {
	    for (pp = flist ; *++pp != NULL ; ) {
		  for (p = first, q = *pp ; *p == *q && p - first < nmatch ; p++, q++);
		  nmatch = p - first;
	    }
	    if (nmatch <= basenamelen) {
		  putc('\7', stdout);
		  return;
	    }
      }
      fputs("\033]I", stdout);
      fwrite(first + basenamelen, nmatch - basenamelen, 1, stdout);
      if ((statb.st_mode & S_IFMT) == S_IFDIR)
	    putc('/', stdout);
      putc('\n', stdout);
      if (flist[1] != NULL)
	    putc('\7', stdout);
}


int
prefix(pfx, string)
      register char const *pfx;
      register char const *string;
      {
      while (*pfx) {
	    if (*pfx++ != *string++)
		  return 0;
      }
      return 1;
}
