/*
**
** This software is Copyright (c) 1989 by Kent Landfield.
**
** Permission is hereby granted to copy, distribute or otherwise 
** use any part of this package as long as you do not try to make 
** money from it or pretend that you wrote it.  This copyright 
** notice must be maintained in any copy made.
**
**
**  History:
**	Creation: Tue Feb 21 08:52:35 CST 1989 due to necessity.
**                                                               
*/
#ifndef lint
static char SID[] = "@(#)record_arc.c	1.1 6/1/89";
#endif

#include <sys/types.h>
#include <sys/stat.h>
#include <dirent.h>
#include <stdio.h>
#include "cfg.h"

static char work[BUFSIZ];
static int len;
static FILE *archived_fp;

FILE *fopen();
FILE *efopen();

extern int test;
extern struct group_archive *newsgrp;

/*
** needs_to_be_archived:
**
** int needs_to_be_archived(filename) char *filename; { return(0); }
**
** This function is used to determine if the filename
** passed to it requires archiving. If the filename is
** found in the .archived file, it has been previously
** archived and does not need to be now. If it is not
** found in the .archived file, it needs to be archived.
*/

int needs_to_be_archived(filename)
    char *filename;
{
    /*
    ** If the .archived file is missing, it must be
    ** the first time that it is to be archived.
    */
    if ((archived_fp = fopen(newsgrp->arc_done,"r")) == NULL) 
	return(1);

    len = strlen(filename);
 
    while (fgets(work, sizeof work, archived_fp) != NULL) {
        if (*work == '#')
            continue;
        if (strncmp(work,filename,len) == 0) {
            (void) fclose(archived_fp);
            return(0);
        }
    }
    (void) fclose(archived_fp);
    return(1);
}

/*
** remove_expired:
**
** This function is used to maintain the .archived file in the
** newsgroup's archive BASEDIR directory. This file is used to assure
** that files are not archived over and over and that the 
** administrator does not need to wait until the files have
** expired before they are added to the archive. 
** The .archived file stores a list of filenames of files that have been 
** archived already. The remove_expired function removes filenames 
** from the .archived file that no longer exist. In this manner the 
** file is self maintaining. Expired entries are removed.
*/

remove_expired()
{
    char news_file[20];
    char fl_loc[MAXNAMLEN];
    char tmp_loc[MAXNAMLEN];
    FILE *tmp_archived;
    struct stat stbuf;

    /* Is this being run as a test ? */

    if (test)
        return;

    /* Is this the first time this group is to be archived ? */

    if (stat(newsgrp->arc_done, &stbuf) < 0) 
        return;
    
    /* open the necessary files, creating a temp file */
    (void) sprintf(tmp_loc,"%s/.arch_tmp", newsgrp->location);

    tmp_archived = efopen(tmp_loc,"w");
    archived_fp = efopen(newsgrp->arc_done,"r");

    /* 
    ** for every line in the .archived file,
    **    check it comment line. If so, save it in the temp file
    **    strip the string of any blanks or tabs inadvertantly 
    **      added by admin in manual mode (editor)
    **    check to see if the file still exists.
    **    if so, write filename to the temp file
    ** endfor
    */

    while (fgets(work, sizeof work, archived_fp) != NULL) {
        if (*work == '#')      /* maintain comments in .archived */
            (void) fprintf(tmp_archived,work);
        else {
            (void) sscanf(work, "%s %s", news_file, fl_loc);
            if (stat(news_file, &stbuf) == 0) 
                (void) fprintf(tmp_archived,work);
        }
    }

    /*
    ** Close both files and rename the temp 
    ** file to the new .archived file.
    */

    (void) fclose(tmp_archived);
    (void) fclose(archived_fp);
    (void) rename(tmp_loc,newsgrp->arc_done);
    return;
}

/*
** get_archived_rec:
**
** get_archived_rec(filename) char *filename; { return(filename); }
**
** get_archived_rec is used to determine if the filename
** passed to it has been archived. If its name is found
** in the .archived file, it has been previously archived
** and its archive information record is  returned to the
** caling routine. Else it returns NULL.
*/

char *get_archived_rec(filename)
    char *filename;
{
    /*
    ** If the .archived file is missing, it must be
    ** the first time that it is to be archived.
    */
    if ((archived_fp = fopen(newsgrp->arc_done,"r")) == NULL) 
	return(NULL);

    len = strlen(filename);
 
    while (fgets(work, sizeof work, archived_fp) != NULL) {
        if (*work == '#')
            continue;
        if (strncmp(work,filename,len) == 0) {
            (void) fclose(archived_fp);
            *(work+(strlen(work)-1)) = '\0';
            return(work);
        }
    }
    (void) fclose(archived_fp);
    return(NULL);
}

/*
** write_archived:
**
** write_archived(filename, path) char *filename, path; {}
**
** This function is used to write a filename and its archived location
** to the .archived file in the newsgroup's archive BASEDIR
** directory since we do not want it rearchived tomorrow.
*/

write_archived(filename, path)
    char *filename;
    char *path;
{
    FILE *fp;

    /* 
    ** If in test mode no actual operations are 
    ** to be done...
    */
    if (test)
        return;

    /*
    ** open the file and append the record
    */

    fp = efopen(newsgrp->arc_done,"a+");
    (void) fprintf(fp,"%s %s\n",filename, path);
    (void) fclose(fp);
    return;
}
