/*
**
** This software is Copyright (c) 1989 by Kent Landfield.
**
** Permission is hereby granted to copy, distribute or otherwise 
** use any part of this package as long as you do not try to make 
** money from it or pretend that you wrote it.  This copyright 
** notice must be maintained in any copy made.
**
**
**  History:
**	Creation: Tue Feb 21 08:52:35 CST 1989 due to necessity.
**                                                               
*/
#ifndef lint
static char SID[] = "@(#)format.c	1.1 6/1/89";
#endif

#include <stdio.h>
#include <sys/types.h>
#include "article.h"

extern FILE *errfp;

char *itoa(n)
int n;
{
    static char str[20];

    int i, c, j, sign;
	
    if ((sign = n) < 0) 
	n = -n;

    i = 0;
    do {
        str[i++] = n % 10 + '0';
    } while ((n /= 10) > 0);

    if (sign < 0)
        str[i++] = '-';
    str[i] = '\0';

    for (i = 0, j = strlen(str)-1; i < j; i++,j--) {
        c = str[i];
        str[i] = str[j];
        str[j] = c;
    }
    return(str);
}

char *add_string(ptr, member_str)
char *ptr, *member_str;
{
    while(*member_str)
        *ptr++ = *member_str++;
    return(ptr);
}


char *basename(name)
    char *name;
{
    char *p;
    char *strrchr();
    
    if ((p = strrchr(name,'/')) == NULL)
        return(name);
    return(++p);
}


format_output(fp, frmptr, filename, default_type)
FILE *fp;              /* Output file pointer                   */
char *frmptr;          /* Selection Format pointer              */
char *filename;        /* File name the info came from          */
int default_type;      /* Where called from, Rkive or Article   */
{
    char *basename();
    char *aptr, *cp, c;
    char format[BUFSIZ];
    void exit();
 
    /* Did the user specify a format to use   */
    /* or should the default format be used ? */

    if (frmptr == NULL) {
       if (default_type == ARCHIVE) 
           (void) fprintf(fp,"%-s\t%-s\t%s\n",
                 article.newsarticle, header.archive_name,
                 article.description);
       else
           (void) fprintf(fp,"%-s\t%-s\n", filename, header.subject);
       return;
    }

    for (cp = format; cp < format + BUFSIZ; cp++)
         *cp = '\0';
 
    aptr = frmptr;
    cp = format;

    while (c = *aptr++) {
        if (c == '%') {
           switch (*aptr++) {
               case '%':
                   *cp++ = '%';
                   continue;
               case 'A':     /* Approved  */
                   cp = add_string(cp, header.approved);
                   continue;
               case 'B':     /* Base name of the file path  */
                   cp = add_string(cp, basename(filename));
                   continue;
               case 'C':     /* Supersedes  */
                   cp = add_string(cp, header.supersedes);
                   continue;
               case 'D':     /* Date  */
                   cp = add_string(cp, header.subdate);
                   continue;
               case 'F':     /* From */
                   cp = add_string(cp, header.from);
                   continue;
               case 'G':     /* newGroups disk location */
                   cp = add_string(cp, article.newsgroup);
                   continue;
               case 'K':     /* Keywords  */
                   cp = add_string(cp, header.keywords);
                   continue;
               case 'L':     /* Lines */
                   cp = add_string(cp, header.numlines);
                   continue;
               case 'M':     /* Message-ID */
                   cp = add_string(cp, header.ident);
                   continue;
               case 'N':     /* Newsgroups */
                   cp = add_string(cp, header.nbuf);
                   continue;
               case 'O':     /* Actual Archived filename */
                   cp = add_string(cp, filename);
                   continue;
               case 'P':     /* Path  */
                   cp = add_string(cp, header.path);
                   continue;
               case 'R':     /* References  */
                   cp = add_string(cp, header.references);
                   continue;
               case 'S':     /* Subject  */
                   cp = add_string(cp, header.subject);
                   continue;
               case 'T':     /* Subject Topic  */
                   cp = add_string(cp, article.description);
                   continue;
               case 'V':     /* Volume-Issue article filename  */
                   cp = add_string(cp, article.filename);
                   continue;
               case 'a':     /* Archive-name */
                   cp = add_string(cp, header.archive_name);
                   continue;
               case 'b':     /* Submitted-by */
                   cp = add_string(cp, header.submitted_by);
                   continue;
               case 'c':     /* Control  */
                   cp = add_string(cp, header.ctlmsg);
                   continue;
               case 'd':     /* Distribution  */
                   cp = add_string(cp, header.distribution);
                   continue;
               case 'e':     /* Expires  */
                   cp = add_string(cp, header.expdate);
                   continue;
               case 'f':     /* Followup-to  */
                   cp = add_string(cp, header.followup_to);
                   continue;
               case 'i':     /* issue (if archive) */
                   cp = add_string(cp,itoa(article.issue));
                   continue;
               case 'l':     /* Author's logon address */
                   cp = add_string(cp, article.author_signon);
                   continue;
               case 'n':     /* Author's name */
                   cp = add_string(cp, article.author_name);
                   continue;
               case 'o':     /* Organization */
                   cp = add_string(cp, header.organization);
                   continue;
               case 'p':     /* Posting-number */
                   cp = add_string(cp, header.posting_num);
                   continue;
               case 'r':     /* Reply-to */
                   cp = add_string(cp, header.replyto);
                   continue;
               case 's':     /* Sender  */
                   cp = add_string(cp, header.sender);
                   continue;
               case 't':     /* Patch-To  */
                   cp = add_string(cp, header.patch_to);
                   continue;
               case 'u':     /* Summary */
                   cp = add_string(cp, header.summary);
                   continue;
               case 'v':     /* volume (if archive) */
                   cp = add_string(cp,itoa(article.volume));
                   continue;
               case 'x':     /* Xref */
                   cp = add_string(cp, header.xref);
                   continue;
               default:
                  (void) fprintf(errfp, "invalid format - %c\n", *--aptr);
                  exit(2);
           }    /* end switch */
        }
        else if (c == '\134') {
           switch (*aptr++) {
               case 'n':
                   *cp++ = '\n';
                   continue;
               case 't':
                   *cp++ = '\t';
                   continue;
           }
        }
        *cp++ = c;
     }  /* end while */

     (void) fprintf(fp, "%s\n", format);
     return;
}
