/*
**                                                                
**  Subsystem:   USENET Sources Archiver             
**  File Name:   ckconfig.c               
**                                                        
**  usage: config [ -gV ] [ -f config_file ]
**
**
** This software is Copyright (c) 1989 by Kent Landfield.
**
** Permission is hereby granted to copy, distribute or otherwise 
** use any part of this package as long as you do not try to make 
** money from it or pretend that you wrote it.  This copyright 
** notice must be maintained in any copy made.
**
** Use of this software constitutes acceptance for use in an AS IS 
** condition. There are NO warranties with regard to this software.  
** In no event shall the author be liable for any damages whatsoever 
** arising out of or in connection with the use or performance of this 
** software.  Any use of this software is at the user's own risk.
**
**  If you make modifications to this software that you feel 
**  increases it usefulness for the rest of the community, please 
**  email the changes, enhancements, bug fixes as well as any and 
**  all ideas to me. This software is going to be maintained and 
**  enhanced as deemed necessary by the community.
**		
**		Kent Landfield
**		uunet!ssbell!kent
**
**  History:
**	Creation: Tue Feb 21 08:52:35 CST 1989 due to necessity.
**                                                               
*/
char sccsid[] = "@(#)ckconfig.c	1.1 6/1/89";

#include <sys/types.h>
#include <dirent.h>
#include <stdio.h>
#include <pwd.h>
#include <grp.h>
#include "cfg.h"

#define M1 "The following values are used if the administrator has"
#define M2 "not set a value for a necessary configuration item(s)."
#define USAGE  "usage: %s [ -gV ] [ -f config_file ]\n"

extern struct passwd *pw;
extern struct group *gr;

struct passwd *getpwuid();
struct group *getgrgid();

main(argc,argv)
int argc;
char **argv;
{
   int c;
   extern char *optarg;
   extern int optind;

   logfp = stdout;
   errfp = stderr;
   progname = argv[0];
   fill_in_defaults = 0;
   config_file = LOCATION;

   if (argc > 1) {
      while ((c = getopt(argc, argv, "gVf:")) != EOF) {
         switch (c) {
             case 'f':
                 config_file = optarg;
                 break;
             case 'g':
                 fill_in_defaults++;
                 break;
             case 'V':
                 version();
             default:
                 (void) fprintf(errfp,USAGE, progname);
                 return(1);
         }
      }
   }
   setup_defaults();

   display_config();
   return(0);
}


display_config()
{
    register int i;

    (void) fprintf(logfp,"\n\t\tConfiguration Check for %s\n", 
                         config_file);

    (void) fprintf(logfp,"\n\t\t\tGlobal Defines\n\n");

    (void) fprintf(logfp,"News Directory:      %s\n",spooldir);
    (void) fprintf(logfp,"Problems Directory:  %s\n",problems_dir);
    (void) fprintf(logfp,"Global Logfile:      %s\n",
                         *log ? log : "NO LOGGING");
    (void) fprintf(logfp,"Global Index:        %s\n", 
                         *index ? index:"NO INDEXING");
    (void) fprintf(logfp,"Logfile Format:      %s\n",
                         *log_format ? log_format : "NOT SPECIFIED");
    (void) fprintf(logfp,"Index Format:        %s\n",
                         *index_format ? index_format : "NOT SPECIFIED");
    (void) fprintf(logfp,"Mail Results To:     %s\n\n", 
                         *mail ? mail : "NO ONE");
    (void) fprintf(logfp,"%s\n%s\n\n",  M1, M2);
    (void) fprintf(logfp,"Archive Type:    %s\n",
                         default_type == ARCHIVE_NAME ? "Archive-Name": 
                         default_type == VOLUME_ISSUE ? "Volume-Issue":
                                                        "Article-Number"); 
    (void) fprintf(logfp,"Patches Type:    %s\n",
                         default_patch_type == PACKAGE ? "Package" :
                                                         "Historical");


    pw = getpwuid(default_owner);
    (void) fprintf(logfp,"Default Owner:   %d <%s>\n", 
                         default_owner,pw->pw_name);

    gr = getgrgid(default_group);
    (void) fprintf(logfp,"Default Group:   %d <%s>\n", 
                         default_group, gr->gr_name);
    (void) fprintf(logfp,"Default Modes:   %o\n", default_modes);
    (void) fprintf(logfp,"Compression:     %s\n\n",
                          *compress ? compress : "NO COMPRESSION");

    if (default_patch_type == PACKAGE && default_type != ARCHIVE_NAME) {
        (void) fprintf(logfp,"WARNING: Package Patches archiving is only\n");
        (void) fprintf(logfp,"         used with Archive-Name archiving.\n\n");
    }

    (void) fprintf(logfp,"\t\tNewsgroup Archive Configuration\n\n\n");
    for (i = 0; i <= num; i++)  {
         display_group_info(&group[i]);
         (void) fprintf(logfp,"\n\n");
    }
    return;
}
