/*
**                                                                
**  Subsystem:   USENET Sources Archiver             
**  File Name:   article.c               
**                                                        
**  usage: article [ -adnvV ] [-f format ] newsarticle [ ... ]
**
**
** This software is Copyright (c) 1989 by Kent Landfield.
**
** Permission is hereby granted to copy, distribute or otherwise 
** use any part of this package as long as you do not try to make 
** money from it or pretend that you wrote it.  This copyright 
** notice must be maintained in any copy made.
**
** Use of this software constitutes acceptance for use in an AS IS 
** condition. There are NO warranties with regard to this software.  
** In no event shall the author be liable for any damages whatsoever 
** arising out of or in connection with the use or performance of this 
** software.  Any use of this software is at the user's own risk.
**
**  If you make modifications to this software that you feel 
**  increases it usefulness for the rest of the community, please 
**  email the changes, enhancements, bug fixes as well as any and 
**  all ideas to me. This software is going to be maintained and 
**  enhanced as deemed necessary by the community.
**		
**		Kent Landfield
**		uunet!ssbell!kent
**
**  History:
**	Creation: Tue Feb 21 08:52:35 CST 1989 due to necessity.
**                                                               
*/
char sccsid[] = "@(#)article.c	1.1 6/1/89";

#include <stdio.h>
#include <ctype.h>
#include <sys/types.h>
#include "article.h"

#define ARCHIVE_ONLY  1
#define NO_ARCHIVE   -1

#define USAGE  "usage: %s [ -adnvV ] [-f format ] newsarticle [ ... ]\n"

char *progname;                 /* name of executable              */
char *format_ptr = NULL;        /* pointer to user supplied format */
int verify_archive = 0;         /* archive verification needed ?   */
FILE *errfp;                    /* standard error file pointer     */
FILE *logfp;                    /* standard output file pointer    */

char *strchr();                 /* external function declaration   */

main(argc, argv)
int argc;
char **argv;
{
   int c;
   extern char *optarg;
   extern int optind;

   progname = argv[0];
   debug = verbose = 0;
   logfp = stdout;
   errfp = stderr;

   if (argc > 1) {
      while ((c = getopt(argc, argv, "adnvVf:")) != EOF) {
         switch (c) {
             case 'a':
                 verify_archive = ARCHIVE_ONLY;
                 break;
             case 'd':
                 debug++;
                 break;
             case 'f':
                 format_ptr = optarg;
                 break;
             case 'n':
                 verify_archive = NO_ARCHIVE;
                 break;
             case 'v':
                 verbose++;
                 break;
             case 'V':
                 version();
             default:
                 (void) fprintf(errfp,USAGE, progname);
                 return(1);
         }
      }
   }

   if ((optind >= argc) || (argc == 1)) {  /* file from stdin */
        char buf[BUFSIZ];
        while (fgets(buf,sizeof buf,stdin) != NULL) {
               buf[strlen(buf) -1] = '\0';
               article_header(buf);
        }
   }
   else { 
        for (; optind < argc; optind++)    /* process files to print */
             article_header(argv[optind]);
   }
   return(0);                              /* terminate this process */
}

article_header(flname)
    char *flname;
{
    char *dp;
    int header_ok = 0;
    char *strcpy();
    FILE *file, *efopen();

    int default_format = ARTICLE;

    init_article();

    file = efopen(flname,"r");

    (void) strcpy(article.newsarticle,flname);

    while (fgets(s,sizeof s,file) != NULL) {
        /*
        ** Check if the line is not a header line.
        ** Allow 2 lines to go by that are not header
        ** lines. In this manner, the auxilliary sources
        ** headers can be interpreted.
        */
        if (!isalpha(*s) || (strchr(s,':') == NULL)) {
           ++header_ok;
           if (header_ok == 2) {
               /* 
               ** Has the user requested to produce 
               ** only an archive listing ?
               */
               if (verify_archive == ARCHIVE_ONLY) {
                  if (!header.archive_name[0] || !article.description[0])
                       break;
                   default_format = ARCHIVE;
               }
               /* 
               ** Has the user requested to produce 
               ** a listing excluding all archive 
               ** potential members ?
               */
               else if (verify_archive == NO_ARCHIVE) {
                   if (header.archive_name[0] && article.description[0]) 
                       break;
                   default_format = ARTICLE;
               }
               /* 
               ** Print out the information as requested
               */
               format_output(logfp, format_ptr, flname, default_format);
               break;
            }
            continue;
        }

        dp = s;
        while (*++dp)
           if (*dp == '\n')
               *dp = '\0';
        /*
        ** Determine the type of the line and then
        ** store the line in its appropriate structure
	** element for later retrieval.
        */
        store_line();
    }
    (void) fclose(file);

    if (verbose)
        dump_article();
}
