/*
**
** This software is Copyright (c) 1989 by Kent Landfield.
**
** Permission is hereby granted to copy, distribute or otherwise 
** use any part of this package as long as you do not try to make 
** money from it or pretend that you wrote it.  This copyright 
** notice must be maintained in any copy made.
**
**
**  History:
**	Creation: Tue Feb 21 08:52:35 CST 1989 due to necessity.
**                                                               
*/
#ifndef lint
static char SID[] = "@(#)str.c	1.1 6/1/89";
#endif

/*
** Strchr() and Strrchr() are included for portability sake only.
*/

#ifndef NULL
#define NULL 0
#endif

#ifndef lint
/*
** strchr:
**
** strchr(str, c) returns a pointer to the first place in
** str where c occurs, or NULL if c does not occur in str.
**
** char *strchr(str, c) char *str, c; { return (str); }
**
*/

char *strchr(str, c)
register char *str, c;
{
    for (;;) {
        if (*str == c)
            return (str);
        if (!*str++)
            return (NULL);
    }
}

/*
** strrchr:
**
** strrchr(str, c) returns a pointer to the last place in 
** str where c occurs, or NULL if c does not occur in str.
**
** char *strrchr(str, c) char *str, c; { return (str); }
*/

char *strrchr(str, c)
register char *str, c;
{
    register char *t;

    t = NULL;
    do {
        if (*str == c)
            t = str;
    } while (*str++);
    return(t);
}
#endif /* lint */

/*
** strstrip:
**
** strstrip(str) returns a pointer to the first non-blank character 
** in str. It strips all blanks, and tabs from the front and back
** of a string as well as strip off newlines from the rear.
**
** char *strstrip(str) char *str; { return (str); }
*/

char *strstrip(str)
register char *str;
{
    register char *cp, *dp;
    
    cp = str;
    dp = ((str+strlen(str))-1);

    while(*cp && (*cp == ' ' || *cp == '\t')) 
      cp++;

    while(dp != cp && (*dp == ' ' || *dp == '\t' || *dp == '\n'))
      --dp;
    *(dp+1) = '\0';

    return(cp);
}

/*
** substr:
**
** substr(str, substr) returns a pointer to the first place in
** str where the substring substr occurs, or NULL if substr does
** not occur in str.
**
** char *substr(str, substr) char *str, *substr; { return (str); }
*/
char *substr(from, find)
    char *from, *find;
{
    register char *sp, *np;
    register int len;
    char *strchr();

    np = from;
    len = strlen(find);

    while ((sp = strchr(np,*find)) != NULL) {
        if (strlen(sp) < len)
            break;
        if (strncmp(sp,find,len) == 0) 
            return(sp);
        np = sp + 1;
    }
    return(NULL);
}
