# CONFIG file is inserted here

OPT=""
SORTMODE=""
ALL=false

LOOP=true
while $LOOP
do
	case "$1" in
	-a)	OPT="$OPT -a"
		ALL=true
		shift ;;
	-t)	SORTMODE="+1nr"
		shift ;;
	*)	LOOP=false
	esac
done

if [ -f $DB/acct -a -f $BIN/nnacct ] ; then
	$BIN/nnacct -r $OPT $@ | sort $SORTMODE
	exit
fi

if $ALL
then
	grep '^U:' $LOG
else
	grep "^U:.*(${LOGNAME-$USER})" $LOG
fi |

${AWK} '
BEGIN {
	any=0
}
NF == 7 {
	if (split($7, t, ".") == 2) {
		u[$5] += t[1] * 60 + t[2]
		any=1
	}
}
END {
	if (!any) {
		printf("No usage statistics\n")
		exit
	}
	for (n in u) {
		name=substr(n, 2, length(n)-3)
		printf("%-10.10s%8d.%02d\n", name, u[n]/60, u[n]%60);
	}
}' |

sort $SORTMODE
