#!	/bin/csh 	-f
# Find something that might be a man page and 'roff it.

# Geoffrey Leach
# LatiCorp Inc.	
# {att,bellcore,sun,ames,pyramid}!pacbell!laticorp!geoff

set DIR = `pwd`
set DIR = $DIR:t

if ( $#argv == 0 ) then
    set DOC = `find . \( -name "*.l" -o -name "*.man" -o -name "*.nro" -o -name "*.[1-8]" \) -print`
else
    set DOC = ( $* )
endif
foreach f ( $DOC )
    if ( $f:h != "./ARCF" ) then
	set D = $ARCHIVE/manl/$f:t 
	if ( $f:t == README ) set $f = ${DIR}.$f
repeat:
	if ( -e $D ) then
	    echo -n "Man page $f exists.  Ignore(i), overwrite(o) or new name(n) [i]? "
	    set ans = $<
	    switch ( $ans )
		case "i":
		default:
		    continue
		case "o":
		    breaksw
		case "n":
		    echo -n "Enter new name: "
		    set ans = <$
		    set D = $ARCHIVE/manl/$ans
		    goto repeat
		    breaksw
	    endsw
	endif
	nroff -man $f > $D
    endif
end
