#!	/bin/csh	-f

# Geoffrey Leach
# LatiCorp Inc.	
# {att,bellcore,sun,ames,pyramid}!pacbell!laticorp!geoff

set NAME = $0
set NAME = $NAME:t

set LIST = ( \
	games/v00 \
	games/v01 \
	games/v02 \
	games/v03 \
	games/v04 \
	games/v05 \
	misc/v02 \
	misc/v03 \
	misc/v04 \
	misc/v05 \
	x/v00 \
	x/v01 \
	x/v02 \
	unix/v00 \
	unix/v01 \
	unix/v02 \
	unix/v03 \
	unix/v04 \
	unix/v05 \
	unix/v06 \
	unix/v07 \
	unix/v08 \
	unix/v09 \
	unix/v10 \
	unix/v11 \
	unix/v12 \
	unix/v13 \
	unix/v14 \
	unix/v15 \
	unix/v16 \
	benchmarks \
	graphics \
	patches \
	lang \
	util \
	text \
	gnu \
	doc \
	dos \
	lib \
	alt )

cd $ARCHIVE
switch ( $NAME )
    case MakeArchiveIndex:	
	if ( -e I ) rm I
	foreach f ( ${LIST} )
	awk -F: '{n = $1 " (" v "):"; \
	    if ( substr($2, 1, 1) == "\t" ) $2 = substr($2, 2); \
	    if ( substr($2, 1, 1) == "\t" ) $2 = substr($2, 2); \
	    $2 = substr($2,1,46); \
	    if ( length(n) <  8 ) n = n "\t"; \
	    if ( length(n) < 16 ) n = n "\t"; \
	    if ( length(n) < 24 ) n = n "\t"; \
	    printf "%s\t%s\n", n, $2 }' v=$f $f/Index  >> I
	end
	sort -f I > Index
	rm I
	exit
    case PrintArchiveIndexes:
	cp /dev/null ~/tmp/netls
	foreach f ( ${LIST} )
	    ls -RC $f >> /tmp/netls
	end
	cd /tmp
	print netls
	exit
    default:
endsw
