.\" @(#) du.man 1.2 90/09/08 14:38:55
.\"
.\" Sat Sep  8 14:34:56 1990 - Chip Rosenthal <chip@chinacat.Unicom.COM>
.\"	Cleanup for distribution.
.\" Tue Apr 17 21:50:58 1990 - Chip Rosenthal <chip@chinacat.Unicom.COM>
.\"	Original composition.
.\"
.TH DU 1
.SH NAME
du - Enhanced disk usage summary.
.SH SYNTAX
.B du
[ options ] [ name ... ]
.SH DESCRIPTION
.I Du
determines the number of disk blocks used by
.IR name .
.P
If
.I name
is a directory, then
.I du
recursively descends down the directory accumulating and reporting the
disk usage at each subdirectory.  The usage at a directory will include
the usage of all its subdirectories.
.P
Since the usage is reported only at directories, no result will be printed
if
.I name
is a regular file.  (This may be changed with the
.B \-a
and
.B \-s
options described below.) If no
.I name
is specified, then
.I du
provides the usage at the current working directory.
.P
.I Du
keeps track of files which contain multiple links, and counts such files
only once.  Large files require filesystem overhead called ``indirect
blocks''.  These blocks will be included as well as the actual data (direct)
blocks in the usage statistics.
.P
Filesystem storage is allocated in groups called ``blocks'', and the block
size may be a filesystem dependent value.
.I Du
calculates the size of an entry in terms of the native filesystem block
size, but may scale the reported results to a ``reporting'' blocksize.
This ensures that entry sizes are calculated correctly, and reported
consistently.  The help option
.RB ( \-h )
will indicate the default reporting blocksize.  The
.B \-b
option can change this value.
.P
The following options modify the behavior of
.IR du :
.IP  "\-a" 10
The usage of all items (i.e. regular files as well as directories) is
reported.
.IP "\-b \fIsize\fR" 10
The usage is reported in terms of disk blocks \fIsize\fR bytes instead
of the actual disk block size of the filesystem.  If zero is specified,
conversion to a reporting blocksize is suppressed, and the values reported
are the actual number of blocks used.
.IP "\-c \fIn\fR,..." 10
This option requests that
.I du
provides a breakdown of the disk usage by age rather than a single total.
Each argument specifies a number of days.
.I Du
will print one column per argument showing the usage by files that many
days or older.  For example, the command:
.sp
.RS
du -c 0,7,30
.RE
.sp
will start at the current directory and display the total usage, the usage
by files a week or older, and the usage of files a month or older.  The
file's modification time is used to provide this breakdown.
.IP "\-d" 10
This option prevents
.I du
from descending into directories encountered.  It will count the space
used by the directory information, but will not examine the contents of
that directory.
.IP "\-f" 10
This option will prevent
.I du
from descending down into a directory if that action requires crossing
onto another filesystem.
.IP "\-h" 10
Displays a help summary.
.IP "\-i" 10
Do not accumulate subdirectories' usage into the parent directory's usage.
For example, if you run the USENET news software, you could perform a
command similar to:
.sp
.RS
du -i /usr/spool/news
.RE
.sp
to determine the disk space used by each newsgroup without accumulating,
for example, the
.I comp.unix.xenix
newsgroup usage in with the
.I comp.unix
newsgroup usage.
.IP "\-l" 10
Normally
.I du
will count a file with multiple links only once.  With this option,
.I du
will count the file each time is is encountered.
.IP "\-r" 10
Normally,
.I du
does it's work silently and will not report any errors (i.e. a
.I name
specified on the command line doesn't exist or you don't have permissions
to check a directory).  When this option is specified, such errors will
be reported.
.RI ( Note :
On some systems the default will be to changed to display errors, in which
case this option will have no effect.)
.IP "\-s" 10
Prints only a grand total for each
.I name
on the command line.
.IP "\-u" 10
Causes multiply linked files to be skipped entirely and omitted from the
usage statistics.
.\".SH SEE ALSO
.SH BUGS
.I Du
will report files with holes in them (sparse files) incorrectly.
.P
Anything but a regular file or directory (e.g. special files, FIFOs, etc.)
will be silently ignored.
.P
If the actual filesystem blocksize is not an integral multiple of the
reporting blocksize
.RB ( \-b )
then roundoff errors will occur in the translation.
.I Du
will round up in this case.
.SH AUTHOR
.nf
Chip Rosenthal
<chip@chinacat.Unicom.COM>
.sp
Copyright 1990, Unicom Systems Development.  All rights reserved.
See distributed README file for terms of distribution and use.
.fi
