/* @(#) du.h 1.3 90/09/09 10:24:49 */

/*
 * Package:	du - Enhanced "du" disk usage replacement.
 * File:	du.h - Header definitions.
 *
 * Sat Sep  8 14:34:56 1990 - Chip Rosenthal <chip@chinacat.Unicom.COM>
 *	Cleanup for distribution.
 * Tue Apr 17 21:50:58 1990 - Chip Rosenthal <chip@chinacat.Unicom.COM>
 *	Original composition.
 *
 * Copyright 1990, Unicom Systems Development.  All rights reserved.
 * See accompanying README file for terms of distribution and use.
 */


#define VERSION		"1"

/*
 * PRINT_ERRORS - If enabled, "du" will print diagnostic messages (e.g.
 * permission denied, etc.).  If disabled, "du" will print these messages
 * only if "-r" is given.  The latter behaviour is compatible with the
 * standard system "du".  The former behaviour is more sensible.
 */
#define PRINT_ERRORS	/**/

/*
 * REPORT_BLOCKSIZE - The size of a block (in bytes) used in reporting
 * disk usage.  Note that "du" will use the actual block size of a filesystem
 * when computing the usage of an entry on that filesystem, but will then
 * normalize all the results in terms of the reporting blocksize.  A
 * value of "512" will produce results compatible with the standard system
 * "du".  A value of "0" will use the native filesystem block size.  The
 * "-b" command line option may be used to override this default.
 */
#define REPORT_BLKSIZE	512

/*
 * MAX_BREAK - The maximum number of breakdown catagories which may be
 * specified with the "-c" option.  This value will effect the size of
 * (struct dskusage), and only a few of them are created, and thus this
 * can be a reasonably large number without too much impact.
 */
#define MAX_BREAK	64

/*
 * BROKE_MNTTAB - If defined, "du" will use it's own private description
 * of the /etc/mnttab file rather than including /usr/include/mnttab.h.
 * If you are running Interactive UNIX 2.0.2 you *must* enable this - your
 * <mnttab.h> is broken.
 */
/*#define BROKE_MOUNTAB	/**/


/*****************************************************************************
 *
 * End of site-specific customizations.
 *
 ****************************************************************************/

#define TRUE		1
#define FALSE		0

/*
 * Error severity codes.
 */
#define ERR_WARN	0
#define ERR_ABORT	1

#ifndef Reg
# define Reg		register
#endif

#ifdef INTERN
# define EXTERN
#else
# define EXTERN		extern
#endif

/*
 * A boolean true/false value.
 */
typedef int		BOOL;

/*
 * Datatype used to accumulate disk usage stats.
 */
struct dskusage {
    long b[MAX_BREAK];		/*  per days as specified Breakdown[]	      */
};

/*
 * Structure used to store information on mounted filesystems.
 */
struct fsinfo {
    int dev;			/* the device number			*/
    int nino;			/* number of available inodes		*/
    int bsize;			/* size of a block on this device	*/
    int nindir;			/* number direct addresses in a block   */
    unsigned char *idone;	/* bit vector of linked inodes done	*/
    struct fsinfo *next;	/* pointer to next item in linked list	*/
};

/*
 * General globals.
 */
EXTERN char *Progname;		/* this program's name			      */
EXTERN char *Curr_dir;		/* working dir where prog was started	      */
EXTERN long Curr_time;		/* time at which du was started		      */

/*
 * Boolean options set by command line switches.
 */
EXTERN BOOL Accum_subdirs;	/* add usage of a subdir into parent's usage  */
EXTERN BOOL All_entries;	/* show everything, not just directories      */
EXTERN BOOL Cross_filesys;	/* continue down dirs across filesystems      */
EXTERN BOOL Descend_dirs;	/* follow directories recursively	      */
EXTERN BOOL Suppress_repeats;	/* report multiply linked files only once     */
EXTERN BOOL Print_errors;	/* display error messages		      */
EXTERN BOOL Skip_links;		/* ignore multiply-linked regular files	      */
EXTERN BOOL Total_only;		/* only print total usage for entire dir tree */

/*
 * Other options set by command line switches.
 */
EXTERN int Report_blksize;	/* report usage in terms of blocks this size  */
EXTERN int Num_break;		/* breakdown usage reported to this many cols */
EXTERN int Breakdown[MAX_BREAK];/* each col is usage more than this many days */

/*
 * Local procedures.
 */
void		errmssg();	/* display a diagnostic message		     */
void		du_entry();	/* determine usage of a particular entry     */
void		fs_initinfo();	/* initialize filesystem information	     */
struct fsinfo *	fs_getinfo();	/* get filesystem information		     */
int		fs_linkdone();	/* determine whether a file has been visited */
long		fs_numblocks();	/* count number of blocks used by an entry   */
void		set_usage();	/* set a disk usage value		     */
void		add_usage();	/* accumulate a disk usage value	     */
void		print_usage();	/* display a disk usage value		     */
void *		xmalloc();	/* allocate memory with error checking	     */

