/*
	Read a bibliographic entry from a file.

	Read until have a non-blank line, then read until a blank line or
	EOF.  Return number of lines in citation.  (Zero means EOF, -1 error).

	Error are returned for various conditions:

	text of citation too long
	more than beMaxAuth authors
	first line does not begin with %
	% lines with non-capital letter following %
*/

# include	<stdio.h>
# include	<ctype.h>
# include	<varargs.h>
# include	"bibinfo.h"


static	long	line = 0;
static	long	citation = 0;


BERead (f, bi)
FILE	*f;
BibEnt	*bi;
{
BibFld	*bf = NULL;
char	*bp = BEText (bi);
int	left = sizeof (BEText (bi));
int	read = 1;
int	nLines = 0;
int	i, len;
int	c;

/*
	Initialize entry to "nothing"
*/

	BELen (bi) = 0;			/* no text */
	BEAuthCnt (bi) = 0;			/* no authors */
	for (i = 'A'; i <= 'Z'; i++)		/* no other fields, either */
		BEFldLen (BEFldPtr (bi, i)) = 0;

	++citation;

	while (read)
	{
		++line;
		if ((c = getc (f)) == EOF)
			break;
		if (c == '\n')			/* blank line */
		{
			read = (nLines == 0);	/* if haven't seen ref, keep */
			continue;		/* reading, else skip line */
		}
		if (++nLines == 1)		/* set pos on first line */
		{
			BEFilPos (bi) = ftell (f) - 1;
			if (c != '%')		/* make sure not cont. line */
			{
				BRError (bi, "First line in citation does not begin with '%%':\n%s\n", bp);
				return (-1);
			}
		}
		for (len = 0; left-- > 0; )	/* read line into buffer */
		{
			bp[len++] = c;
			if (c == '\n')		/* have full line now */
				break;
			if ((c = getc (f)) == EOF)
			{
				read = 0;	/* done reading */
				break;
			}
		}
		BELen (bi) += len;
		if (left < 0)
		{
			BRError (bi, "Citation too long, exceeds %d characters\n", sizeof (BEText (bi)));
			return (-1);
		}
		if (*bp == '%')			/* start of new field */
		{
			if (!isupper (bp[1]))
			{
				BRError (bi, "Bad key line\n");
				return (-1);
			}
			/*bp += 3;	/* skip to beginning of text */
			/*len -= 3;	/* adjust length of rest of line */
			if (bp[1] != 'A')
				bf = BEFldPtr (bi, bp[1]);
			else if (BEAuthCnt (bi) >= beMaxAuth)
			{
				BRError (bi, "Too many authors, only %d allowed.\n", beMaxAuth);
				return (-1);
			}
			else
				bf = BEAuthPtr (bi, BEAuthCnt (bi)++);

			BEFldStart (bf) = bp - BEText (bi);
			BEFldLen (bf) = 0;
		}
		BEFldLen (bf) += len;
		bp += len;
	}

	return (nLines);
}



static BRError (va_alist)
va_dcl
{
va_list	args;
BibEnt	*bi;
char	*fmt;

	va_start (args);
	bi = va_arg (args, BibEnt *);
	fmt = va_arg (args, char *);
	fprintf (stderr, "Error at line %D (in citation %D)\n", line, citation);
	vfprintf (stderr, fmt, args);
	if (BELen (bi) > 0)
	{
		fprintf (stderr, "Text of entry up to error:\n");
		BEWrite (stderr, bi);
	}
	va_end (args);
}
