/*
	panic - print message and die with status 1.  Uses vprintf
	so that panic can take variable argument lists.

	setpanichook - install function to be called with no arguments
	after printing panic message and before exiting.  Can be used
	for additional cleanup, like removing temp files, etc.
*/

# include	<stdio.h>
# include	<varargs.h>


static	int	(*panichook) () = NULL;

void setpanichook (p)
int	(*p) ();
{
	panichook = p;
}


void
panic (va_alist)
va_dcl
{
va_list	args;
char	*fmt;

	va_start (args);
	fmt = va_arg (args, char *);
	vfprintf (stderr, fmt, args);
	va_end (args);
	fprintf (stderr, "\n");
	if (panichook != NULL)
		(*panichook) ();
	exit (1);
}
