/*
	Compare two bibliographic entries for equality.  They do
	not need to have the fields in the same order (except that
	authors must be in the same order), just the same fields
	present, and the same information in corresponding fields.

	Returns:

	0	b1 = b2
	!0	b1 != b2

	This should be extended to allow comparison to return ordering
	information by passing in sort ordering information.

	First compare the number of authors.
	If equal, compare the authors by length and text.
	If equal, see if the same fields are present and have the same length
	and the same text.
	If equal, they're equal.
	Otherwise, not.
*/

# include	<stdio.h>
# include	"bibinfo.h"

# undef	DEBUG
# ifdef		DEBUG
# define	RETURN(x,y)	return (printf ("%s\n", x) ? y : y)
# else
# define	RETURN(x,y)	return (y)
# endif

BECmp (b1, b2)
BibEnt	*b1, *b2;
{
int	i, len, n;
BibFld	*bfp1, *bfp2;

	if ((n = BEAuthCnt (b1)) != BEAuthCnt (b2))
		RETURN ("author count", 1);
	for (i = 0; i < n; i++)
	{
		bfp1 = BEAuthPtr (b1, i);
		bfp2 = BEAuthPtr (b2, i);
		if ((len = BEFldLen (bfp1)) != BEFldLen (bfp2))
			RETURN ("author length", 1);
		if (strncmp (BEFldText (b1, bfp1), BEFldText (b2, bfp2), len))
			RETURN ("author text", 1);
	}
	for (i = 'B'; i <= 'Z'; i++)
	{
/*
	Don't have to check whether fields are present or not, since
	missing ones have length zero and will compare properly.
*/
		bfp1 = BEFldPtr (b1, i);
		bfp2 = BEFldPtr (b2, i);
		if ((len = BEFldLen (bfp1)) != BEFldLen (bfp2))
			RETURN ("field length", 1);
		if (strncmp (BEFldText (b1, bfp1), BEFldText (b2, bfp2), len))
			RETURN ("field text", 1);
	}
	RETURN ("same", 0);
}
