%% ---- TeXpp macro definitions ----
%% ----   for plain TeX files   ----
%%
%%  A macro definition should fit into a single line. If the definition is 
%%  too long, we can continue after closing the line with a backslash....
%%
%% - 1.   Greek letters  ----
%mdefine alpha		%\alpha %
%mdefine beta		%\beta %
%mdefine gamma		%\gamma %
%mdefine delta		%\delta %
%mdefine eps		%\varepsilon %
%mdefine zeta		%\zeta %
%mdefine eta		%\eta %
%mdefine theta		%\vartheta %
%mdefine iota		%\iota %
%mdefine kappa		%\kappa %
%mdefine pi		%\pi %
%mdefine rho		%\varrho %
%mdefine chi		%\chi %
%mdefine phi		%\varphi %
%mdefine psi		%\psi %
%mdefine omega		%\omega %
%mdefine GAMMA		%\Gamma %
%mdefine DELTA		%\Delta %
%mdefine LAMBDA		%\Lambda %
%mdefine PHI		%\Phi %
%mdefine SIGMA		%\Sigma %
%%
%% -2.   Mathematical functions names ----
%mdefine log		%\log %
%mdefine sin		%\sin %
%mdefine cos		%\cos %
%mdefine mod		%\bmod %		as in "i mod 2"
%%
%% -3.   Special symbols ----
%mdefine aleph		%\aleph %
%mdefine l		%\ell %			written letter
%mdefine ||		%\|%			norm sign
%mdefine oo		%\infty %		infinity
%mdefine not		%\neg %			negation sign
%mdefine EMPTY		%\emptyset %		slashed zero
%mdefine o|o		%\clubsuit %
%mdefine <>		%\diamondsuit %
%%
%%		doubly written C,N,Q and R letters for
%%		complex, natural, rational and real numbers
%mdefine IC		%\hbox{\hbox{C\hskip-0.5em\lower-0.1ex\
           \hbox{\vrule height1.34ex width0.07em }}\hskip0.50em}%

%mdefine IN		%\hbox{I\hskip-0.20em I\hskip-0.35em N}%
%mdefine IQ		%\hbox{\hbox{Q\hskip-0.525em\lower-0.097ex\
            \hbox{\vrule height1.47ex width0.07em}}\hskip0.50em}%
%mdefine IR		%\hbox{I\hskip-0.23em R}%
%%
%%		I don't like these thin signs, so I redefined them
%%mdefine ALL #1	%\forall #1 \>%
%%mdefine EXISTS #1	%\exists #1 \>%
%mdefine ALL #1		%{\leavevmode\hbox{\rm V\kern-0.53em\
\lower-.5ex\hbox{-}}\kern0.1em} #1 \>%
%mdefine EXISTS #1	%{\Xi\kern-0.37em{\bf I}} #1 \>%
%%
%% -4.   Operators ----
%mdefine /\		%\wedge %		and sign
%mdefine _/\_ 		%\bigwedge%		big and sign
%mdefine \/		%\vee %			or sign
%mdefine ~\/~		%\bigvee %		big or sign
%mdefine +-		%\pm %			plusminus
%mdefine COMP		%\circ %		small circle (composition)
%mdefine CROSS		%\times %		cross for vectors
%mdefine BULL		%\bullet %		full small circle
%mdefine dot		%\cdot %		centered dot (multiplication)
%mdefine UNION		%\cup %			small union symbol
%mdefine METS		%\cap %			small intersection symbol
%%						+/-/= sign and a dot on it
%mdefine .+.		%{\mathrel{\> +\hbox{\hskip-0.565em\
\lower-1.8ex\hbox{.}}\hskip0.4em}}%
%mdefine .-.		%{\mathrel{\> -\hbox{\hskip-0.55em\
\lower-1.2ex\hbox{.}}\hskip0.4em}}%
%mdefine .=.		%\doteq %
%%
%% -5.   Relations ----
%mdefine ==		%\equiv %		equivalence
%mdefine !==		%\not\equiv %		slashed equivalence
%mdefine !=		%\not= %		not equal
%mdefine <=		%\leq %			less than or equal to
%mdefine >=		%\geq %
%mdefine SUBS		%\subset %		subset of
%mdefine EXTS		%\supset %		extension of
%mdefine in		%\in %			element
%mdefine !in		%\notin% %		not an element
%mdefine |--		%\vdash %		proves
%mdefine !|--		%\not\vdash %		not proves
%mdefine |==		%\models %		semantically follows
%mdefine !|==		%\not\models %
%%
%% -6.   Arrows ----
%mdefine -->		%\rightarrow %
%mdefine <-->		%\leftrightarrow %
%mdefine <--		%\leftarrow %
%mdefine ==>		%\Rightarrow %
%mdefine <==>		%\Leftrightarrow %
%mdefine ==>		%\Rightarrow %
%mdefine |-->		%\mapsto %
%%
%% -7.   Miscellaneous ----
%mdefine ...		%\ldots %		ellipsis
%mdefine ...,		%\ldots,%		dots followed by a comma
%mdefine =def		% \>{\buildrel \rm def \over =}\> %
%mdefine <:		%\langle %		left angular bracket
%mdefine :>		%\rangle %		right angular bracket
%mdefine [[		%[\![%			double open [
%mdefine ]]		%]\!]%			double closing ]
%%
%mdefine #1 tilde	%\widetilde{#1}%	put a tilde 
%mdefine #1 bar		%\overline{#1}%		put a line over
%mdefine #1 hat		%\wildehat{#1}%		put a hat (^)
%mdefine #1 vec		%\overrightarrow{#1}%	put a --> at the top
%mdefine sub #1		%_{#1}%			for a subscript
%mdefine sup #1		%^{#1}%			for a superscript
%%
\def\mydisplayformula#1#2{ $$ #2 \leqno #1 $$}
%define .EQ #1		%\mydisplayformula{#1}{%
%define .EN		%}%
%dispmode .EQ .EN
%%
%define LEMMA #1	%\proclaim Lemma #1 %
%define PROOF.		%\noindent{\bf Proof.} %
%define THEOREM #1	%\proclaim Theorem #1 %
%define QED		% {\vrule height 7pt depth 1pt width 7pt} % back box
%mdefine iff		%{\ \ \rm iff \ \ }%


