# index.awk -- take a sorted LaTeX index, and produce \item and
# \subitem entries for it
#
# Robert Plamondon, March 1986
#
BEGIN	{FS = "{"
	print("\\begin{theindex}")}

# leave spaces on comment lines
$2 ~ /^%/		{print ""
			 print("\\indexspace")
			 print ""
			 next}
# Replace ! with \
#$2 ~ /^[\\]*[!]/		{while(index($2,"!") > 0)
#				 {x = index($2,"!")
#				 $2 = (substr($2,1,x-1) "\\" substr($2,x+1))}}

			{	$2 = substr($2,1,length($2)-1)
				newentry = $2
				newpage = substr($3,1,length($3)-1)
			}
# Handle subentries (entries with commas in them)
		{comma = index($2,",")
		if (comma > 0)
		 {
		  subentry = substr($2,comma+1)
		  mainentry = substr($2,1,comma-1)
		  {
		   if (mainentry != substr(oldentry,1,comma-1))
# make new major entry
		    printf("\n\\item %s %s", mainentry, newpage)
		  else
		    if (oldentry == newentry)
	  	      {
			if (oldpage != newpage)
			printf(", %s", newpage)
		      }
		    else
		       printf("\n	\\subitem %s %s", subentry,newpage)
		   } 
		}
		else	# no comma -- this is a major entry
			{
			if (oldentry == newentry)
			  {if (oldpage != newpage)
				printf(", %s", newpage)}
			else
				printf("\n\\item, %s %s", newentry,newpage)
			}
	}
		{oldpage = newpage}
		{oldentry = newentry}

END	{print("\\end{theindex}")}
