.TH TEXINDEX N "25 April 1986"
.SH NAME
texindex \- Create an index for a LATEX document
.SH SYNOPSIS
.B
texindex
file
.SH DESCRIPTION
.I LATEX
produces
.I .idx
files that contain the information that goes into the index.
.I LATEX
also has a set of macros that are used to format an index. For some reason,
the
.I .idx
file that
.I LATEX
produces has no resemblance to the input file that it requires. In addition,
the
.I .idx
file isn't sorted, doesn't have multiple page numbers per entry line, and
doesn't arrange subentries under the corresponding main entry.
.PP
.I Texindex
takes a 
.I LATEX \|.idx
file and converts it into a format that
.I LATEX
will
recognize as an index. It puts multiple page numbers on the same line, and
handles subentries properly,
.I i.e.,
.PP
	Gnus, 5-6, 25, 111
.br
	\ \ \ Habits of, 5
.br
	\ \ \ Smell, 25
.PP
Output is directed to standard out.
.PP
.I Texindex
uses two
.I awk
script and calls
.I sort
to sort the index.
.SH FILES
/usr/new/texindex	main program (a csh script)
.br
/usr/lib/tex/index.awk	first awk script
.br
/usr/lib/tex/index1.awk	second awk script
.br
/tmp/texindex.xx	temporary file
.SH BUGS
Blank space is left between entries for each letter of the
alphabet. If there are no entries for that letter, blank space
is left anyway, leaving larger gaps.
.PP
Should probably put large capitals before the entries for each letter, but
doesn't.
