# index1.awk -- takes index entries in the form:
# entry, number, number, number...
# and turns consecutive numbers into ranges, i.e., 
# gnus, 5, 6, 7, 10, 11, 15
# becomes
# gnus, 5-7, 10-11, 15
#
# Robert Plamondon, April 25, 1986
#
BEGIN	{FS = ","}
 { if (NF > 1)
   {
	{toprange = 0; field = 2; botrange = $field; field1 = 1+field}
	{ printf("%s",$1)
	  while (field < NF)
		{ 
		  while ($field1 == 1+$field)
			{ toprange = $field1; field++; field1++}

		if (toprange != 0)
			{printf(", %d-%d",botrange,toprange)
			 lasttop = toprange
			}
		else
			printf(", %d",$field)

		toprange = 0
		botrange = $field1
		field ++; field1++
		}
	if (lasttop != $NF)
		if ($NF != 0)
			printf(", %d", $NF)
	printf("\n")
	}
  }
  else print}
