#include <stdio.h>
#include <ctype.h>

#ifdef TMC
#include <ctools.h>
#else
#include "ctools.h"
#endif

#include "texchk.h"

extern Bool Verbose_Mode;

do_verbatim (keyword) char *keyword;
{
  if (0 == strcmp("verbatim",keyword))
     find_end_verbatim("\\end{verbatim}");
  else if (0 == strcmp("verbatim*",keyword))        
     find_end_verbatim("\\end{verbatim*}");
  else {
     fprintf(stderr,"Fatal error, bad argument to do_verbatim: %s\n",keyword);
     exit(1);
  }
  if (Verbose_Mode) {
     do_indent(--Indent_Level);
     fprintf(stderr,"line %d: \\end{%s}\n",Current_Line,keyword);
  }
}


do_verb () 

/* get the next character after the 'verb' or 'verb*' command, then read */
/* until we find that character again. */

{
  char endchar[2];
  int ch;
  ch = get_a_char();
  if (ch == EOF) {
     eof_verbatim_error();
     exit(1);
  }
  else if (isalpha(ch) || ch == '*' || ch == ' ' || ch == '\n') {
     verb_error(ch);
     exit(1);
  }
  endchar[0] = ch;
  endchar[1] = '\0';
  find_end_verbatim(endchar);
}


find_end_verbatim (matchstring) char *matchstring;

/* Read characters until the exact characters constituting matchstring show */
/* up in the input stream, then return.  Matchstring may not contain '\n' */

{
  static char Verbatim_Buffer[MAXLL];
  char *vbptr;
  int j,ch;
  int matchlen;
  
  matchlen = strlen(matchstring);
  
  /* matches cannot span lines, since matchstring cannot contain '\n' */
  
  newline:
  
  for (j = 0; j < MAXLL; j++) Verbatim_Buffer[j] = '\0';
  vbptr = Verbatim_Buffer; 
  
  /* Nothing can possibly match until we have read in as many characters as */
  /* there are in matchstring, so read that many in. */
  
  for (j = 0; j < matchlen; j++) {
      switch (ch = get_a_char()) {
        case '\n' :
          goto newline;
          break;
        case EOF :
          eof_verbatim_error();
          exit(1);
          break;
        default :
          Verbatim_Buffer[j] = ch;
          break;
      }
  }

  /* check for a match, then read in the next character.  Keep checking */
  /* for a match against the last 'matchlen' characters. */
  
  j = matchlen;
  while (1) {
    if (0 == strcmp(matchstring,vbptr)) {
       return(1);
    }
    switch (ch = get_a_char()) {
      case '\n' :
        goto newline;
        break;
      case EOF :
        eof_verbatim_error();
        exit(1);
        break;
      default :
        Verbatim_Buffer[j] = ch;
        break;
    }
    j++;
    vbptr++;
  }
}
