typedef struct {

   int cmdlength;
   char *cmd;
   char is_math_mode_only;
   unsigned flags;

 } Latex_Command, *Ptr_Latex_Command;


extern Latex_Command Command_Table[]; 
 
extern char *Math_Environments[];

#define COMMAND_TABLE_SIZE (sizeof(Command_Table)/sizeof(Latex_Command))

#define IS_MATH_MODE(i) (Command_Table[(i)].is_math_mode_only)

#define NOT_FOUND -1 

extern int command_lookup ();

  /* ARGUMENTS:
     char *command;
  */

  /* 'command' is the name of a presumed latex command, including the */
  /* initial backslash.   Returns NOT_FOUND if command is not in the command */
  /* table, otherwise the index into the command table of the entry for */
  /* the input command. */

extern int is_math_environment();

  /* ARGUMENTS:
     char *keyword;
  */

  /* Returns 1 or 0 */
