/* these are the types of tokens we look for in the input text */

typedef enum { 
        
        ESCAPE_BEGIN, ESCAPE_END, ESCAPE_ANY,
        LEFT_SQUARE_BRACKET, RIGHT_SQUARE_BRACKET,
        LEFT_CURLY_BRACKET, RIGHT_CURLY_BRACKET,
        MATH, DOUBLE_MATH, ESCAPE_SINGLE_CHAR

    } envtype;

/* some of the input tokens cause the LaTeX environment to be 'pushed' */
/* following is the definition of the stack on which these tokens are stored */
    
typedef struct {
   envtype etype;
   char *keyword;
   int linenum;
 } Stack_Entry, *Ptr_Stack_Entry;

#define MAX_ENTRIES 10000
#define MAX_KEYWORD_LENGTH 100
 
extern Stack_Entry Lex_Stack[];
extern int Lex_TOS;

#define Stack_Empty (Lex_TOS < 0)

#define LCB '{'
#define RCB '}'
#define LSB '['
#define RSB ']'
#define MATH_CHAR '$'
#define ESCAPE '\\'
#define COMMENT '%'

#define ENDSTRING "end"
#define BEGINSTRING "begin"

/* these are the possible actions we can take when we see a token. */
/* the 'CHECK' action has not been implemented. */

typedef enum {POP,PUSH,CHECK_SINGLE,DOLLAR,DOLLAR_DOLLAR,CHECK} Actions;

/* we keep track of where we are in the text so we can print out nice */
/* error messages */

extern long Current_Line, Current_Char;
extern char Line_Buffer[];
#define MAXLL 1024

extern Indent_Level;                    /* for verbose pretty print */

extern FILE *fp;

/* this is LaTeX's definition of whitespace */

#define ISWHITE(x) ((x) == ' ' || (x) == '\t')

#define SPACES_PER_INDENT_LEVEL 2
