#include <stdio.h>
#ifdef TMC
#include <ctools.h>
#else
#include "ctools.h"
#endif
#include "texchk.h"


print_error_line ()
{
  int j;        
  fprintf(stderr,"Error on line number %d\n",Current_Line);        
  fprintf(stderr,"\n%s\n",Line_Buffer);
  for (j = 0; j < Current_Char-1; j++) fprintf(stderr," ");
  fprintf(stderr,"^\n\n");
}


eof_error ()
{  
  fprintf(stderr,"\nActual end of file before logical end of input.\n");
  fprintf(stderr,"Current environment:\n");
  print_stack();
}

stack_empty_error (etype,keyword) envtype etype; char *keyword;

{
  char *s, *e;
  switch (etype) {
    case ESCAPE_END :
      s = "\\begin";
      e = "\\end";
      break;
    case RIGHT_SQUARE_BRACKET :
      s = "[";
      e = "]";
      break;
    case RIGHT_CURLY_BRACKET :
      s = "{";
      e = "}";
      break;
    default :
      if (*keyword == ')') {
         s = "\\(";
         e = "\\)";
         break;
      }
      else if (*keyword == ']') {
         s = "\\[";
         e = "\\]";
         break;
      }
      fprintf(stderr,"Impossible etype argument to stack_empty_error\n");
      exit(1);
  }
  fprintf(stderr,"\nNo matching %s to go with %s\n",s,e);
  print_error_line();
}


no_brace_after_begin_end_error ()
{
  fprintf (
     stderr,
     "\n'\\begin' or '\\end' construct has no '{' immediately following\n"
   );
  print_error_line();
}

warning_blanks_in_cb ()
{  
  fprintf(stderr,"\nWarning:  probable error.\n");        
  fprintf(stderr,"LaTeX does not like initial or terminating blanks\n");
  fprintf(stderr,"inside of \\begin{} or \\end{} constructs\n");
  print_error_line();
}

warning_close_brace () 
{
  fprintf(stderr,"\nWarning:  texchk cannot handle environment names that\n");
  fprintf(stderr,"span more than one line...\n");
  print_error_line();
}  

bad_char_error (ch,abort) int ch; Bool abort;
{
  fprintf(stderr,"\nIllegal character: integer value = %d\n",ch);
  print_error_line();
  if (abort) exit(1);
}  

line_too_long_error ()
{
  fprintf(stderr,"\nToo many characters: line = %d\n",Current_Line);
}

blank_begin_end_error ()
{
  fprintf(stderr,"\nNo environment defined in '\\begin{}' or '\\end{}'\n");
  print_error_line();
}

keyword_error (keyword) char *keyword;
{
  fprintf(stderr,"\nWarning: unrecognized command name: \\%s\n",keyword);
  print_error_line();
}

math_keyword_error (keyword) char *keyword;
{
  fprintf (
      stderr,
      "\nError: 'Math mode only' command used outside math mode: \\%s\n",
      keyword
   );
   print_error_line();
}


nest_error (s,e,oldlinenum,current_key) 
  char *s, *e;
  int oldlinenum;
  char *current_key;
{
  fprintf(stderr,"\nNo matching %s for %s at current nesting level\n",s,e);
  print_error_line();
  fprintf (
     stderr,"Current nesting is '%s' at line %d\n",current_key,oldlinenum
   );
}


keyword_length_error ()
{
  fprintf(stderr,"\nLaTeX command too long\n");
  print_error_line();
}


single_char_command_error (ch) char ch;
{
  fprintf(stderr,"\nThe command \\%c is not legal LaTeX\n",ch);
  print_error_line();
}


print_stack ()

{
  int j;        
  fprintf(stderr,"\n\nTEXCHK ENVIRONMENT STACK:\n\n");
  for (j = 0; j <= Lex_TOS; j++) {
      switch (Lex_Stack[j].etype) {
        case ESCAPE_BEGIN :
          fprintf(stderr,"\\begin{%s}\n",Lex_Stack[j].keyword);
          break;
        case LEFT_SQUARE_BRACKET :
          fprintf(stderr,"[\n");
          break;
        case LEFT_CURLY_BRACKET :
          fprintf(stderr,"{\n");
          break;
        case MATH :
          fprintf(stderr,"Math Mode: %s\n",Lex_Stack[j].keyword);
          break;
        case DOUBLE_MATH :
          fprintf(stderr,"Display Math Mode\n");
          break;
        default :
          fprintf(stderr,"Stack corrupted...\n");
          texit();
      }
  }
  fprintf(stderr,"\n");
}


eof_verbatim_error ()
{
  fprintf(stderr,"\nError: EOF in middle of verbatim/verb environment\n");
}


verb_error (ch) char ch;
{
  fprintf(stderr,"Error: Illegal character after \\verb command: %c\n",ch);
  print_error_line();
}
