#include "cmds.h"

Latex_Command Command_Table[] = {

        { 1, " ", '\0' },
        { 1, "!", '1' },
        { 1, "\"", '\0' },
        { 1, "#", '\0' },
        { 1, "$", '\0' },
        { 1, "%", '\0' },
        { 1, "&", '\0' },
        { 1, "'", '\0' },
        { 1, "(", '\0' },
        { 1, ")", '\0' },
        { 1, "+", '\0' },
        { 1, ",", '\0' },
        { 1, "-", '\0' },
        { 1, ".", '\0' },
        { 1, "/", '\0' },
        { 1, ":", '1' },
        { 1, ";", '1' },
        { 1, "<", '\0' },
        { 1, "=", '\0' },
        { 1, ">", '\0' },
        { 1, "@", '\0' },
        { 2, "AA", '\0' },
        { 2, "AE", '\0' },
        { 4, "Alph", '\0' },
        { 3, "Box", '1' },
        { 5, "Delta", '1' },
        { 7, "Diamond", '1' },
        { 9, "Downarrow", '1' },
        { 5, "Gamma", '1' },
        { 1, "H", '\0' },
        { 4, "Huge", '\0' },
        { 2, "Im", '1' },
        { 4, "Join", '1' },
        { 5, "LARGE", '\0' },
        { 5, "LaTeX", '\0' },
        { 6, "Lambda", '1' },
        { 5, "Large", '\0' },
        { 9, "Leftarrow", '1' },
        { 14, "Leftrightarrow", '1' },
        { 13, "Longleftarrow", '1' },
        { 18, "Longleftrightarrow", '1' },
        { 14, "Longrightarrow", '1' },
        { 1, "O", '\0' },
        { 2, "OE", '\0' },
        { 5, "Omega", '1' },
        { 1, "P", '\0' },
        { 3, "Phi", '1' },
        { 2, "Pi", '1' },
        { 2, "Pr", '1' },
        { 3, "Psi", '1' },
        { 2, "Re", '1' },
        { 10, "Rightarrow", '1' },
        { 5, "Roman", '\0' },
        { 1, "S", '\0' },
        { 5, "Sigma", '1' },
        { 3, "TeX", '\0' },
        { 5, "Theta", '1' },
        { 7, "Uparrow", '1' },
        { 11, "Updownarrow", '1' },
        { 7, "Upsilon", '1' },
        { 2, "Xi", '1' },
        { 1, "[", '\0' },
        { 1, "\\", '\0' },
        { 2, "\\*", '\0' },
        { 1, "]", '\0' },
        { 1, "^", '\0' },
        { 1, "_", '1' },
        { 1, "`", '\0' },
        { 1, "a", '\0' },
        { 2, "aa", '\0' },
        { 21, "abovedisplayshortskip", '\0' },
        { 16, "abovedisplayskip", '\0' },
        { 5, "acute", '1' },
        { 15, "addcontentsline", '\0' },
        { 7, "address", '\0' },
        { 7, "address", '\0' },
        { 13, "addtocontents", '\0' },
        { 12, "addtocounter", '\0' },
        { 11, "addtolength", '\0' },
        { 9, "addvspace", '\0' },
        { 13, "advancepageno", '\0' },
        { 2, "ae", '\0' },
        { 5, "aleph", '1' },
        { 4, "alph", '\0' },
        { 5, "alpha", '1' },
        { 5, "amalg", '1' },
        { 3, "and", '\0' },
        { 5, "angle", '1' },
        { 8, "appendix", '\0' },
        { 6, "approx", '1' },
        { 6, "arabic", '\0' },
        { 6, "arccos", '1' },
        { 6, "arcsin", '1' },
        { 6, "arctan", '1' },
        { 3, "arg", '1' },
        { 11, "arraycolsep", '\0' },
        { 14, "arrayrulewidth", '\0' },
        { 12, "arraystretch", '\0' },
        { 3, "ast", '1' },
        { 5, "asymp", '1' },
        { 6, "author", '\0' },
        { 1, "b", '\0' },
        { 9, "backslash", '1' },
        { 3, "bar", '1' },
        { 12, "baselineskip", '\0' },
        { 15, "baselinestretch", '\0' },
        { 9, "batchmode", '\0' },
        { 5, "begin", '\0' },
        { 12, "beginsection", '\0' },
        { 21, "belowdisplayshortskip", '\0' },
        { 16, "belowdisplayskip", '\0' },
        { 4, "beta", '1' },
        { 2, "bf", '\0' },
        { 9, "bibindent", '\0' },
        { 7, "bibitem", '\0' },
        { 12, "bibliography", '\0' },
        { 17, "bibliographystyle", '\0' },
        { 6, "bigcap", '1' },
        { 7, "bigcirc", '1' },
        { 6, "bigcup", '1' },
        { 7, "bigodot", '1' },
        { 8, "bigoplus", '1' },
        { 9, "bigotimes", '1' },
        { 7, "bigskip", '\0' },
        { 13, "bigskipamount", '\0' },
        { 8, "bigsqcup", '1' },
        { 15, "bigtriangledown", '1' },
        { 13, "bigtriangleup", '1' },
        { 8, "biguplus", '1' },
        { 6, "bigvee", '1' },
        { 8, "bigwedge", '1' },
        { 13, "blackandwhite", '\0' },
        { 4, "bmod", '1' },
        { 8, "boldmath", '\0' },
        { 3, "bot", '1' },
        { 14, "bottomfraction", '\0' },
        { 6, "bowtie", '1' },
        { 5, "breve", '1' },
        { 6, "bullet", '1' },
        { 3, "bye", '\0' },
        { 1, "c", '\0' },
        { 3, "cal", '1' },
        { 3, "cap", '1' },
        { 7, "caption", '\0' },
        { 2, "cc", '\0' },
        { 4, "cdot", '1' },
        { 5, "cdots", '1' },
        { 9, "centering", '\0' },
        { 7, "chapter", '\0' },
        { 7, "chapter", '\0' },
        { 5, "check", '1' },
        { 3, "chi", '1' },
        { 4, "circ", '1' },
        { 6, "circle", '\0' },
        { 7, "circle*", '\0' },
        { 4, "cite", '\0' },
        { 15, "cleardoublepage", '\0' },
        { 9, "clearpage", '\0' },
        { 9, "cleartabs", '\0' },
        { 5, "cline", '\0' },
        { 7, "closing", '\0' },
        { 8, "clubsuit", '1' },
        { 6, "colors", '\0' },
        { 11, "colorslides", '\0' },
        { 9, "columnsep", '\0' },
        { 13, "columnseprule", '\0' },
        { 4, "cong", '1' },
        { 6, "coprod", '1' },
        { 9, "copyright", '\0' },
        { 3, "cos", '1' },
        { 4, "cosh", '1' },
        { 3, "cot", '1' },
        { 4, "coth", '1' },
        { 3, "csc", '1' },
        { 3, "cup", '1' },
        { 1, "d", '\0' },
        { 3, "dag", '\0' },
        { 6, "dagger", '1' },
        { 7, "dashbox", '\0' },
        { 5, "dashv", '1' },
        { 4, "date", '\0' },
        { 20, "dblfloatpagefraction", '\0' },
        { 11, "dblfloatsep", '\0' },
        { 15, "dbltextfloatsep", '\0' },
        { 14, "dbltopfraction", '\0' },
        { 4, "ddag", '\0' },
        { 7, "ddagger", '1' },
        { 4, "ddot", '1' },
        { 5, "ddots", '1' },
        { 3, "def", '\0' },
        { 3, "deg", '1' },
        { 5, "delta", '1' },
        { 3, "det", '1' },
        { 7, "diamond", '1' },
        { 11, "diamondsuit", '1' },
        { 3, "dim", '1' },
        { 12, "displaystyle", '1' },
        { 3, "div", '1' },
        { 13, "documentstyle", '\0' },
        { 12, "dosupereject", '\0' },
        { 3, "dot", '1' },
        { 5, "doteq", '1' },
        { 7, "dotfill", '\0' },
        { 9, "downarrow", '1' },
        { 3, "ell", '1' },
        { 2, "em", '\0' },
        { 8, "emptyset", '1' },
        { 4, "encl", '\0' },
        { 3, "end", '\0' },
        { 9, "endinsert", '\0' },
        { 7, "epsilon", '1' },
        { 7, "eqalign", '\0' },
        { 9, "eqalignno", '\0' },
        { 5, "equiv", '1' },
        { 3, "eta", '1' },
        { 14, "evensidemargin", '\0' },
        { 6, "exists", '1' },
        { 3, "exp", '1' },
        { 11, "extracolsep", '\0' },
        { 4, "fbox", '\0' },
        { 8, "fboxrule", '\0' },
        { 7, "fboxsep", '\0' },
        { 4, "fill", '\0' },
        { 6, "fivebf", '\0' },
        { 5, "fivei", '\0' },
        { 6, "fiverm", '\0' },
        { 6, "fivesy", '\0' },
        { 4, "flat", '1' },
        { 17, "floatpagefraction", '\0' },
        { 8, "floatsep", '\0' },
        { 11, "flushbottom", '\0' },
        { 8, "fnsymbol", '1' },
        { 5, "folio", '\0' },
        { 10, "footheight", '\0' },
        { 8, "footline", '\0' },
        { 8, "footnote", '\0' },
        { 12, "footnotemark", '\0' },
        { 12, "footnoterule", '\0' },
        { 11, "footnotesep", '\0' },
        { 12, "footnotesize", '\0' },
        { 12, "footnotetext", '\0' },
        { 8, "footskip", '\0' },
        { 9, "footstrut", '\0' },
        { 6, "forall", '1' },
        { 4, "frac", '1' },
        { 5, "frame", '\0' },
        { 8, "framebox", '\0' },
        { 13, "frenchspacing", '\0' },
        { 5, "frown", '1' },
        { 5, "fussy", '\0' },
        { 5, "gamma", '1' },
        { 3, "gcd", '1' },
        { 3, "geq", '1' },
        { 2, "gg", '1' },
        { 8, "glossary", '\0' },
        { 13, "glossaryentry", '\0' },
        { 5, "grave", '1' },
        { 3, "hat", '1' },
        { 4, "hbar", '1' },
        { 4, "hbox", '\0' },
        { 10, "headheight", '\0' },
        { 8, "headline", '\0' },
        { 7, "headsep", '\0' },
        { 9, "heartsuit", '1' },
        { 5, "hfill", '\0' },
        { 5, "hline", '\0' },
        { 3, "hom", '1' },
        { 13, "hookleftarrow", '1' },
        { 14, "hookrightarrow", '1' },
        { 9, "hrulefill", '\0' },
        { 6, "hspace", '\0' },
        { 7, "hspace*", '\0' },
        { 4, "huge", '\0' },
        { 11, "hyphenation", '\0' },
        { 1, "i", '\0' },
        { 5, "imath", '1' },
        { 2, "in", '1' },
        { 7, "include", '\0' },
        { 11, "includeonly", '\0' },
        { 6, "indent", '\0' },
        { 5, "index", '\0' },
        { 10, "indexentry", '\0' },
        { 10, "indexspace", '\0' },
        { 3, "inf", '1' },
        { 5, "infty", '1' },
        { 5, "input", '\0' },
        { 3, "int", '1' },
        { 9, "intextsep", '\0' },
        { 9, "invisible", '\0' },
        { 4, "iota", '1' },
        { 2, "it", '\0' },
        { 4, "item", '\0' },
        { 10, "itemindent", '\0' },
        { 7, "itemsep", '\0' },
        { 1, "j", '\0' },
        { 5, "jmath", '1' },
        { 3, "jot", '\0' },
        { 5, "kappa", '1' },
        { 3, "ker", '1' },
        { 4, "kill", '\0' },
        { 1, "l", '\0' },
        { 5, "label", '\0' },
        { 10, "labelitemi", '\0' },
        { 8, "labelsep", '\0' },
        { 10, "labelwidth", '\0' },
        { 6, "lambda", '1' },
        { 6, "langle", '1' },
        { 5, "large", '\0' },
        { 5, "lceil", '1' },
        { 5, "ldots", '1' },
        { 7, "leadsto", '1' },
        { 4, "left", '1' },
        { 9, "leftarrow", '1' },
        { 7, "lefteqn", '1' },
        { 15, "leftharpoondown", '1' },
        { 13, "leftharpoonup", '1' },
        { 10, "leftmargin", '\0' },
        { 11, "leftmargini", '\0' },
        { 12, "leftmarginii", '\0' },
        { 13, "leftmarginiii", '\0' },
        { 12, "leftmarginiv", '\0' },
        { 11, "leftmarginv", '\0' },
        { 12, "leftmarginvi", '\0' },
        { 14, "leftrightarrow", '1' },
        { 3, "leq", '1' },
        { 10, "leqalignno", '\0' },
        { 6, "lfloor", '1' },
        { 2, "lg", '1' },
        { 3, "lhd", '1' },
        { 3, "lim", '1' },
        { 6, "liminf", '1' },
        { 6, "limsup", '1' },
        { 4, "line", '\0' },
        { 9, "linebreak", '\0' },
        { 13, "linethickness", '\0' },
        { 9, "linewidth", '\0' },
        { 13, "listoffigures", '\0' },
        { 12, "listoftables", '\0' },
        { 13, "listparindent", '\0' },
        { 2, "ll", '1' },
        { 2, "ln", '1' },
        { 4, "load", '\0' },
        { 3, "log", '1' },
        { 13, "longleftarrow", '1' },
        { 18, "longleftrightarrow", '1' },
        { 10, "longmapsto", '1' },
        { 14, "longrightarrow", '1' },
        { 13, "magnification", '\0' },
        { 7, "makebox", '\0' },
        { 12, "makefootline", '\0' },
        { 12, "makeglossary", '\0' },
        { 12, "makeheadline", '\0' },
        { 9, "makeindex", '\0' },
        { 9, "makelabel", '\0' },
        { 10, "makelabels", '\0' },
        { 9, "maketitle", '\0' },
        { 6, "mapsto", '1' },
        { 9, "marginpar", '\0' },
        { 13, "marginparpush", '\0' },
        { 12, "marginparsep", '\0' },
        { 14, "marginparwidth", '\0' },
        { 8, "markboth", '\0' },
        { 9, "markright", '\0' },
        { 10, "mathindent", '\0' },
        { 3, "max", '1' },
        { 4, "mbox", '\0' },
        { 7, "medskip", '\0' },
        { 13, "medskipamount", '\0' },
        { 3, "mho", '1' },
        { 3, "mid", '1' },
        { 9, "midinsert", '\0' },
        { 3, "min", '1' },
        { 3, "mit", '1' },
        { 6, "models", '1' },
        { 2, "mp", '1' },
        { 2, "mu", '1' },
        { 11, "multicolumn", '\0' },
        { 8, "multiput", '\0' },
        { 5, "nabla", '1' },
        { 7, "natural", '1' },
        { 7, "nearrow", '1' },
        { 3, "neg", '1' },
        { 3, "neq", '1' },
        { 10, "newcommand", '\0' },
        { 10, "newcounter", '\0' },
        { 14, "newenvironment", '\0' },
        { 7, "newfont", '\0' },
        { 9, "newlength", '\0' },
        { 7, "newline", '\0' },
        { 7, "newpage", '\0' },
        { 10, "newsavebox", '\0' },
        { 10, "newtheorem", '\0' },
        { 2, "ni", '1' },
        { 6, "nocite", '\0' },
        { 7, "nofiles", '\0' },
        { 8, "noindent", '\0' },
        { 11, "nolinebreak", '\0' },
        { 16, "nonfrenchspacing", '\0' },
        { 8, "nonumber", '\0' },
        { 11, "nopagebreak", '\0' },
        { 13, "nopagenumbers", '\0' },
        { 12, "normalbottom", '\0' },
        { 15, "normalmarginpar", '\0' },
        { 10, "normalsize", '\0' },
        { 3, "not", '1' },
        { 2, "nu", '1' },
        { 10, "numberline", '\0' },
        { 7, "nwarrow", '1' },
        { 1, "o", '1' },
        { 13, "oddsidemargin", '\0' },
        { 4, "odot", '1' },
        { 2, "oe", '\0' },
        { 4, "oint", '1' },
        { 8, "oldstyle", '\0' },
        { 5, "omega", '1' },
        { 6, "ominus", '1' },
        { 9, "onecolumn", '\0' },
        { 9, "onlynotes", '\0' },
        { 10, "onlyslides", '\0' },
        { 7, "opening", '\0' },
        { 5, "oplus", '\0' },
        { 6, "oslash", '1' },
        { 6, "otimes", '1' },
        { 6, "output", '\0' },
        { 4, "oval", '\0' },
        { 9, "overbrace", '\0' },
        { 8, "overline", '\0' },
        { 8, "pagebody", '\0' },
        { 9, "pagebreak", '\0' },
        { 12, "pagecontents", '\0' },
        { 10, "pageinsert", '\0' },
        { 6, "pageno", '\0' },
        { 13, "pagenumbering", '\0' },
        { 7, "pageref", '\0' },
        { 9, "pagestyle", '\0' },
        { 3, "par", '\0' },
        { 9, "paragraph", '\0' },
        { 8, "parallel", '1' },
        { 6, "parbox", '\0' },
        { 9, "parindent", '\0' },
        { 6, "parsep", '\0' },
        { 7, "parskip", '\0' },
        { 4, "part", '\0' },
        { 7, "partial", '1' },
        { 9, "partopsep", '\0' },
        { 4, "perp", '1' },
        { 3, "phi", '1' },
        { 2, "pi", '1' },
        { 11, "plainoutput", '\0' },
        { 2, "pm", '1' },
        { 4, "pmod", '1' },
        { 7, "poptabs", '\0' },
        { 6, "pounds", '\0' },
        { 4, "prec", '1' },
        { 6, "preceq", '1' },
        { 5, "prime", '1' },
        { 4, "prod", '1' },
        { 6, "propto", '1' },
        { 7, "protect", '\0' },
        { 2, "ps", '\0' },
        { 3, "psi", '1' },
        { 8, "pushtabs", '\0' },
        { 3, "put", '\0' },
        { 12, "raggedbottom", '\0' },
        { 12, "raggedbottom", '\0' },
        { 10, "raggedleft", '\0' },
        { 11, "raggedright", '\0' },
        { 8, "raisebox", '\0' },
        { 6, "rangle", '1' },
        { 5, "rceil", '1' },
        { 3, "ref", '\0' },
        { 14, "refstepcounter", '\0' },
        { 12, "renewcommand", '\0' },
        { 16, "renewenvironment", '\0' },
        { 16, "reversemarginpar", '\0' },
        { 6, "rfloor", '1' },
        { 3, "rhd", '1' },
        { 3, "rho", '1' },
        { 5, "right", '1' },
        { 10, "rightarrow", '1' },
        { 16, "rightharpoondown", '1' },
        { 14, "rightharpoonup", '1' },
        { 17, "rightleftharpoons", '1' },
        { 11, "rightmargin", '\0' },
        { 2, "rm", '\0' },
        { 5, "roman", '\0' },
        { 4, "rule", '\0' },
        { 8, "samepage", '\0' },
        { 7, "savebox", '\0' },
        { 4, "sbox", '\0' },
        { 2, "sc", '\0' },
        { 10, "scriptfont", '\0' },
        { 16, "scriptscriptfont", '\0' },
        { 17, "scriptscriptstyle", '1' },
        { 10, "scriptsize", '\0' },
        { 11, "scriptstyle", '1' },
        { 7, "searrow", '1' },
        { 3, "sec", '1' },
        { 7, "section", '\0' },
        { 10, "setcounter", '\0' },
        { 9, "setlength", '\0' },
        { 8, "setminus", '1' },
        { 7, "settabs", '\0' },
        { 10, "settowidth", '\0' },
        { 7, "sevenbf", '\0' },
        { 6, "seveni", '\0' },
        { 7, "sevensy", '\0' },
        { 2, "sf", '\0' },
        { 5, "sharp", '1' },
        { 10, "shortstack", '\0' },
        { 5, "sigma", '1' },
        { 9, "signature", '\0' },
        { 9, "signature", '\0' },
        { 3, "sim", '1' },
        { 5, "simeq", '1' },
        { 3, "sin", '1' },
        { 4, "sinh", '1' },
        { 2, "sl", '\0' },
        { 6, "sloppy", '\0' },
        { 5, "small", '\0' },
        { 9, "smallskip", '\0' },
        { 15, "smallskipamount", '\0' },
        { 5, "smile", '\0' },
        { 5, "space", '\0' },
        { 9, "spadesuit", '1' },
        { 5, "sqcap", '1' },
        { 5, "sqcup", '1' },
        { 4, "sqrt", '1' },
        { 8, "sqsubset", '1' },
        { 10, "sqsubseteq", '1' },
        { 8, "sqsupset", '1' },
        { 10, "sqsupseteq", '1' },
        { 2, "ss", '\0' },
        { 8, "stackrel", '1' },
        { 4, "star", '1' },
        { 11, "stepcounter", '\0' },
        { 4, "stop", '\0' },
        { 7, "stretch", '\0' },
        { 7, "subitem", '\0' },
        { 12, "subparagraph", '\0' },
        { 10, "subsection", '\0' },
        { 6, "subset", '1' },
        { 8, "subseteq", '1' },
        { 10, "subsubitem", '\0' },
        { 13, "subsubsection", '\0' },
        { 4, "succ", '1' },
        { 6, "succeq", '1' },
        { 3, "sum", '1' },
        { 3, "sup", '1' },
        { 6, "supset", '1' },
        { 8, "supseteq", '1' },
        { 4, "surd", '1' },
        { 7, "swarrow", '1' },
        { 6, "symbol", '\0' },
        { 1, "t", '\0' },
        { 8, "tabalign", '\0' },
        { 10, "tabbingsep", '\0' },
        { 9, "tabcolsep", '\0' },
        { 15, "tableofcontents", '\0' },
        { 4, "tabs", '\0' },
        { 8, "tabsdone", '\0' },
        { 6, "tabset", '\0' },
        { 3, "tan", '1' },
        { 4, "tanh", '1' },
        { 3, "tau", '1' },
        { 4, "teni", '\0' },
        { 12, "textfloatsep", '\0' },
        { 8, "textfont", '\0' },
        { 12, "textfraction", '\0' },
        { 10, "textheight", '\0' },
        { 9, "textstyle", '1' },
        { 9, "textwidth", '\0' },
        { 6, "thanks", '\0' },
        { 3, "the", '\0' },
        { 7, "thepage", '\0' },
        { 5, "theta", '1' },
        { 10, "thicklines", '\0' },
        { 9, "thinlines", '\0' },
        { 13, "thispagestyle", '\0' },
        { 5, "tilde", '1' },
        { 5, "times", '1' },
        { 4, "tiny", '\0' },
        { 5, "title", '\0' },
        { 5, "title", '\0' },
        { 5, "today", '\0' },
        { 3, "top", '1' },
        { 11, "topfraction", '\0' },
        { 6, "topins", '\0' },
        { 9, "topinsert", '\0' },
        { 9, "topmargin", '\0' },
        { 6, "topsep", '\0' },
        { 7, "topskip", '\0' },
        { 8, "triangle", '1' },
        { 12, "triangleleft", '1' },
        { 13, "triangleright", '1' },
        { 2, "tt", '\0' },
        { 9, "twocolumn", '\0' },
        { 6, "typein", '\0' },
        { 7, "typeout", '\0' },
        { 1, "u", '\0' },
        { 10, "unboldmath", '\0' },
        { 10, "underbrace", '\0' },
        { 9, "underline", '\0' },
        { 10, "unitlength", '\0' },
        { 5, "unlhd", '1' },
        { 5, "unrhd", '1' },
        { 7, "uparrow", '1' },
        { 11, "updownarrow", '1' },
        { 5, "uplus", '1' },
        { 7, "upsilon", '1' },
        { 6, "usebox", '\0' },
        { 10, "usecounter", '\0' },
        { 1, "v", '\0' },
        { 5, "value", '\0' },
        { 10, "varepsilon", '1' },
        { 6, "varphi", '1' },
        { 5, "varpi", '1' },
        { 6, "varrho", '1' },
        { 8, "varsigma", '1' },
        { 8, "vartheta", '1' },
        { 4, "vbox", '\0' },
        { 5, "vdash", '1' },
        { 5, "vdots", '1' },
        { 3, "vec", '1' },
        { 6, "vector", '\0' },
        { 3, "vee", '1' },
        { 4, "verb", '\0' },
        { 5, "verb*", '\0' },
        { 5, "vfill", '\0' },
        { 9, "vfootnote", '\0' },
        { 5, "vline", '\0' },
        { 6, "vspace", '\0' },
        { 7, "vspace*", '\0' },
        { 5, "wedge", '1' },
        { 7, "widehat", '1' },
        { 9, "widetilde", '1' },
        { 2, "wp", '1' },
        { 2, "wr", '1' },
        { 2, "xi", '1' },
        { 4, "zeta", '1' },
        { 1, "{", '\0' },
        { 1, "|", '1' },
        { 1, "}", '\0' },
        { 1, "~", '\0' }

   };


char *Math_Environments[] = {   
   
     "math",
     "displaymath",
     "equation",
     "eqnarray",
     "eqnarray*",
     0

  };
   

int is_math_environment (keyword) char *keyword;  
{
  char **mathenvs = Math_Environments;
  while (*mathenvs != 0) {
    if (0 == strcmp(*mathenvs,keyword)) return(1);
    mathenvs++;
  }
  return(0);
}

  
int command_lookup (command) char *command;

{
  int head = 0;
  int tail = COMMAND_TABLE_SIZE - 1;
  int mid,result;
        
  while (head <= tail) {
    mid = head + (tail - head) / 2;
    result = strcmp(command,Command_Table[mid].cmd);
    if (result > 0)
       head = mid + 1;
    else if (result < 0)
       tail = mid - 1;
    else
       return(mid);
  }
  return(NOT_FOUND);
}
  
