# include	"sp.h"


/*
** add
** Add an entry into list of words to be added to personal dict
*/
add (word_num)
int	word_num;
{
	extern	char	*add_words[], *bad_words[], *good_words[];
	extern	int	num_added;

	safe_copy (& (add_words[num_added++]), bad_words[word_num]);
	safe_copy (& (good_words[word_num]), bad_words[word_num]);
}


/*
** ask_action
** Ask the user what to do after processing words
*/
ask_action () {
	extern	int	num_bad;
	boolean	done;

	done = False;
	while (!done) {
		page_clear (0, False);
		mvaddstr (3, 0, "Action? [#^?] ");
		refresh ();

		switch (getch ()) {
			case ' ': case '\n': case '\r':
			case '#':
				done = True;
				addstr ("Next Document"); refresh ();
				if (ask_save (num_bad) == 1) return (0);
				else return (2);
			case '^':
				done = True;
				addstr ("Previous Document"); refresh ();
				if (ask_save (num_bad) == 1) return (-1);
				else return (-2);
			case '?':
				addstr ("Help!"); refresh ();
				mvaddstr (5, 10, "# --- Go to next document (or exit)");
				mvaddstr (6, 10, "^ --- Go to previous document (or re-spell this one)");
				mvaddstr (7, 10, "? --- This help message");
				ask_more ();
			default:
				break;
		}
	}
	return (0);
}


/*
** ask_save
** Ask user if he/she wants to save these changes
*/
ask_save (word_num)
int	word_num;
{
	extern	int	num_ignored;
	char	ch;

	if (word_num == num_ignored) return (0);
	mvaddstr (7, 0, "Do you wish to save your changes? [y] ");
	refresh ();
	if ( (ch = getch ()) == 'n' || ch == 'N' ) return (0);
	return (1);
}


/*
** correct
** Get correct spelling for a word
*/
word_correct (word_num)
int	word_num;
{
	extern	char	*good_words[];

	mvaddstr (7, 0, "****** Proper spelling: "); refresh();
	echo(); nocrmode(); refresh ();

	if (good_words[word_num] == NULL)
		good_words[word_num] = sfalloc ((unsigned) MAX_WORD_LEN + 1);
	fgets (good_words[word_num], MAX_WORD_LEN + 1, stdin);
	good_words[word_num][strlen (good_words[word_num]) - 1] = '\0';

	crmode (); noecho ();
	ask_more (); page_clear (word_num + 1, True);
}


/*
** help
** Give user some help with commands
*/
help (word_num)
int	word_num;
{
	mvaddstr ( 7, 10, "     I --- Ignore all occurrences of word");
	mvaddstr ( 8, 10, "     L --- Lookup a sub-string in the dictionary");
	mvaddstr ( 9, 10, "     W --- show Where word occurs in the document");
	mvaddstr (10, 10, "     A --- Add word to your personal dictionary");
	mvaddstr (11, 10, "     C --- Correct all occurrences of the word");
	mvaddstr (12, 10, "     ^ --- go to previous document (or re-spell this one)");
	mvaddstr (13, 10, "     # --- go to next document (or exit)");
	mvaddstr (14, 10, "     + --- go to next word");
	mvaddstr (15, 10, "     - --- go to previous word");
	mvaddstr (16, 10, " ?,  H --- this help message");
	mvaddstr (17, 10, "^R, ^L --- redraw the screen");
	ask_more ();
	page_clear (word_num + 1, False);
}


/*
** ignore
** Ignore the word (i.e. don't substitute for it)
*/
ignore (word_num)
int	word_num;
{
	extern	char	*good_words[], *bad_words[];
	extern	int	num_ignored;

	safe_copy (& (good_words[word_num]), bad_words[word_num]);
	num_ignored++;
}


/*
** lookup
** Look up string in the dictionary
*/
lookup (word_num)
int	word_num;
{
	char	hold_str[MAX_WORD_LEN + 1],
		command[BUFSIZ];

	mvaddstr (7, 0, "****** Lookup string: ");
	refresh ();

	echo (); nocrmode (); gets (hold_str);
	move (8, 0); clrtobot (); move (8, 0); refresh ();

	sprintf (command, "%s -df %s %s | %s", LOOK, hold_str, LOOK_DICT,
		MORE);
	system (command);

	crmode (); noecho (); ask_more ();
	page_clear (word_num + 1, True);
}
