# include	"sp.h"
# include	<signal.h>


/*
** ask_more
** Prompt the user to continue.
*/
ask_more () {
	move (23,0); clrtoeol ();
	standout ();
	mvaddstr (23, 29, "Hit any key to continue");
	standend ();
	refresh (); getch ();
}


/*
** check_dict
** Check for existence/read permission on dictionary.
*/
check_dict () {
	extern	char	*local_dict;

	if ( access (local_dict, 4) == 0 )		/* Read permission */
		return (1);
	else
		if ( access (local_dict, 0) != 0 )	/* Existence check */
			return (0);
		else
			return (-1);
}


/*
** curse_die
** Die with an explanation when inside of curses
*/
curse_die (string)
char	*string;
{
	extern	int	errno, exit_val;
	extern	char	*sys_errlist[];
	char	line[256];

	sprintf (line, "Fatal Error, %s:%s", string, sys_errlist[errno]);
	message (True, line);
	exit_val = Error; leave ();
}


/*
** fname
** Print out the page header (file name, etc.)
*/
fname () {
	extern	char	*spell_doc;
	erase ();
	mvaddstr (0, (65 - strlen (spell_doc)) / 2, /* (80-overhead-len) / 2 */
		"[ --- ");
	standout ();
	addch (' '); addstr (spell_doc); addch (' ');
	standend ();
	addstr (" --- ]");
}


/*
** free2
** Free a list of strings
*/
free2 (args, max)
register char	**args;
register int	max;
{
	while (*args && max-- > 0) free (*args++);
}


/*
** init
** Initialize the screen and take care of nasty signals
*/
init () {
	extern	char	*bad_words[], *good_words[], *add_words[];
	register int	i;

	for (i=0; i < MAX_WORDS; i++) {
		bad_words[i] = good_words[i] = add_words[i] = NULL;
	}

	signal (SIGINT, leave); signal (SIGQUIT, leave);

	initscr (); crmode (); noecho ();

	mvaddstr ( 9,30, VERSION1);
	mvaddstr (10,28, VERSION2);
	mvaddstr (11,31, VERSION3);

	move (0,0); refresh (); sleep (1);
}


/*
** leave
** Clean up curses and exit.
*/
void	leave () {
	extern	char	tmp_file[];
	extern	int	exit_val;

	unlink (tmp_file);
	clear (); move (23,0); refresh (); endwin ();
	exit (exit_val);
}


/*
** message
** Write message on the screen
*/
message (error, line)
boolean	error;
char	*line;
{
	page_clear (0, False);

	if (error) {
		addch ('\07');
		mvaddstr (3, (78 - strlen (line)) / 2, line);
		move (0,0);
		refresh (); sleep (3);
	}
	else {
		mvaddstr (3, (78 - strlen (line)) / 2, line);
		refresh (); sleep (2);
	}
}


/*
** page_clear
** Clear part of the screen and display the number
** of the current word
*/
page_clear (word_num, cls)
int	word_num;
boolean	cls;
{
	extern	int	num_bad;
	char	str[20];

	if (cls)
		clear ();
	fname ();
	if (word_num) {
		sprintf (str, "Word #%d of %d", word_num, num_bad);
		mvaddstr (23, 79 - strlen (str), str);
		mvaddstr (23, 0, VERSION1);
	}
	move (3, 0);
	refresh ();
}


/*
** reset_data
** Reset all global data
*/
reset_data () {
	extern	char	*bad_words[], *good_words[], *add_words[];
	extern	int	num_bad, num_added, num_ignored;
	register int	i;

	for (i = 0; i < MAX_WORDS; i++) {
		if (bad_words[i] != NULL) {
			free (bad_words[i]); bad_words[i] = NULL;
		}
		if (good_words[i] != NULL) {
			free (good_words[i]); good_words[i] = NULL;
		}
		if (add_words[i] != NULL) {
			free (add_words[i]); add_words[i] = NULL;
		}
	}

	num_bad = num_added = num_ignored = 0;
}


/*
** safe_copy
** A pre-malloc'd copy from one string to another
*/
safe_copy (string1, string2)
char	**string1,
	*string2;
{
	if (*string1 == NULL)
		*string1 = sfalloc ((unsigned) strlen (string2) + 1);
	strcpy (*string1, string2);
}


/*
** save
** Save changes made to document
*/
save (spell_val)
int	spell_val;
{
	extern	int	num_bad, num_added, num_ignored;

	if (num_added)
		add_local ();
	if (num_bad == (num_added + num_ignored))
		message (False, "No corrections made");
	else
		if (spell_val == 0) doc_correct ();
}


/*
** rest_ignore
** When user exits before viewing all the words, set the rest
** of the words to ignore.
*/
rest_ignore () {
	extern	char	*bad_words[], *good_words[];
	extern	int	num_bad;
	register int	i;

	for (i = num_bad - 1; !good_words[i]; ignore (i--));
}


/*
** sfalloc
** A safe malloc ()
*/
char	*sfalloc (num_bytes)
unsigned	num_bytes;
{
	char	*calloc (), *hold;

	if (num_bytes == 0) return ((char *) NULL);

	if ( (hold = calloc (1, num_bytes)) == NULL)
		curse_die ("calloc");

	return (hold);
}


/*
** usage
** Print out program usage statement and exit.
*/
usage (name)
char	*name;
{
	fprintf (stderr,
	"Usage: %s [ -d dictionary ] [ -w window_size ] file [ file2 ... ]\n",
		name);
	exit (1);
}
