# include	"sp.h"

/*
** user_input -- user interface for correcting mis-spelled words
*/
user_input () {
	extern	char	*bad_words[], *good_words[];
	extern	int	num_bad;
	char	string[MAX_WORD_LEN + 64];
	boolean	done;
	register int	loop;

	for (loop = 0; loop < num_bad; loop++) {
		page_clear (loop + 1, False);
		sprintf (string, "Word ``%s'' is not in the dictionary",
			bad_words[loop]);
		mvaddstr (3, 0, string); refresh ();

		done = False;
		do {
			sprintf (string, "(%s) [ilwac^#+-?] ", bad_words[loop]);
			mvaddstr (5, 0, string); refresh ();

			switch (getch ()) {
				case 'I':
				case 'i':
				case ' ':
				case '\n':
				case '\r':
					addstr ("Ignore"); refresh ();
					done = True; ignore (loop);
					break;
				case 'L':
				case 'l':
					addstr ("Lookup"); refresh ();
					lookup (loop);
					break;
				case 'W':
				case 'w':
					addstr ("Where"); refresh ();
					where (loop);
					break;
				case 'A':
				case 'a':
					addstr ("Add"); refresh ();
					done = True; add (loop);
					break;
				case 'C':
				case 'c':
					addstr ("Correct"); refresh ();
					done = True; word_correct (loop);
					break;
				case '^':
					addstr ("Previous Document");
					refresh ();
					if (ask_save (loop) == 1)
						return (-1);
					else
						return (-2);
				case '#':
					addstr ("Next Document");
					refresh ();
					if (ask_save (loop) == 1)
						return (1);
					else
						return (2);
				case '+':
					addstr ("Next Word");
					refresh ();
					done = True;
					if (good_words[loop] == NULL)
						ignore (loop);
					break;
				case '-':
					addstr ("Previous Word");
					refresh ();
					done = True;
					if (loop > 0) loop -=2;
					else --loop;
					break;
				case 'H':
				case 'h':
				case '?':
					addstr ("Help!"); refresh ();
					help (loop);
					break;
				case CTRL_L:
				case CTRL_R:
					page_clear (loop + 1, True);
					break;
				default:
					page_clear (loop + 1, False);
					break;
			}
		} while (!done);
	}
	return (ask_action ());
}
