# include	"sp.h"

/*
** spell
** Run spell(1) on the file and check personal dictionary also.
** Establishes the original list of mis-spelled words
*/
spell () {
	extern	char	*bad_words[], *spell_doc, *local_dict;
	extern	int	num_bad;
	extern	boolean	local;
	FILE	*popen (), *spell_out;
	char	command[256];
	int	ypos, xpos, ret_val;
	register int	i;

	clear (); fname ();

	if (access (spell_doc, 0) != 0) {	/* Check for existence */
		sprintf (command, "Cannot access file %s!", spell_doc);
		message (True, command);
		return (-1);
	}

	ret_val = 0;
	if (access (spell_doc, 6) != 0) {		/* Read and write */
		if (access (spell_doc, 4) != 0) {	/* Read */
			sprintf (command, "You are unable to read %s!",
				spell_doc);
			message (True, command);
			return (-1);
		}
		message (True, "You are unable to write to this file!");
		mvaddstr (5,22, "I will check spelling, but you will");
		mvaddstr (6,22, "not be able to save any corrections.");
		ret_val = 1;
		move (0,0); refresh (); sleep (3); fname ();
	}

	mvaddstr (3,0, "Checking spelling ..."); refresh ();

	/*
	** Get the list of mis-spelled words
	*/
	if (local)
		sprintf (command, "%s %s | %s -v -f %s", SPELL, spell_doc,
			FGREP, local_dict);
	else
		sprintf (command, "%s %s", SPELL, spell_doc);

	spell_out = popen (command, "r");

	for (i = 0; i < MAX_WORDS; i++) {
		bad_words[i] = sfalloc ((unsigned) MAX_WORD_LEN);
		if (fgets (bad_words[i], MAX_WORD_LEN, spell_out) == NULL)
			break;
		else
			bad_words[i][strlen (bad_words[i]) - 1] = '\0';
	}
	fflush (spell_out); pclose (spell_out);

	if ((num_bad = i) >= MAX_WORDS) {
		getyx (stdscr, ypos, xpos);
		sprintf (command, "You have more than %d mis-spelled words.",
			MAX_WORDS);
		mvaddstr (5, 10, command);
		strcpy (command, "Run this again after corrections are made.");
		mvaddstr (6, 10, command);
		move (ypos, xpos); refresh (); sleep (2);
	}

	addstr (" done"); refresh ();

	if (num_bad <= 0) {
		mvaddstr (5,0, "No spelling errors.");
		move (0,0); refresh (); sleep (1);
	}
	return (ret_val);
}
