# include	"sp.h"

/*
** sp main program
** Uses spell(1) to check the spelling of a document.
** The user is prompted with each of the mis-spelled words and
** can ignore them, add them to a personal dictionary, correct
** them, look up words in the dictionary, or find out where in
** the file the word is found.  Corrections are made to the
** document via ex(1).
**
** Author: Andrew Large
**	December 1986	(First Edition)
**	October 1988	(Current Version)
*/

main (argc, argv)
int	argc;
char	*argv[];
{
	extern	int	exit_val;
	extern	char	*spell_doc;
	int	spell_val, start_pos;
	register int	pos;

	/*
	** Parse input arguments and initialize
	** curses and signals
	*/
	parse (argc, argv, &start_pos);
	init ();

	/*
	** Main loop.  Keep going until user leaves the last document.
	*/
	pos = start_pos;
	while (pos < argc) {
		reset_data ();		/* Clean lists and reset globals */
		spell_doc = argv[pos];

		if ( (spell_val = spell ()) >= 0 ) {
			switch (user_input ()) {
				case -1:	/* previous doc, save */
					rest_ignore ();
					save (spell_val);
				case -2:	/* previous doc, no save */
					if (pos > start_pos) --pos;
					break;
				case 0:		/* normal exit with save */
				case 1:		/* early exit with save */
					rest_ignore ();
					save (spell_val);
				case 2:		/* early exit, no save */
				default:
					++pos;
					break;
			}
		}
		else {
			++pos;
			exit_val = Error;
		}
	}
	leave ();
}
