# include "sp.h"
# include <ctype.h>
# define	LEAVE	{\
	fclose (fp); free2 (window, window_size);\
	page_clear (word_num+1, True); return;\
}
# define	letter(ch)	(isalpha (ch) || ch == '.')

/*
** where
** Show where a word occurs in the document with surrounding context.
*/
where (word_num)
int	word_num;
{
	extern	char	*bad_words[], *spell_doc;
	extern	char	sys_errlist[];
	extern	int	errno, window_size;
	FILE	*fp;
	char	*window[MAX_WINDOW], line[BUFSIZ], *word;
	boolean	done = False;
	int	mid;
	register int	i, nlines;

	move (7,0); clrtobot (); move (7,0); refresh ();
	if ((fp = fopen (spell_doc, "r")) == NULL) {
		sprintf (line, "Can't open %s for read: %s", spell_doc,
			sys_errlist[errno]);
		message (True, line);
		ask_more (); page_clear (word_num + 1, True); return;
	}

	for (i=0; i < window_size; window[i++] = NULL);
	word = bad_words[word_num];
	nlines = ctx_open (fp, window, window_size);
	mid = nlines / 2;

	for (i=0; i < mid; i++)
		if (ctx_display (window, word, nlines, i)) LEAVE

	while (!done) {
		if (ctx_display (window, word, nlines, mid)) LEAVE
		done = ctx_step (fp, window, window_size);
	}

	for (i=mid+1; i < nlines; i++)
		if (ctx_display (window, word, nlines, i)) LEAVE
	LEAVE
}


/*
** ctx_display
** If the interest line has the word in it, then display the identified
** window with the word in reverse video.  Return True if the user doesn't
** want to see any more occurances.
*/
ctx_display (window, word, nlines, chkline)
char	*window[], *word;
int	nlines, chkline;
{
	int	beg, end;
	register int	line, ch;
	char	c;

	word_in (window[chkline], word, &beg, &end);
	if (beg != -1) {
		for (line = 0; line < chkline; line++)
			mvaddstr (line+7, 0, window[line]);

		for (ch = 0; ch < beg; ch++)
			mvaddch (chkline+7, ch, window[chkline][ch]);
		standout ();
		for (ch = beg; ch <= end; ch++)
			mvaddch (chkline+7, ch, window[chkline][ch]);
		standend ();
		for (ch = end+1; window[chkline][ch]; ch++)
			mvaddch (chkline+7, ch, window[chkline][ch]);

		for (line = chkline + 1; line < nlines; line++)
			mvaddstr (line+7, 0, window[line]);

		mvaddstr (23,0,
			"Hit any key for next occurrence, <Esc> to return: ");
		refresh ();

		if (getch() != ESC)
			return False;
		else
			return True;
	}
	return False;
}


/*
** ctx_open
** Open a context window of n lines.  Return the number of
** lines read in.
*/
ctx_open (fp, window, n)
FILE	*fp;
char	*window[];
int	n;
{
	register int	i;
	char	line[BUFSIZ+1];

	for (i=0; i < n; i++) {
		if (fgets (line, BUFSIZ+1, fp) == NULL) return i;
		safe_copy (&window[i], line);
	}
	return n;
}


/*
** ctx_step
** Move down the context window by one line
*/
ctx_step (fp, window, n)
FILE	*fp;
char	*window[];
int	n;
{
	char	line[BUFSIZ+1];
	register int	i;

	if (fgets (line, BUFSIZ+1, fp) == NULL) return True;

	free (window[0]);
	for (i=0; i < (n-1); i++)
		window[i] = window[i+1];

	window[n-1] = NULL;
	safe_copy (&window[n-1], line);

	return False;
}


/*
** word_in
** If the given word occurs in the string, return the starting
** and ending indices.  May show a few occurances _not_ found
** by spell.
*/
word_in (line, word, beg, end)
char	*line, *word;
int	*beg, *end;
{
	register int	i, len;

	*beg = *end = -1;
	len = strlen (word);

	if (strncmp (line, word, len) == 0 && !letter (line[len])) {
		*beg = 0; *end = len - 1;
		return;
	}

	/*
	** 1. Skip past current word
	** 2. Skip to beginning of next word
	** 3. If this is not the correct word, go back to 1.
	*/
	i=0;
	while (line[i]) {
		while (letter (line[i])) i++;
		while (line[i] && !letter (line[i])) i++;
		if (line[i] && strncmp (&line[i], word, len) == 0 &&
		    !letter (line[i+len])) {
			*beg = i; *end = i + len - 1;
			return;
		}
	}
}
