# include	"sp.h"

/*
** parse
** Parse input for -d and -w options and establish whether
** or not a personal dictionary exists
*/
parse (argc, argv, place)
int	argc, *place;
char	*argv[];
{
	extern	char	*optarg, *local_dict;
	extern	int	optind, window_size;
	extern	boolean	local;
	char	*getenv (), getopt ();
	int	option;

	if (argc < 2) usage (argv[0]);

	local = False; window_size = 5;
	while ((option = getopt (argc, argv, "d:w:")) != EOF)
		switch (option) {
			case 'd':
				local_dict =
				    sfalloc ((unsigned) strlen (optarg) + 1);
				strcpy (local_dict, optarg);
				local = True;
				break;
			case 'w':
				if ((window_size = atoi (optarg)) < 1)
					window_size = 1;
				else if (window_size > MAX_WINDOW)
					window_size = MAX_WINDOW;
				break;
			case '?':
			default:
				usage (argv[0]);
		}

	if (argv[optind] == NULL)
		usage (argv[0]);

	if (!local)
		if (getenv ("DICT") != NULL)
			local_dict = getenv ("DICT");
		else
			local_dict = "./spelldict";

	switch (check_dict ()) {
		case 1:
			local = True;
			break;
		case 0:
			local = False;
			printf ("\nYour local dictionary %s does not exist.",
				local_dict);
			printf ("\nI may try to create it later ...");
			fflush (stdout);
			sleep (2);
			break;
		case -1:
			local = False;
			printf ("\nYour local dictionary %s is not readable.",
				local_dict);
			printf ("\nI may try to write to it later ...");
			fflush (stdout);
			sleep (2);
			break;
	}
	*place = optind;
}
