# include	"sp.h"

/*
** add_local
** Add all words in correct list to personal dictionary
** and sort the dictionary.
*/
add_local () {
	extern	char	*add_words[], *local_dict, tmp_file[];
	extern	int	num_added;
	extern	boolean	local;
	char	*mktemp (), string[256];
	FILE	*fopen (), *tmp_ptr;
	register int	loop;

	if ( access (local_dict, 0) == 0 && access (local_dict, 2) != 0 ) {
		sprintf (string,
			"Your local dictionary \"%s\" is not writable!",
			local_dict);
		message (True, string);
		return;
	}

	strcpy (tmp_file, "/tmp/spXXXXXX");
	if ((tmp_ptr = fopen (mktemp (tmp_file), "w")) == NULL) {
		sprintf (string, "Can't open tmp file \"%s\" for writing!",
			tmp_file);
		message (True, string);
		return;
	}

	for (loop = 0; loop < num_added; loop++)
		fprintf (tmp_ptr, "%s\n", add_words[loop]);
	fflush (tmp_ptr); fclose (tmp_ptr);

# ifdef BSD
	if (vfork () == 0) {
# else
	if (fork () == 0) {
# endif
		if (local)
			execl (SORT, "sort", "-f", "-m", "-o", local_dict,
				local_dict, tmp_file, (char *) NULL);
		else
			execl (SORT, "sort", "-f", "-m", "-o", local_dict,
				tmp_file, (char *) NULL);
		perror (SORT);
		_exit (-1);
	}

	wait (0);
	sprintf (string, "%d %s added to %s", num_added,
		(num_added == 1 ? "word" : "words"), local_dict);
	message (False, string);
}
