/********************************************************/
/*							*/
/*	ro_setp.c	set parameters and other 	*/
/*			routines for ro			*/
/*							*/
/*	ro version 1.00					*/
/*							*/
/*	Portions copyright (c) 1989 by Ted A. Campbell	*/
/*		Bywater Software			*/
/*		P. O. Box 4023				*/
/*		Duke Station				*/
/*		Durham, NC  27706			*/
/*							*/
/*	Contains portions of ROFF4, Version 1.60	*/
/*      (c) 1983, 4 by Ernest E. Bergmann               */
/*		Physics, Building #16			*/
/*		Lehigh University			*/
/*		Bethlehem, Pa. 18015			*/
/*							*/
/*	Contains portions of ROFF4, Version 1.61	*/
/*      (c) 1985 by Konrad Kwok                         */
/*		20 3rd Street, Section M		*/
/*		Fariview Park,				*/
/*		Hong Kong				*/
/*							*/
/*	ro and its predecessor ROFF4 are based on 	*/
/*	the ROFF text processor described in Kernigan	*/
/*	and Plauger's now-classic text <Software Tools> */
/*							*/
/* Permission is hereby granted for all commercial and	*/
/* non-commercial reproduction and distribution of this */
/* material provided this notice is included.		*/
/*							*/
/********************************************************/

#include "ro.h"

/**************************************************/

int value( base, string)	/*unsigned conversion*/
	int base;			/*radix for conversion*/
	char *string;		 	/*no leading blanks please!*/
				/*trailing whitespace or '\0'*/
	{
	int val,d;
	char c;
	val=0;
	for(d=digit(*string);d>=0 && d<base ; d=digit(*string))
		{
		val = val*base + d;
		string++;
		}
	c = *string;
	if ( !c || c==' ' || c==TAB || c=='\n') return(val);
	else return(-1);		/*error return is -1*/
	}

/**************************************************/

int digit(d)
char d;
	{	 
	d=toupper(d);
	if(d<='9') return(d-'0');
	if(d<'A') return(-1); /*error return is negative val*/
	if(d<='Z') return(10-'A'+d);
	return(-1);	 /*error*/
	}

/**************************************************/
/* returns printed string length; checks legality of
word function; keeps track of vertical
excursions; records them in globals */

strln3( s, word, num )
	char *s;
	int word;               /* boolean, if true, check is made for none
 				   black characters in the string */
	int num;                /* for expansion of NUMSIGN; set 1 to ignore */
	{
	int i, i2, p1, p2, p3;
	int t, b, h;            /*vertical vars*/
	char c, *ss;
	ss = s;
	t = b = h = 0;
	p3 = p2 = p1 = -LSZ;
	for ( c = *ss, i2 = i = 0; c; c = *(++ss) )
		{
		if ( c == NUMSIGN )
			{
			i++;
			if(num>9) i++;
			if(num>99) i++;
			if(num>999) i++;
			}
		else if ( (c != ro_tcval[0] ) && ( c != ESCAPE ) )
			{
			if ( ( c <= ' ' ) && (word) )
				{
				if ( ro_verbose == TRUE )
					{
					fprintf( stderr, "ro: illegal character 0x%x \n",
						c );
					}
				goto error;
				}
			else i++;
			}
		else if ( c == ESCAPE )
			{
			c = *(++ss);		
			if ( c == ESCAPE ) 
				{
				goto error; /*both ro_cfval[0], ro_tcval[0] */
				}
			switch( c )
				{
				case ROMAN:
				case ITALIC:
				case BOLD:
				case HALFUP:
				case HALFDOWN:
					break;
				default: 
					if (ro_verbose )
						fprintf( stderr, "ro:  c <%c> is not printer code. \n", c );
					goto error;	 /*undecipherable*/
					break;
				}
			}
		else	/*c==ro_tcval[0]*/
			{
			if(class(*(s+1))!=BLACK)
				{
				goto error;      /*illegal translation*/
				}
			}
		}
	if ( h )
		{
		goto error;
		}
	if ( word )
		{
		ro_wtop=t;
		ro_wbot=b;
		}
	else
		{
		ro_ltop=t;
		ro_lbot=b;
		}
	if(i>=i2)
		{
		return( i );
		}

	/* else prints beyond last character: */

error:
	if ( ro_verbose == TRUE )
		{
		fprintf( stderr, "ro: line <%s> is illegally formed.\n", s );
		}

	return ( strlen( ss ) );
	}

/* A properly formed token string has its first printable
character indicating the lefthand edge and the last printable
character at the right hand edge.	Only legal control pairs
accepted.	It must consist of printable symbols. */

/**************************************************************
Set a stack variable like set() sets a global integer variable.  
**************************************************************/

setS ( param, val, arg_typ, defval, minval, maxval )
	int param[STKSIZ], val, defval, minval, maxval;
	int arg_typ;
	{
	register int i;

	if ( val == NO_VAL )
		{
		for ( i = 0; i < STKSIZ - 1; i++ )	/*pop*/
			{
			param[ i ] = param[ i + 1 ];
			}
		param[ STKSIZ - 1 ] = defval;
		}
	else
		{
		for ( i = STKSIZ - 1; i; i-- )	/*push*/
			{
		 	param[ i ] = param[ i - 1 ];
			}
		if ( arg_typ == '+' ) 
			{
			param[ 0 ] += val;
			}
		else if ( arg_typ == '-' ) 
			{
			param[ 0 ] -= val;
			}
		else param[ 0 ] = val;
		}
	param[ 0 ] = ro_min( ro_max( param[ 0 ], minval), maxval );

	if DEBUG fprintf( stderr, "DEBUG:  setS(): *param = %d \n", *param );

	}

/******************************************
initialize stack type variable, st, with v
*******************************************/

initsk( st, v )
	int st[STKSIZ], v;
	{
	register int i;
	for ( i = STKSIZ - 1; i >= 0; --i )
		{
		st[ i ] = v;
		}
	}

/**************************************************/

gettr() /*process .tr */
	{
	if ( ro_verbose )
		fprintf( stderr, ".tr is not currently implemented. \n" );
	}

/**************************************************/

outstr(p)	 /*print string whose bytecount is *p */
char *p;
	{
	int i;
	for(i=*(p++); i; i--) putchar(*(p++));
	}

