







                       PROFF User's Guide

                           Version 1.0















                         ***  *******
                         ***  *********
                              **      **
                              **      **
                              *********
                              *******
                              **
                              **
                              **
                         ******
                         ****
















                  Ozan S. Yigit & Steven Tress
                           March 1984







1.0                    Proff User's Guide                       1


11..00 IInnttrroodduuccttiioonn     

     This manual  describes  PROFF,  a  formatter  based  on  the
FORMAT utility presented in _S_o_f_t_w_a_r_e _T_o_o_l_s_.  

     PROFF was  produced to provide a powerful formatter that can
be  used  under  a  variety  of  microcomputers, thus providing a
consistent  formatting  tool  across  environments.  PROFF can be
used  to  format memos, reports, form letters  and documents such
as  this  manual.  It  can  also  be  configured  to mimic  other
formatting systems of similar nature.  

     This document  itself was produced with PROFF, using most of
its  advanced  features.   PROFF  took  care  of  such  things as
auto-paragraphing  and  the  production of  the Table of Contents
as the manual was being formatted.  

     PROFF was  developed  under  a Digital Equipment Corporation
Rainbow  100,  using  Mark  Williams  C  Compiler for portability
reasons.  PROFF  is  available  under  VAX/VMS  operating system.
PROFF  implementations  for   IBM  PC and APPLE ][ microcomputers
are also underway.  





















Rainbow,    VAX/VMS   are   trademarks   of   Digital   Equipment
Corporation.  
Mark  Williams  C  Compiler  is  a  trademark  of  Mark  Williams
Company.  
IBM  is a registered trademark of International Business Machines
Inc.  
APPLE is a trademark of Apple Computer Inc.  
UNIX is a trademark of Bell Laboratories.  






1.0                    Proff User's Guide                       2


22..00 GGeenneerraall DDeessccrriippttiioonn    

22..11 TThhee IInnppuutt    

     The text  that  is to be formatted by PROFF is typed into an
input  file using any text editor. This file contains the text to
be formatted as well as PROFF commands.  

     Each line  in  the  input file is either a command line or a
text  line.  A  command  line is a line that begins with a period
(".").  All other lines are text lines. The command lines are not
printed  -  they  tell  PROFF  how you want it to format the text
that  follows.  Appendix  A  summarizes all of the PROFF commands
for a quick reference.  

22..11..11 TTeexxtt     

     Text can  be  entered  into  the  input  file in any format.
PROFF  removes  all  extra  blanks  and  tabs  between words when
operating  in  fill  mode.  This  means  you do not have to worry
about  how many words you put on a line, and you can break  lines
wherever  it is convenient to your typing. Note however, that you
cannot break a word between two lines.  

     Blanks and  tabs at the beginning of a line are not removed.
This  is  useful  for  producing  special  tables  and performing
special  types  of  indentation.   Thus, normal text lines should
not have any leading tabs or blanks.  

22..11..22 CCoommmmaannddss     

     A command  is  a line that starts with a period. Immediately
following  the  period  is a command name. Some commands accept a
numeric  quantity  or a character string parameter, which must be
separated  from  the  command  name  by  a  space or a comma. For
example, an indent command might appear as follows: 

     |
     |It is to do nothing that the elect exists.
     |.in 5
     |- Oscar Wilde
     |

     Assuming that  the  left margin was at column 1, PROFF would
produce the following: 

     |
     |It is to do nothing that the elect exists.
     |     - Oscar Wilde
     |

     (In the  examples above, as in those following, the vertical





1.0                    Proff User's Guide                       3


line  indicates  the  left  edge of input or the left edge of the
printed page).  

     The number  following  the command may be preceeded by a "+"
or  "-"  sign.   This plus or minus sign indicates an addition or
subtraction  of  the  number to or from the current value for the
command. for example, the text: 

     |
     |Nothing to do but work,
     |.in +3
     |Nothing to eat but food,
     |.in -3
     |Nothing to wear but clothes
     |.in +3
     |To keep one from going nude.
     |.in +7
     |-Benjamin King
     |

will produce as output:

     |
     |Nothing to do but work,
     |   Nothing to eat but food,
     |Nothing to wear but clothes
     |   To keep one from going nude.
     |          -Benjamin King
     |

     If a  number  is not supplied with a command that requires a
number,  PROFF  will  use  a default value. The defaults for each
command are summarized in Appendix A.  

22..22 TThhee OOuuttppuutt    

     The main  functions  performed  by  PROFF  are   _f_i_l_l_i_n_g and
_j_u_s_t_i_f_y_i_n_g_.   A  line  is filled by packing as many words onto it
as  will  fit.  The  line  is  justified  by spacing words evenly
between  the  left  and  right  margins.  When  PROFF  starts, it
assumes  that  the text is to be filled and justified. Of course,
when  fill and justify are not needed (as in the case of a letter
or  a  table), there are commands to turn these features off, and
back on again, as necessary.  

     When PROFF  is  in  fill  mode, it normally strips out extra
spaces and tabs  between words.  

     Many PROFF  commands  cause  a _b_r_e_a_k to occur in the output.
This  means  that the line currently being filled is  immediately
output. Any following text goes into a new output line.  






1.0                    Proff User's Guide                       4


22..33 EExxeeccuuttiinngg PPRROOFFFF    

     Once a  text  file is ready for formatting, PROFF is started
by  typing  the  program name, various options, name of the input
file and the name of the output file. For example the command 

     A> proff  -po5 proffman.prf proff.man 

would  produce  this  document  as  proff.man, from an input file
proffman.prf,   shifted  right  by 5 spaces.  (The symbol "A>" is
CP/M system prompt).  

22..44 BBiibblliiooggrraapphhiicc NNootteess    

     PROFF wa   produced   by   re-writing   the  Software  Tools
Formatter   FORMAT.   Some  of  the  ideas  are  from  Freshwater
Institute  RUNOFF,  NROFF,   University  of  Waterloo  SCRIPT and
other  formatters  of similar nature. The underlying ideas of the
mentioned  above  formatters  may  be  found in _S_o_f_t_w_a_r_e _T_o_o_l_s by
B.W.  Kernighan and P.J. Plauger. 1976. (Addison-Wesley, Reading,
Mass.).  

22..55 RReeffeerreenncceess aanndd RReeaaddiinnggss   

Brian W. Kernighan and P. J. Plauger,
_S_o_f_t_w_a_r_e _T_o_o_l_s
Addison-Wesley (1976)

R. Furuta, J. Scofield and A. Shaw,
_D_o_c_u_m_e_n_t _F_o_r_m_a_t_t_i_n_g _S_y_s_t_e_m_s_:
_S_u_r_v_e_y_, _C_o_n_c_e_p_t_s_, _a_n_d _i_s_s_u_e_s
ACM Computing Surveys, Sept. 1982, Pp. 417

Mark Stuart Brader,
_A_n _I_n_c_r_e_m_e_n_t_a_l _T_e_x_t _F_o_r_m_a_t_t_e_r
Department of Computer Science
University of Waterloo, CS-81-12




















1.0                    Proff User's Guide                       5


33..00 CCoommmmaanndd DDeessccrriippttiioonnss    

     This section  describes PROFF commands. Commands specify how
the  program  is  to  process  the  text lines in the input file.
Lines  in the input file that begin with a period (or the control
character  selected  by  the  user)   immediately  followed  by a
command  name  are  commands.  Any line that begins with a period
and  followed  by  a  #  or ! is a comment line and is ignored by
PROFF  - this allows you to put information in the file that will
be neither processed nor output by PROFF.  

     As described  earlier,  some of the commands can be followed
by  "parameters".   Parameters  are  used in executing a command;
for  example, in the command ".sp 3", the parameter "3" tells the
formatter  to  insert  3  blank  lines  into  the  document.  The
following conventions are used in describing the parameters: 

   o Parameters  surrounded  by  square brackets are optional. If
     not supplied, PROFF assumes a default value.  
     (e.g. .sp [n]) 

   o Parameters  surrounded  by  angle  brackets  are  mandatory.
     PROFF  will  display  a fatal error message if the parameter
     is absent. (e.g. .set <variable name>) 

   o Parameters  surrounded  by squiggly brackets are to be typed
     exactly as indicated. (e.g. .pn {roman}) 

   o A  bar  character  seperating the parameters within brackets
     indicate  an  alternative. (e.g. .st [+|-][n] means both .st
     [+n] and .st [-n]) 

     In describing  the  commands, the command is typed exacty as
accepted  by  PROFF with the associated control character default
(".").  If  more  than  one  form  of  the command is accepted by
PROFF,  the  command names are separated with a bar indicating an
alternative.  




















1.0                    Proff User's Guide                       6


33..11 FFiilllliinngg aanndd JJuussttiiffyyiinngg   

.fi | .f | .fill 

     The  fill  command  causes  a line to be filled with as many
     words  as  the  right  margin  allows. For this purpose, all
     extra  blanks  and tabs are removed between words. Each word
     is  separated  with  a  single  blank.  PROFF  automatically
     assumes fill mode during the startup.  

.nf | .nofill 

     No  fill  discontinues the filling of the text. PROFF simply
     copies  the  text to the output. This command may be used to
     pass   tables   and   other   text   unaltered  through  the
     formatter.  

.ju | .j | .justify 

     Justify  causes  the  words  on  a  line to be evenly spaced
     between  the left and the right margins. Note that lines can
     be  justified  only  if  lines  are also being filled. PROFF
     automatically assumes justify mode during the startup.  

.nj | .nojustify 

     No justify discontinues the text justification.  






























1.0                    Proff User's Guide                       7


33..22 TTeexxtt FFoorrmmaattttiinngg    

.br | .break 

     Break  causes  a  break: the current line is printed without
     justification,  and the next word is placed at the beginning
     of  a  new  line.  Note  that  many  PROFF commands cause an
     implicit break.  

.in | .lm | .leftmargin [+|-][n] 

     Indent  causes  a  break and indents the following lines [n]
     spaces  to the right of the left margin. [n] can be negative
     to  allow  beginning  a line to the left of the left margin,
     however,  a  line cannot begin to the left of column 0. If a
     plus  or  minus  sign  is  used with n, then [n] is added or
     subtracted to or from the current value.  

.ti | .i | .left [+|-][n] 

     Temporary  indent  is identical to the indent command except
     that  it   applies  only  to  the next line of printed text.
     Thus,  the  command ".ti +5" would cause the next line to be
     printed 5 spaces to the right of those that follow.  

.st | .spaceto [-][n] 

     Spaceto  allows  spacing  to  line  [n]  from the top of the
     current  page.  If a negative [n] is specified, than spacing
     is  performed  to  line  [n]  from  the  bottom  of the page
     (excluding  the footer lines). Thus, footnotes can be set at
     a  fixed  distance  from the bottom of the page by a command
     such as ".st -5".  

.sp | .s | .skip [n] 

     Space  causes a break and skips [n] lines, except at the top
     of   a  page.  The space command is dependent on the setting
     of line spacing.  

.ce | .center [n | on | off] 

     Center  causes  the  next  [n]  lines of text to be centered
     between  the  left  and  right  margins.  Centering  may  be
     started  with  "on" and terminated with "off", in which case
     all input lines between these commands will be centered.  

.ul | .underline [n | on | off] 

     Underline  command  causes  the  text  on the next [n] input
     lines  to  be  underlined  when  printed. If [n] is omitted,
     only  the  next  line  is  underlined. This command does not





1.0                    Proff User's Guide                       8


     cause  a  break,  so  words in filled text may be underlined
     by: 


          |
          |The "Pay-off" Theory: Only
          |.ul
          |losers
          |believe in luck, horses, horoscopes
          |and
          |.ul
          |lotteries.
          |

     to get

          | 
          |The "Pay-off" Theory: Only _l_o_s_e_r_s believe in 
          |luck, horses, horoscopes and _l_o_t_t_e_r_i_e_s_.  
          | 

          Underlining may  be  started  with  "on" and terminated
     with "off", similar to the centering command.  

.ul | .underline [all | words] 

     This  version  of  the  underline command is used to set the
     mode of underlining: 

          all   - underline across all characters,
                  including spaces.
          words - underline words only


.bd | .bold [n | on | off] 

     The  bold  command  causes  the  text  on the next [n] input
     lines  to be highlighted by overstriking. If [n] is omitted,
     only  the  next line is highlighted.  Bolding may be started
     with  "on"  and  terminated with "off" as in the case of the
     center and underline commands.  

.db | .dbo | .disablebolding 

     Turns  the  bolding  off,  all bolding commands are ignored.
     This feature is useful for rough drafts.  

.eb | .ebo | .enablebolding 

     Turns  the  bolding  feature  back  on. Bolding is turned on
     during the PROFF startup.  






1.0                    Proff User's Guide                       9


33..33 PPaaggee FFoorrmmaattttiinngg    

.ls | .spc | .spacing [n] 

     Line  spacing is the command to set line spacing. Set n to 1
     for single spacing, 2 for double spacing etc.  

.bp | .pg | .page [n] 

     The  begin  page  command  causes  a break, ends the current
     page,  outputs footers if required and begins a new page. If
     [n]  is  present, the page number is set to [n]. The default
     action is to number the pages incrementally.  

.pn | .pagenumber {roman} | {arabic} 

     Page  number  command defines the format of the page number.
     Uppercase  roman  numerals  may  be  obtained  with  "roman"
     keyword.  To  convert  the  page  numbers  back  to  normal,
     "arabic"  is  specified.  PROFF  uses  arabic  numerals as a
     default.  

.np | .nopaging 

     No  paging  disables  the  pagination.  When  PROFF is in no
     paging  mode,  "begin  page"  (.bp)  and "page length" (.pl)
     commands  are  ignored. This mode of operation is especially
     useful  for  using  the  proff  output with the multi-column
     formatter (MC).  

.pa | .paging 

     Paging  enables  normal page generation. This command starts
     a   new  page  and  restores  the  page  length to the value
     previous to the ".np" command.  

.ne | .need | .tp | .testpage [n] 

     Test  page  checks  to see whether at least [n] lines remain
     in  the  current  page.  If  less  than this number of lines
     remain,  printing  will  resume at the top of a new page. If
     [n] is missing, it is assumed to be zero.  

.he | .header <text> 

     Header  sets  the  text  to  be printed on top of each page.
     <text>  is   divided  into  sections  which  are  to be left
     justified,  centered  and  right justified. To divide <text>
     into  these  three  parts, the first character is assumed to
     be   a   separator.   (e.g.   /left/center/right/)  But  any
     non-alphanumeric  character may also be used. The characters
     "#"  and  "%"  are replaced with the current page number and





1.0                    Proff User's Guide                      10


     day/time in the header.  

.fo | .footer <text> 

     Footer  is  identical to header except that it sets the text
     to be printed at the bottom of each page.  

.oh <text> 

     The odd header command sets the header for odd pages only.  

.eh <text> 

     The  even  header  command  sets  the  header for even pages
     only.  

.of <text> 

     The odd footer command sets the footer for odd pages only.  

.ef <text> 

     The  even  footer  command  sets  the  footer for even pages
     only.  

































1.0                    Proff User's Guide                      11


33..44 PPaaggee LLaayyoouutt    

     These commands  are  used  to  specify where on the page you
want  the  formatted  text  to be placed. The general layout of a
page is as follows: 

        page offset (.po)                               |
        |                                               |
        V                                               |
        +----+-------------------------------------+----+ -+
        |    |  top margin (m1) includes header    |    |  |
        +----+-------------------------------------+----+  |
        |    |          top margin 2 (m2)          |    |  |
        +----+-------------------------------------+----+  |
        |    |                  .                  |    |  P
        |    |<-- indent (.in)  .                  |    |  A
        |    |                  .                  |    |  G
        |    |                  T                  |    |  E
        |    |                  E                  |    |
        |    |                  X                  |    |  L
        |    |                  T                  |    |  E
        |    |                  .                  |    |  N
        |    |               right margin (.rm) -->|    |  G
        |    |                  .                  |    |  T
        |    |                  .                  |    |  H
        |    |                  .                  |    |  |
        +----+-------------------------------------+----+  |
        |    |          bottom margin 3 (m3)       |    |  |
        +----+-------------------------------------+----+  |
        |    |  bottom margin (m4) includes footer |    |  |
        +----+-------------------------------------+----+ -+
        |                                               |
        |                                               |

.po | .offset [+|-][n] 

     The  page  offset command moves the entire page to the right
     or  left  depending  on the specified value. All indentation
     is  according  to  the  page  offset.  PROFF  assumes a page
     offset  of  0 during the startup. If [n] is specified with a
     plus  or  minus,  it  will  be  added or subtracted from the
     current value.  

.rm | .rightmargin [+|-][n] 

     Right  Margin  sets  the  position  of  the  last  printable
     character  from  the  left  edge of the page to [n]. Default
     value  for  right  margin is 65.  A plus or minus value will
     be  added  or  subtracted from the current value.  If [n] is
     not specified, right margin is set to the default value.  

.pl | .ps | .pagesize [n] 





1.0                    Proff User's Guide                      12


     Page  length  is used to set the number of lines that are to
     be  printed on a page including the header and footer lines.
     After  [n]  lines are printed, the paper will advance to the
     top  of  next  page. The default page length is 66 lines (11
     inches  for  6  lines/inch).  This  command  is  disabled if
     nopaging is set.  

.m1 [n] 

     Margin  1  sets  the  number of lines (including the header)
     which  will  be  left  at  the  top  of the page to [n]. The
     default  setting  is  3.  If  [n]  is omitted, is set to the
     default.  

.m2 [n] 

     Margin  2  sets the number of blank lines between the header
     and the first line of text. The default setting is 2.  

.m3 [n] 

     Margin  3  sets the number of blank lines between the footer
     and the last line of text. The default setting is 2.  

.m4 [n] 

     Margin  4  sets  the  number of lines (including the footer)
     which  will  be  left  at the bottom of the page to [n]. The
     default setting is 3.  




























1.0                    Proff User's Guide                      13


33..55 TTaabbllee ooff CCoonntteennttss   

     This section  describes  the  the  commands that are used to
generate  a table of contents. Basically, a contents line command
is  used  in every place in the document where an entry is needed
in  the  table  of  contents.  PROFF stores the text and the page
number  when  it  encounters this command.  After the the body of
the  document  is  processed,  a print contents command dumps the
contents  table.  The  contents  should  be dumped in a new page,
with  nofill.  Page  numbering should be disabled if the table of
contents is to be used in front of the document.  


.cl | .contline [<n> <text>] 

     Contents  line specifies a line of <text> to be entered into
     the  table of contents. <n> specifies the level at which the
     item  is  to  be  printed  in  the  table. When the table is
     printed,  each  level  of entry will be indented by specific
     number  of  spaces.  <text> appears in the output exactly as
     it  appears  in  the  contents  line  command,  except  that
     leading  blanks are removed.  If no options specified in the
     contents   line,  a  blank  is  inserted  during  the  table
     output.  

.pc | .printcont [n] 

     Print  Contents  causes  the  currently accumulated table of
     contents  to  be printed. If [n] is specified, it is used as
     the  indent  value for each level.  If [n] is not specified,
     it is defaulted to 3.  

          A contents   line   at   level   0   is   as   wide  as
     rightmargin-indent.  The  outlook  of  the table of contents
     may  be  changed  by  altering  the  right margin and indent
     values.  A  typical  table  of  contents  may be produced as
     follows: 

          |.page
          |.he ////
          |.fo ////
          |.nofill
          |.sp
          |.center
          |Table of Contents
          |.sp
          |.printcont

     The  following example illustrates the generation of a table
     of  contents. Note that only one table of contents is active
     for a PROFF session.  






1.0                    Proff User's Guide                      14



          .cl
          .cl 0 A. Introduction
          Introduction
                  text
                  .
          .cl
          .cl 0 B. Methods
          Methods
                  text
                  .
          .cl 1 a) Sampling Procedures
          Sampling
                  text
                  .
          .cl 1 b) Laboratory Procedures
          Laboratory
                  text
                  .
          .cl
          .cl 0 C. Results
          Results
                  text
                  .
                  .
          .pg
          .nf
          .he ////
          .fo ////
          .ce
          Table of Contents
          .sp
          .pc

     These commands will produce the following table:

                          Table of Contents

          A. Introduction...............................   1

          B. Methods....................................   3
             a) Sampling Procedures.....................   3
             b) Laboratory Procedures...................   4

          C. Results....................................   5

     Macros   may  be  defined  as  described  in  the  following
     sections to help the generation of the table of contents.  









1.0                    Proff User's Guide                      15


33..66 MMiisscceellllaanneeoouuss     

     This section    describes    miscellaneous   commands   that
radically  increase  the  formatting  powers  of  PROFF. With the
assistance  of  variables,  PROFF  can  generate form letters and
documents  with  dynamic  parts.  The ability to save and restore
formatter  context  eliminates  the  need  to  remember the exact
settings of the formatter across the document.  

.vs | .set <variable> [definition] 

     Set  variable   defines  a  variable to be later used in the
     document.   If  the  definition part is left out, PROFF uses
     the  variable name as a prompt and allows the user to define
     the  variable  interactively.  Variable  names  cannot start
     with   a   numeric   character,   and   may   only   contain
     alphanumeric   characters.  The definition of a variable may
     not  contain  any  blanks,  unless  they  are  surrounded by
     double-quotes.  To  get  a  double  quote  within a a quoted
     definition, two double-quotes are used.  

          Once the  variable  is defined, it can be used anywhere
     in  the  document,  including  the  command  line  itself. A
     variable  substitution  is  invoked by a dollar sign ($). (A
     literal  $ is inserted into text using _$).  A variable name
     must  be  delimited  by  a non-alphanumeric character within
     the   text.  If  the  contents  of  the  variable  is  to be
     appended  to  other   alphanumeric  characters,  it  must be
     surrounded  by  wiggly  braces  ("{" and "}"). The following
     is an example of variable usage: 

     |.nf
     |.vs v1 Murphy
     |${v1}'s first law:
     |       Nothing is as easy as it looks.
     |${v1}'s second law:
     |       Everything takes longer than you think.
     |Charley's observation:
     |       Computers were invented by $v1.
     |

     Produces the following:

     |
     |Murphy's first law:
     |       Nothing is as easy as it looks.
     |Murphy's second law:
     |       Everything takes longer than you think.
     |Charley's observation:
     |       Computers were invented by Murphy.
     |






1.0                    Proff User's Guide                      16


.vg | .get <variable> <prompt> 

     Get   variable   is  the  interactive  version  of  variable
     definition.  In  this   variant,  a prompt string is used to
     obtain  the  value  of  the  variable, which is typed at the
     user's  terminal.  If  the  prompt  string  is  to   contain
     blanks,  tabs etc., it must be enclosed in double quotes. No
     quotes are necessary for input text.  

.nr <a-z> [+|-][n] 

     Number  register  is  used  to define registers that contain
     numeric  values.   There are 26 number registers, named a-z.
     The  command ".nr x n" sets the number register "x" to value
     n;  ".nr  x  +n" increments the number register by n; ".nr x
     -n"  decrements  the  number register by n. The value of the
     number  register  x  is placed in the text by the appearance
     of  @nx.  A  literal  @  may  be  inserted using _@.  Number
     registers  may  be used on command lines and anywhere in the
     text.  

.cc | .cchar [char] 

     Control  Character   sets  the  character that distinguishes
     PROFF   commands  from  text  to be formatted. As a default,
     control  character  is set to  (".") period.  This character
     may  be  changed to something other than a period, either to
     mimic  other  formatters  or  to  disallow interpretation of
     lines  beginning  with  a period. (This document makes heavy
     use of the .cc command).  

.ec | .echar [char] 

     Escape  Character   sets  the  character  that disallows the
     interpretation  of spacial characters such as @ and $. PROFF
     uses an underline ("_") character as a default.  

.so | .source | .include | .require [filename] 

     The  source  (include)  command  allows external files to be
     inserted  into  the  input file during the formatting. Using
     this  feature, tables, graphs and other  documents generated
     outside  PROFF  may  be  included  into  the  document being
     formatted.  This  feature is also very useful in including a
     common  set  of  macros during formatting. Include files may
     be  nested inside other include files. Currently, PROFF only
     allows  a  nested  include files level of 8. Filename may be
     enclosed in quotes.  

.sv | .save 

     The  save command allows the saving of the current formatter





1.0                    Proff User's Guide                      17


     context  on  a   pushdown  stack.  The  saved context of the
     formatter  segment (FSECT) includes the following values and
     flags: 

     values                  flags           on   |  off
     ------                  -----           
     indent          (.in)   fill            (.fi | .nf)
     right margin    (.rm)   justify         (.ju | .nj)
     offset          (.po)   paging          (.pa | .np)
     line spacing    (.ls)   number type     (.pn)
     page length     (.pl)   bolding         (.eb | .db)
     margin values   (.m1)   autoparagraph   (.ap | .na)
                     (.m2)
                     (.m3)
                     (.m4)
     control char    (.cc)
     escape char     (.ec)


.rs | .restore 

     The  restore command pops the context stack and restores the
     values and flags as defined above.  

.lx | .lex <command> [equate] 

     The  lexical modification command is essentially a permanent
     replacement  of  a  given  command. This command is used for
     changing  the  command  names without resorting to the macro
     facility.  Lex permanently removes the old command name from
     command  tables and replaces it with the new definition.  If
     the  equate is not specified, the command  becomes undefined
     and  is  no  longer  recognised by PROFF. The command equate
     should not contain  non-alphanumeric characters.  

.ap | .autoparagraph 

     The   autoparagraph   command   turns   on   the   automatic
     paragraphing  feature.  If  auto-paragraphing  is  on, every
     line  that starts with a  _b_l_a_n_k or a  _t_a_b character starts a
     new  paragraph.  A  new  line  is  generated  (.sp)  and the
     beginning  of  the  paragraph  is  indented  by five spaces.
     Autoparagraphing   is   the   equivalent  of  the  following
     commands: 
          |
          |textextextextext
          |.sp
          |.ti +5
          |textextextextext
          |

.na | nap | .noautoparagraph 





1.0                    Proff User's Guide                      18


     No Autoparagraph command disables auto-paragraphing.  

.wr | .write <string> 

     Write  is  a  special  output  command,  only  to be used to
     configure  printers  and  other  output  devices with escape
     sequences.  This command outputs the associated string as it
     is  encountered,  without  going  through  the normal output
     routines  of the formatter. Currently, the output string may
     contain  control  characters specified as "^<char>", decimal
     numbers  within  the  range  of 1-255, and other characters.
     Blanks  within  the  string  are skipped. Any portion of the
     string  enclosed  with  double  quotes  is  output as is. To
     output  a  double  quote,  two  double  quotes  must be used
     within  the quoted string.  Following is a typical string to
     set a Digital La-100 printer to letter quality print mode: 

          |
          |.wr ^["[2z"
          |

     In  the  control string, "^[" is the ASCII equivalent of the
     Escape  (esc) character.  Following mapping table is used to
     convert  characters  starting  with  a caret to their binary
     equivalents: ("|" indicates an alternative) 

          Control chr     Dec.    Oct.    Hex.
          -----------     ----    ----    ----
          ^a | ^A (soh)   1       01      01
          ^b | ^B (stx)   2       02      02
          ^c | ^C (etx)   3       03      03
          ^d | ^D (eot)   4       04      04
          ^e | ^E (enq)   5       05      05
          ^f | ^F (ack)   6       06      06
          ^g | ^G (bel)   7       07      07
          ^h | ^H (bs)    8       10      08
          ^i | ^I (ht)    9       11      09
          ^j | ^J (nl)    10      12      0A
          ^k | ^K (vt)    11      13      0B
          ^l | ^L (np)    12      14      0C
          ^m | ^M (cr)    13      15      0D
          ^n | ^N (so)    14      16      0E
          ^o | ^O (si)    15      17      0F
          ^p | ^P (dle)   16      20      10
          ^q | ^Q (dc1)   17      21      11
          ^r | ^R (dc2)   18      22      12
          ^s | ^S (dc3)   19      23      13
          ^t | ^T (dc4)   20      24      14
          ^u | ^U (nak)   21      25      15
          ^v | ^V (syn)   22      26      16
          ^w | ^W (etb)   23      27      17
          ^x | ^X (can)   24      30      18





1.0                    Proff User's Guide                      19


          ^y | ^Y (em)    25      31      19
          ^z | ^Z (sub)   26      32      1A
          ^[      (esc)   27      33      1B
          ^\      (fs)    28      34      1C
          ^]      (gs)    29      35      1D
          ^^      (rs)    30      36      1E
          ^_      (us)    31      37      1F


















































1.0                    Proff User's Guide                      20


33..77 DDeeffiinniinngg NNeeww CCoommmmaannddss ((MMaaccrrooss))  

     In document  formatting,  it is common to repeat a series of
commands  at  several places in the document. PROFF allows you to
define  a  new command that will replace these repeated commands.
This  not  only  saves  typing  but ensures that _e_x_a_c_t_l_y the same
sequence  of  commands are applied throughout the document. A new
command  that you define is formally called a _m_a_c_r_o_.  To define a
macro,  you  must  use  the  define macro (.de | .define) and end
macro (.en) commands.  

.de | .define <macro name> 

     Define  is  used  to define a <macro name> to which a series
     of   commands  to  be  assigned.  This  definition  line  is
     followed  by  any number of PROFF commands and/or text which
     define  the action that the macro will subsequently produce.
     Macros may refer to other macros.  

.en 

     End  macro  is  the last line in the command definition. You
     must  put  in  this  command  to  finish a currently defined
     macro. ".en" command should not be re-defined as a macro.  

The  example below defines macros ".note" and ".endnote", similar
to the RUNOFF commands of the same name.  

     |
     |.define note
     |.sp
     |.ce
     |NOTE
     |.sp
     |.fi
     |.in +5
     |.rm -5
     |.en
     |
     |.define endnote
     |.sp
     |.nf
     |.in -5
     |.rm +5
     |.en
     |

     A macro  is  used  like  any  other  PROFF  command, control
character  followed  immediately   by  the name of the macro. For
example, the above macros may be used as follows: 







1.0                    Proff User's Guide                      21



     |
     |.note
     |textextextextextextextextextext
     |              .
     |              .
     |              .
     |.endnote
     |

The  following  note  is  generated  by the same macros described
previously.  

                              NOTE

     Flap's  Law:  Any  inanimate  object, regardless of its
     position  or  configuration, may be expected to perform
     at  any time in a totally unexpected manner for reasons
     that  are  either  entirely  obscure or else completely
     mysterious.  

Special  symbols  may  be  used  within a macro definition. These
symbols  represent the parameters passed to a macro, delimited by
blanks  or  commas.   These symbols are $0 for macro name, $1 for
the  first  parameter,  $2 for the second parameter and so on, up
to  $9  for  the ninth parameter. Currently, macro parameters may
only  contain  alphanumerics,  no string parameters are possible.
The previous macro "note" may now be defined as follows: 

     |
     |.define note
     |.sp
     |.ce
     |$2 $3 $4 $5 $6 $7 $8 $9
     |.nr m $1
     |.sp
     |.fi
     |.in +$1
     |.rm -$1
     |.en
     |
     |.define endnote
     |.sp
     |.nf
     |.in -@nm
     |.rm +@nm
     |.en
     |

     In this  version  of  the  "note"  and "endnote" macros, the
first  parameter  ($1)  is used to pass the value for indentation
and   right  margin  adjustment.   All  the  rest  of  the  macro





1.0                    Proff User's Guide                      22


parameters  ($2  -  $9)  are  used  as the title of the note. The
indent  value  passed as the first parameter is also saved in the
number  register  "m"  to  communicate it to the "endnote" macro,
such  that  when  the  endnote  macro  is called, both indent and
right  margin  values are adjusted back to normal. It is possible
and  may be more useful to use ".save" and ".restore" commands to
accomplish  the  same  task,  especially  if the macro alters the
current   formatting   context   drastically.   The  ".note"  and
".endnote" macros may be called as follows: 

     |
     |.note 5 Asimov's Law of Robotics
     |textextextextextextextextextext
     |              .
     |              .
     |              .
     |.endnote
     |

     In this  usage,  the  indent  value  will be adjusted by +5,
right  margin will be adjusted by -5, and the title "Asimov's Law
of Robotics" will appear centered above the note.  



































1.0                    Proff User's Guide                      23


44..00 EExxeeccuuttiinngg PPRROOFFFF    

     The PROFF  program  may be invoked with a series of optional
parameters  and  filenames  on  the  command  line.  The  command
synopsis is: 

PROFF [+n] [-n] [-v] [-s] [-pon] [-ifile] input [output] 

The    square    brackets   indicate   an   optional   parameter.
Interpretation of the parameters is as follows: 

     ++nn 
          Start  the  printing  of the document at the first page
          with number n.  

     --nn 
          Stop  printing  at  the first page numbered higher than
          n.  

     --vv 
          Verbose  mode.  PROFF  indicates the source files being
          included  into  document, and produces a summary of the
          number  of  textlines  read in, the number of lines and
          actual  pages  generated.  A  memory  usage  summary of
          internal  storage for macros, stacks and tables is also
          displayed.  

     --ss 
          Stop  before  each  page,  including  the  first one to
          allow  paper  adjustment. A prompt is given just before
          the  first page. For each page thereafter, the terminal
          bell  is  rung  to indicate that another sheet of paper
          is needed.  

     --ppoonn 
          Sets  the page offset to n. This is equivalent to ".po"
          command  within  the  document.  It is recommended that
          -pon  option  be  used  instead of embedding the offset
          value within the document.  

     --iiffiillee 
          Includes  the  given  file  to  the formatted document.
          This  is equivalent to a ".include file" command within
          the  document.  This  option  may be repeated more than
          once, -ifile1 -ifile2 etc.  

     iinnppuutt 
          Specifies  the  input  file to be formatted. PROFF does
          not   impose   any   file  extension.  The  recommended
          extension is ".PRF".  







1.0                    Proff User's Guide                      24



     oouuttppuutt 
          Specifies  the  output file for the formatted document.
          If  this  is  omitted, output is directed to the user's
          terminal.  

Following are some examples of PROFF command lines: 

     A>PROFF -v proffman.prf 

Format  this  document (proffman.prf) in verbose mode, and output
the formatted document to the terminal.  

     A>PROFF +5 -imacros.pma proffman.prf 

Format  this document, include the external file MACROS.PMA, skip
the  first  four  pages  and output the formatted document to the
terminal.  

     A>PROFF -po10 proffman.prf proff.man 

Format  this  document, shift the entire document by 10 spaces to
right and output to a file called proff.man.  


































1.0                    Proff User's Guide                      25


55..00 TTiippss oonn uussiinngg PPRROOFFFF  

55..11 CCaarree aanndd FFeeeeddiinngg ooff MMeemmoorryy 

     PROFF uses  a  dynamic  memory allocation scheme for some of
its  operations.   These  are  macro definitions, contents lines,
variables  and  save  context   operation.   Running  PROFF under
microcomputers  with  limited  memory  resources  (64k  or  less)
require some care in using these commands: 

a) Do   not  declare  macros  that  are  not  needed  within  the
   document.  

b) Do  not use comments within macros. Due to delayed evaluation,
   comments   will  also  be  stored  as  a  part  of  the  macro
   definition.  

c) Where  possible,  avoid  using too much text within macros. It
   is  just  as  easy  to  pass  the information during the macro
   call.  

d) Use only the shortest form of commands within macros.  

e) Be brief in contents line text.  

f) Use  short  variable  names as long as it is not so cryptic as
   to be confusing.  

g) Avoid unnecessary blanks within the variable definitions.  

h) Avoid  too many context saves without a corresponding restore.
   The restore operation reclaims the memory used for a save.  


     Even if  the formatter is used with a system of large memory
resources,  some  of the precautions above are applicable. (Utz's
4th   law   of  Computer  Programming:  Any  given  program  will
eventually  expand  to  fill all the available memory.) Using the
-v  option  under  memory-restricted  systems  may  be  useful in
determining the memory usage.  


55..22 FFoorrmmaattttiinngg wwiitthhoouutt ffuussss   

     PROFF, using  its  default  settings, may provide reasonably
formatted  output in many situations.  As an example, examine the
document  PROFF.TUT.  This  document  does not use ANY formatting
commands. All formatting is done with the default settings.  


55..33 VVaarriiaabblleess wwiitthhiinn mmaaccrrooss   






1.0                    Proff User's Guide                      26


     Variable expansions  may  be  performed  within  the macros.
Typically,  one of the parameters of the macro is assumed to be a
variable, which is expanded only after the macro is used. Thus: 

     |
     |.define xx
     |.ce
     |$$1
     |.cl $$1
     |.en
     |

The  macro xx assumes the first parameter to be a variable, which
is  centered  on  the  page,  and  also  entered  in the table of
contents.   Note the usage of "$$1". The lines within a macro are
scanned  from  right  to left for parameter expansion. Thus, "$1"
is  expanded  first,  resulting  in "$<first parameter>". This is
later expanded as a variable.  







































1.0                    Proff User's Guide                      27


66..00 EExxaammppllee mmaaccrrooss    

     .!
     .! macros to create a point-form lists.
     .! note the use of number registers within
     .! the macros.
     .!------------
     .define list
     .nr a $1        
     .in $1
     .en
     .!------------
     .define item
     .sp
     .ti -@na
     $1
     .en
     .!------------
     .define nolist
     .in -@na
     .sp
     .en
     .!------------

The  "list" macro is used to generate point-form lists. The first
parameter  is  an  indent value, size of point-str + 1. A typical
usage may be as  follows: 

     |
     |Project work involves:
     |.sp
     |.list 3                { size-of-point-str + 1 }
     |.item a)               { "a)" is the point-str }
     |choosing a topic
     |.item b)
     |defining the topic
     |.item c)
     |research
     |.item d)
     |organizing the notes
     |{etc.}
     |.nolist                { readjusts the indent  }
     |

The above usage will produce the following:












1.0                    Proff User's Guide                      28



     |
     |Project work involves:
     |
     |a) choosing a topic
     |
     |b) defining the topic
     |
     |c) research
     |
     |d) organizing the notes
     |

The  point-form  recommendations  under  section  5.1  (Care  and
Feeding  of   Memory)  were generated with the same set of macros
described above.  









































1.0                    Proff User's Guide                      29


77..00 AAcckknnoowwlleeddggeemmeennttss     

     This document  was  edited  by  Terry  Lim and Steven Tress.
The  format  of  the  document is largely based on The Freshwater
Institute  RUNOFF  User's  Guide.  The  Quotes  for  the  various
formatting  examples  are from THE QUOTABLE NOTHING BOOK and from
1001  LOGICAL  LAWS, ACCURATE AXIOMS, PROFOUND PRINCIPLES, TRUSTY
TRUISMS,  HOMEY  HOMILIES, COLORFUL COROLLARIES, QUOTABLE QUOTES,
AND  RAMBUNCTIOUS  RUMINATIONS  FOR  ALL WALKS OF LIFE, by Peers,
Bennet and Booth, Fawcett Columbine Books, New York.  















































1.0                        Appendix A                          30


AAppppeennddiixx AA     
                       Summary of Commands

----------------------------------------------------------
.fi | .f | .fill
                default:        initial: yes    break: yes
                begin filling output lines
----------------------------------------------------------
.nf | .nofill
                default:        initial: no     break: yes
                stop filling
----------------------------------------------------------
.ju | .j | .justify
                default:        initial: yes    break: yes
                begin justifying filled lines
----------------------------------------------------------
.nj | .nojustify
                default:        initial: no     break: yes
                stop justifying
----------------------------------------------------------
.br | .break
                default:        initial:        break: yes
                cause a break and output current line
----------------------------------------------------------
.in | .lm | .leftmargin [+|-][n]
                default: 0      inital: 0       break: yes
                set left margin to column n+1
----------------------------------------------------------
.ti | .i | .left [+|-][n]
                default: 0      initial:        break: yes
                temporarily indent next output n spaces
----------------------------------------------------------
.st | .spaceto [-][n]
                default: 0      initial:        break: yes
                space to line +n from top
                space to line -n from bottom
----------------------------------------------------------
.sp | .s | .skip [n]
                default: 1      initial:        break: yes
                space n lines except at top of page
----------------------------------------------------------
.ce | .center [n | on | off]
                default: 1      initial         break: yes
                center next n lines
                center until turned off
----------------------------------------------------------
.ul | .underline [n | on | off]
                default: 1      initial         break: no
                underline next n lines
                underline until turned off
----------------------------------------------------------






1.0                        Appendix A                          31


----------------------------------------------------------
.ul | .underline [all | words]
                default: words  initial: words  break: no
                set mode for underline - words or all
----------------------------------------------------------
.bd | .bold [n | on | off]
                default: 1      initial:        break: no
                boldface (overstrike) next n lines
                boldface until turned off
----------------------------------------------------------
.db | .dbo | .disablebolding
                default:        initial: no     break: no
                disable bolding
----------------------------------------------------------
.eb | .ebo | .enablebolding
                default:        initial: yes    break: no
                enable bolding
----------------------------------------------------------
.ls | .spc | .spacing [n]
                default: 1      initial: 1      break: no
                set line spacing to n
----------------------------------------------------------
.bp | .pg | .page [n]
                default: +1     initial: 1      break: yes
                begin a new page and number it n
----------------------------------------------------------
.pn | .pagenumber {roman} | {arabic}
                default:        initial: arabic break: no
                set page numbering to arabic or roman
----------------------------------------------------------
.np | .nopaging
                default:        initial: no     break: yes
                disable paging
----------------------------------------------------------
.pa | .paging
                default:        initial: yes    break: yes
                enable paging
----------------------------------------------------------
.ne | .need | .tp | .testpage [n]
                default: 0      initial:        break: yes/no
                need n lines. Break and generate a new page
                if not available
----------------------------------------------------------
.he | .header <text>
                default: null   initial: null   break: no
                set header to text (/left/center/right/)
----------------------------------------------------------
.fo | .footer <text>
                default: null   initial: null   break: no
                set footer to text (/lef/center/right/)
----------------------------------------------------------






1.0                        Appendix A                          32


----------------------------------------------------------
.oh <text>
                default: null   initial: null   break: no
                set header on odd pages to text
----------------------------------------------------------
.eh <text>
                default: null   initial: null   break: no
                set header on even pages to text
----------------------------------------------------------
.of <text>
                default: null   initial: null   break: no
                set footer on odd pages to text
----------------------------------------------------------
.ef <text>
                default: null   initial: null   break: no
                set footer on odd pages to text
----------------------------------------------------------
.po | .offset [+|-][n]
                default: 0      initial: 0      break: yes
                set page offset to n spaces
----------------------------------------------------------
.rm | .rightmargin [+|-][n] 
                default: 65     initial: 65     break: no
                set right margin to column n
----------------------------------------------------------
.pl | .ps | .pagesize [n]
                default: 66     initial: 66     break: no
                set page length to n lines
----------------------------------------------------------
.m1 [n]
                default: 3      initial: 3      break: no
                lines between top of page and header
----------------------------------------------------------
.m2 [n]
                default: 2      initial: 2      break: no
                lines between header and text
----------------------------------------------------------
.m3 [n]
                default: 2      initial: 2      break: no
                lines between text and footer
----------------------------------------------------------
.m4 [n]
                default: 3      initial: 3      break: no
                lines between footer and bottom
----------------------------------------------------------
.cl | .contline [<n> <text>]
                default:        initial:        break: yes
                enter text into table of contents at level
                n
----------------------------------------------------------







1.0                        Appendix A                          33


----------------------------------------------------------
.pc | .printcont [n]
                default: 3      initial: 3      break: yes
                print table of contents, indent each level
                n spaces
----------------------------------------------------------
.vs | .set <variable> [definition]
                default:        initial:        break: no
                set variable to text
----------------------------------------------------------
.vg | .get <variable> <prompt>
                default:        initial:        break: no
                set variable interactively, using text
                as prompt
----------------------------------------------------------
.nr <a-z> [+|-][n]
                default: 0      initial: 0      break: no
                set number register (a-z) to n
----------------------------------------------------------
.cc | .cchar [char]
                default: "."    initial: "."    break: no
                set command control character to char
----------------------------------------------------------
.ec | .echar [char]
                default: "_"    initial: "_"    break: no
                set universal escape character to char
----------------------------------------------------------
.so | .source | .include | .require [filename]
                default:        initial: input  break: no
                switch input to file
----------------------------------------------------------
.sv | .save
                default:        initial:        break: yes
                save the current formatter context on 
                context stack
----------------------------------------------------------
.rs | .restore
                default:        initial:        break: yes
                restore the formatter context from context
                stack
----------------------------------------------------------
.lx | .lex <command> [equate]
                default:        initial:        break: no
                rename a command
----------------------------------------------------------
.ap | .autoparagraph
                default:        initial: no     break: no
                enable auto-paragraphing
----------------------------------------------------------








1.0                        Appendix A                          34


----------------------------------------------------------
.na | nap | .noautoparagraph
                default:        initial: yes    break: no
                disable auto-paragraphing
----------------------------------------------------------
.wr | .write <string>
                default:        initial:        break: no
                write a special string to output. line
                counter does not change
----------------------------------------------------------
.de | .define <macro name>
                default:        initial:        break: no
                define a macro command - ends at ".en"
----------------------------------------------------------
.en
                default:        initial:        break: no
                end the macro definition
----------------------------------------------------------










































                        Table Of Contents

                            PROFF 1.0
1.0 Introduction    .......................................    1

2.0 General Description   .................................    2

   2.1 The Input   ........................................    2
      2.1.1 Text    .......................................    2
      2.1.2 Commands    ...................................    2

   2.2 The Output   .......................................    3

   2.3 Executing PROFF   ..................................    3

   2.4 Bibliographic Notes   ..............................    4

   2.5 References and Readings  ...........................    4

3.0 Command Descriptions   ................................    5

   3.1 Filling and Justifying  ............................    6
      .fi | .f | .fill.....................................    6
      .nf | .nofill........................................    6
      .ju | .j | .justify..................................    6
      .nj | .nojustify.....................................    6

   3.2 Text Formatting   ..................................    7
      .br | .break.........................................    7
      .in | .lm | .leftmargin [+|-][n].....................    7
      .ti | .i | .left [+|-][n]............................    7
      .st | .spaceto [-][n]................................    7
      .sp | .s | .skip [n].................................    7
      .ce | .center [n | on | off].........................    7
      .ul | .underline [n | on | off]......................    7
      .ul | .underline [all | words].......................    8
      .bd | .bold [n | on | off]...........................    8
      .db | .dbo | .disablebolding.........................    8
      .eb | .ebo | .enablebolding..........................    8

   3.3 Page Formatting   ..................................    9
      .ls | .spc | .spacing [n]............................    9
      .bp | .pg | .page [n]................................    9
      .pn | .pagenumber {roman} | {arabic}.................    9
      .np | .nopaging......................................    9
      .pa | .paging........................................    9
      .ne | .need | .tp | .testpage [n]....................    9
      .he | .header <text>.................................    9
      .fo | .footer <text>.................................   10
      .oh <text>...........................................   10
      .eh <text>...........................................   10
      .of <text>...........................................   10


                              - I -





      .ef <text>...........................................   10

   3.4 Page Layout   ......................................   11
      .po | .offset [+|-][n]...............................   11
      .rm | .rightmargin [+|-][n]..........................   11
      .pl | .ps | .pagesize [n]............................   11
      .m1 [n]..............................................   12
      .m2 [n]..............................................   12
      .m3 [n]..............................................   12
      .m4 [n]..............................................   12

   3.5 Table of Contents  .................................   13
      .cl | .contline [<n> <text>].........................   13
      .pc | .printcont [n].................................   13

   3.6 Miscellaneous    ...................................   15
      .vs | .set <variable> [definition]...................   15
      .vg | .get <variable> <prompt>.......................   15
      .nr <a-z> [+|-][n]...................................   16
      .cc | .cchar [char]..................................   16
      .ec | .echar [char]..................................   16
      .so | .source | .include | .require [filename].......   16
      .sv | .save..........................................   16
      .rs | .restore.......................................   17
      .lx | .lex <command> [equate]........................   17
      .ap | .autoparagraph.................................   17
      .na | nap | .noautoparagraph.........................   17
      .wr | .write <string>................................   18

   3.7 Defining New Commands (Macros) .....................   20
      .de | .define <macro name>...........................   20
      .en..................................................   20

4.0 Executing PROFF   .....................................   23

5.0 Tips on using PROFF ...................................   25
   5.1 Care and Feeding of Memory..........................   25
   5.2 Formatting without fuss  ...........................   25
   5.3 Variables within macros  ...........................   25

6.0 Example macros   ......................................   27

7.0 Acknowledgements    ...................................   29

Appendix A    .............................................   30









                             - II -

