.TH NUMEQN l
.SH NAME
numeqn - Troff Equation Numbering Package
.SH SYNOPSIS
.B numeqn
[ options ] [ files ... ]
.SH DESCRIPTION
.I Numeqn
is a general purpose automatic numbering filter for
.I troff,
useful
primarily for numbering equations, but powerful enough to number anything
else as well.  Numbers are formed from ASCII characters, portions of the
header number (from .NH or .sh), and one of 10 different sequence counters,
with optional subscripts.
Equations are numbered by including a special "generate number" argument
for the .EQ equation macro.  Any of these numbers
may also be inserted at any point
in the text by using the .E# macro.  These numbers may be assigned to
.I numeqn
variables, and then later used elsewhere in the text.  Furthermore, very
flexible format control is available via a mechanism similar to that
used by "printf" in the standard I/O library.
.PP
To minimize the quantity
of data passed through the
.I troff
filters,
.I numeqn
should typically used before
.I tbl ,
.I eqn ,
or
.I troff.
For example:
.sp 1v
.in 1i
refer file | numeqn | tbl | eqn | troff -ms >wowee
.LP
Available switches for
.I numeqn
are listed at the end of this document.
.PP
.I Numeqn
recognizes the following troff macros:
.nf
.sp 1
	.EQ [L,I,C] [value,#,##,##+,#tag,##tag,##+tag] [=tag] [indent]
.sp 1
	.E# [value,#,##,##+,#tag,##tag,##+tag] [=tag] [text]
.sp 1
	.NH [level]			- for ms macro package
.sp 1	
	.sh level title [numbers ...]	- for me macro package
.sp 1
.fi
Ordinarily, any ASCII string following the optional L, C or I arguments
in the .EQ equation macro will be printed as the equation number.  If
this string begins with the character '#', however,
.I numeqn
will use this argument to generate an appropriate equation number. 
An optional following argument
.I '=tag'
will set a variable named
.I tag
to the generated number. This number may be inserted later in the text
by using a
.I '#tag'
argument to the .E# numbering macro.  For example, if we are in section
3.5 of a paper, the following:
.nf
.sp 1
	.EQ C "[hi there]"
	x=y
	.EN
	.EQ C # =N1
	n=1
	.EN
	.EQ # =MM5
	m=m*5
	.EN
	.EQ #
	5-7+2=19
	.EN
	Combining equations
	.E# #N1
	and
	.E# #MM5 ,
	generates bliss.
.fi
.sp 1
will generate:
.nf
.sp 1
.tl ''x=y'[hi there]'
.sp 0.5v
.tl ''n=1'(3.5.1)'
.sp 0.5v
.tl ''m=m*5'(3.5.2)'
.sp 0.5v
.tl ''5-7+2=19'(3.5.3)'
.sp 0.5v
	Combining equations (3.5.1) and (3.5.2), generates bliss.
.fi
.sp 1
.PP
The first equation uses the string "[hi there]" as the equation number. 
This string could have been stored in a tag variable by following it
with an argument of the form
.I '=tag' .
The second and third .EQ equation macros automatically generate
sequential numbers, and set the variables "N1" and "MM5" to these values.
The .E# macros that follow will be replaced with the contents
of the specified tag
variables.  Note that any text following the arguments to .E# will be
inserted immediately following the number with no intervening space.
This is convenient in examples such as the second .E# above, in which a
comma was inserted immediately following the MM5 equation number.  
.PP
Tag variable names may be formed from any non-space characters.  If
spaces or tabs are desired in the tag name, simply enclose the name in
quotation marks.  Tag names formed solely out of digits are considered
"local" and may be reused.  All other tag names are considered "global",
and must not be redefined.
.PP
Sequential subscripted numbers may be generated by replacing the '#'
argument to .EQ with '##' or '##+'.  The '##' argument specifies that
the next subscripted number should be used; the '##+' argument
increments the sequence number and resets the subscript back to 'a'. 
For example:
.nf
.sp 1
	.EQ C ##
	a=b
	.EN
	.EQ C ## =21
	b=c
	.EN
	Refer to
	.E# #21
	and rejoice!
	.EQ C ##+
	z=5
	.EN
	.EQ ##+ =21
	y=6+5
	.EN
	and another
	.E# #21 !
.sp 1
.fi
will generate:
.sp 1
.nf
.tl ''a=b'(3.5.4a)'
.sp 0.5v
.tl ''b=c'(3.5.4b)'
.sp 0.5v
	Refer to (3.5.4b) and rejoice!
.sp 0.5v
.tl ''z=5'(3.5.5a)'
.sp 0.5v
.tl ''y=6+5'(3.5.6a)'
.sp 0.5v
	and another (3.5.6a)!
.sp 1
.fi
.PP
The .E# macro can also be used to automatically generate and insert
numbers in the text, or to set tag variables to specific values.  For example:
.nf
.sp 1
	Another
	.E# #
	number and another
	.E# ##
	subscripted number.  Let's set a tag
	.E# ## =Z9.2
	variable and another
	.E# "hi there" =H32ZX_4
	and now use it here
	.E# #H32ZX_4
	and here:
	.EQ C #Z9.2
	h=3.2*z/x+4
	.EN
.sp 1
.fi
will yield:
.nf
.sp 1
	Another (3.5.7) number and another (3.5.8a) subscripted
	number.  Let's set a tag variable and another and now use
	it here (3.5.9) and here:
.sp 0.5v
.tl ''h=3.2*z/x+4'(3.5.8b)'
.sp 1
.fi
.PP
The arguments #, ## or ##+ can thus automatically generate numbers for
both .E# and .EQ macros, tag variables may be set with '=tag'
by either .E# or .EQ,
and the contents of a tag variable may be inserted by either .E# or .EQ
by using the '#tag' argument.  Note that when the .E# macro is used to
set a tag variable that the number is NOT inserted in the text and any
characters immediately following the 
.I =tag
argument will be discarded.
This feature allows setting tag variables "invisibly"
without inserting the number
in the text.
.PP
Both .E# and .EQ set the troff string variable E# to the number they generate.
This makes it convenient to embed the number in complicated troff
constructions by referring to the string variable \\*(E# where needed.
Thus:
.nf
.sp 1
	A number:
	.E# # .
	And again: \\*(E# and\\*(E#here too.
.sp 1
.fi
will generate:
.nf
.sp 1
	A number: (3.5.10).  And again: (3.5.10) and(3.5.10)here too.
.sp 1
.fi
.PP
.I Numeqn
allows extremely flexible control over the formatting of the
numbers it generates by using a mechanism similar to that used by
"printf" in the standard I/O package.  The tag variable named
"format" contains an ASCII
string which specifies the default format used for all numbers generated
by using the #, ## and ##+ arguments to .E# or .EQ.  Ordinary characters
in this format string will be printed exactly as specified in every number. 
Varying information, such as the section header and sequence number, may be
specified by using a sequence of characters starting with a '%'.  The
following character sequences are recognized in format strings:
.nf
.sp 1
	%h	- insert the complete header number at this point.
.sp 1
	%nh	- (1<=n<=5) insert only levels 1 through n of the header
		number at this point.
.sp 1
	%s	- insert the next sequential value of counter 0.
.sp 1	
	%ns	- (0<=n<=9) insert the next sequential value of counter n.
.sp 1	
	%n.ms	- (0<=n<=9 and 0<=m<=5) insert the next sequential value of
		counter n, and make sure this counter is reset to 0 each time
		a new section header at level m or below is created.  If m=0,
		the counter will never reset.
.sp 1
	%%	- insert the character '%'
.sp 1
.fi
The default format is (%2h%0.2s), which will produce numbers like (3.5.6) or
(3.5.6c) in section 3.5 for the sixth item (third subscripted number.)
The default format could be changed, for example, by:
.sp 1
.nf
	.E# [A:%h%s] =format
.sp 1
.fi
which sets the variable
.I "format"
to the ASCII string "[A:%h%s]" without printing anything.
Now the default format will print numbers which might look like: [A:3.5.6]
.PP
Usually sequence counters will be reset to 0 whenever a .NH command (or .sh
command for the -me macro package) is encountered which would change the
part of the header number which is used in forming the equation number.
This rule may be changed by using the full %n.ms specification.
.PP
The arguments #tag, ##tag, ##+tag to .EQ and .E# actually allow using the
contents of a tag variable to specify the format for this number.  If the tag
variable contains a string with no '%' characters, then its contents
will be used unmodified as the number to be inserted.  If the string value
in the tag variable contains character
sequences such as '%h' or '%s', however,
the appropriate header and sequence numbers
will be inserted and appropriately updated.
Thus, for example, we could define a numbering
format T for tables by:
.sp 1
.nf
	.E# %1h%2s =T
.fi
.sp 1
No text is generated for this line.  After this, however, a new table
number could be generated by:
.nf
.sp 1
	Table
	.E# #T
	is great!
.sp 1
.fi
which will insert
.nf
.sp 1
	Table 3.1 is great!
.sp 1
.fi
if we are still in section 3 and this is the first table.
Note that the T format uses sequence counter
number 2, and therefore tables will be numbered independently of
any number printed using the default format, which typically uses
sequence counter 0.
.PP
Certain tag variable names are reserved
and have special meaning:
.nf
.sp 1
	format	- contains the default numbering format string.  Setting
		this variable changes the default numbering style.
.sp 1		
	%s	- contains the last sequence number used on sequence
		counter 0.  Changing this variable by:  ".E# 5c =%s"
		would change the next sequential subscripted number to 5c.
.sp 1		
	%ns	- (0<=n<=9) contains the value of sequence counter n.
.sp 1
	%h	- contains the complete header number (read-only in -me).
.sp 1
	%nh	- contains the first n levels of the header (read-only
		in -me).
.sp 1
.fi
.PP
Various options may be specified on the command line:
.nf
.sp 1
	-f string     	use "string" as the default numbering format
	-h level      	use "level" as the initial header number (this also
			  affects the first .NH command) (valid only for -ms)
	-s number     	use "number" as the initial number in counter 0
	-t tagfile    	when finished, output a list of all tag variable
			  values to "tagfile"
	-ms		-ms macro package format (default)
	-me		-me macro package format
.sp 1
.fi
The -t option constructs an output file containing lines of the form:
.nf
.sp 1
	.E# "(3.5.1)" ="N1"
.fi
.sp 1
for every tag variable which is defined in the file.  This is
convenient, for example, when running off very long text files in sections.
Simply include the tag file from the previous section as the first text
file when running 
.I numeqn
on the next section - this will correctly define all the
tag variables, and will allow referring to equation numbers from
previous sections.  A similar trick also allows forward referencing of
equation numbers.  For example,
.sp 1
.nf
	numeqn -me -t sect1tags  junk.vr >/dev/null
	numeqn -me  sect1tags junk.vr >wowee
.sp 1
.fi
will collect all the tag variable definitions in a file "set1tags".
The second time
.I numeqn
is called, it will read "set1tags" first, thus setting all the tag
variables to their correct values before "junk.vr" is processed.
Now single level forward references can be resolved.
.SH SEE ALSO
.BR troff (1),
.BR eqn (1),
.BR ms (7),
.BR me (7)
.SH AUTHOR
Copyright Bruce R. Musicus 1990.  This program is being released into the
public domain.  Unlimited personal use and distribution is permitted, but 
this package may not be incorporated into a commercial product.
.SH BUGS
Each sequence counter should be used in only one format string.  If a
counter must be shared between several formats, be sure that all use
exactly the same '%n.ms' specification.  Otherwise, the sequence
counter will reset according to the last defined format string header level.
.PP
The \-t option should also save the value of all sequence counters.
.PP
.I numeqn
tries to continue no matter what bizarre syntax errors
are found.  As a result, it will return a 0 exit status even if
millions of syntax errors occurred.
.PP
This program is subject to change as conceptual bugs are found,
and as better ideas come to mind.

