 	/*****************************************************************
	*                                                                *
	*   The following is an initialization for an HP Laserjet+ with  *
	*   a Math Elite font cartridge.  The produced table will make   *
	*   nroff(1) behave very similar to troff(1) except that only    *
	*   one font size is available in nroff(1).  So, for instance,   *
	*   is underlining (.ul and .cu) replaced by italic since this   *
        *   is what troff(1) does.  Maximum allowed nroff(1) resolution  *
	*   (1/240 inch) is utilized.  Pity, since Laserjet+ really has  *
	*   1/720 inch resolution.                                       *
	*                                                                *
	*   This version is for fixed character spacing.                 *
	*                                                                *
	*   1987-10-31 -- Bo Thide', Swedish Institute of Space Physics, *
	*   S-755 90 Uppsala, Sweden.  UUCP: ....enea!kuling!irfu!bt     *
	*                                                                *
	*****************************************************************/

#ifndef	INCH
#define	INCH	240
#endif

struct t {
	int bset;
	int breset;
	int Hor;
	int Vert;
	int Newline;
	int Char;
#ifdef KANJI
	int Kchar;
#endif KANJI
	int Em;
	int Halfline;
	int Adj;
	char *twinit;
	char *twrest;
	char *twnl;
	char *hlr;
	char *hlf;
	char *flr;
	char *bdon;
	char *bdoff;
	char *iton;
	char *itoff;
	char *ploton;
	char *plotoff;
	char *up;
	char *down;
	char *right;
	char *left;
	char *codetab[256-32];
	char *zzz;
} t =	{
/*bset    */		00,
/*breset  */		054,
/*Hor     */		1,
/*Vert    */		1,
/*Newline */		40,
/*Char    */		20,
#ifdef KANJI
/*Kchar   */		40,
#endif KANJI
/*Em      */		20,
/*Halfline*/		20,
/*Adj     */		20,
/*twinit  */		"\033&l0O\033&l66F\033&l6D\033&l3E\033&a0L\033(8U\033)0A",
/*twrest  */		"\033&l6D",
/*twnl    */		"\n",
/*hlr     */		"\033&a-.5R",
/*hlf     */		"\033=",
/*flr     */		"\033&a-1R",
/*bdon    */		"\033(ss5B",
/*bdoff   */		"\033(s0B",
/*iton    */		"\033(sb1S",
/*itoff   */		"\033(s0S",
/*ploton  */		"\033&l6D",
/*plotoff */		"\033&l6D",
/*up      */		"\033&a-3V",
/*down    */		"\033&a+3V",
/*right   */		"\033&a+3H",
/*left    */		"\033&a-3H",
/* space */         	"\001 ",
/* ! */             	"\201!",
/* " */             	"\201\"",
/* # */             	"\201#",
/* $ */             	"\201$",
/* % */             	"\201%",
/* & */             	"\201&",
/* ' close */       	"\201'",
/* ( */             	"\201(",
/* ) */             	"\201)",
/* * */             	"\001*",
/* + */             	"\001+",
/* , */             	"\201,",
/* - hyphen */      	"\001-",
/* . */             	"\001.",
/* / */             	"\201/",
/* 0 */             	"\0010",
/* 1 */             	"\0011",
/* 2 */             	"\0012",
/* 3 */             	"\0013",
/* 4 */             	"\0014",
/* 5 */             	"\0015",
/* 6 */             	"\0016",
/* 7 */             	"\0017",
/* 8 */             	"\0018",
/* 9 */             	"\0019",
/* : */             	"\201:",
/* ; */             	"\201;",
/* < */             	"\001<",
/* = */             	"\001=",
/* > */             	"\001>",
/* ? */             	"\201?",
/* @ */             	"\201@",
/* A */             	"\201A",
/* B */             	"\201B",
/* C */             	"\201C",
/* D */             	"\201D",
/* E */             	"\201E",
/* F */             	"\201F",
/* G */             	"\201G",
/* H */             	"\201H",
/* I */             	"\201I",
/* J */             	"\201J",
/* K */             	"\201K",
/* L */             	"\201L",
/* M */             	"\201M",
/* N */             	"\201N",
/* O */             	"\201O",
/* P */             	"\201P",
/* Q */             	"\201Q",
/* R */             	"\201R",
/* S */             	"\201S",
/* T */             	"\201T",
/* U */             	"\201U",
/* V */             	"\201V",
/* W */             	"\201W",
/* X */             	"\201X",
/* Y */             	"\201Y",
/* Z */             	"\201Z",
/* [ */             	"\001[",
/* \ */             	"\001\\",
/* ] */             	"\001]",
/* ^ */             	"\201^",
/* _ dash */        	"\201_",
/* ` open */        	"\201`",
/* a */             	"\201a",
/* b */             	"\201b",
/* c */             	"\201c",
/* d */             	"\201d",
/* e */             	"\201e",
/* f */             	"\201f",
/* g */             	"\201g",
/* h */             	"\201h",
/* i */             	"\201i",
/* j */             	"\201j",
/* k */             	"\201k",
/* l */             	"\201l",
/* m */             	"\201m",
/* n */             	"\201n",
/* o */             	"\201o",
/* p */             	"\201p",
/* q */             	"\201q",
/* r */             	"\201r",
/* s */             	"\201s",
/* t */             	"\201t",
/* u */             	"\201u",
/* v */             	"\201v",
/* w */             	"\201w",
/* x */             	"\201x",
/* y */             	"\201y",
/* z */             	"\201z",
/* { */             	"\001{",
/* | */             	"\201|",
/* } */             	"\001}",
/* ~ */             	"\201~",
/* narrow sp */     	"\200",
/* hyphen */        	"\001-",
/* bullet */        	"\001\033(1QL\033(0@",
/* square */        	"\001\033(2Ql\033(0@",
/* 3/4 em */        	"\001\033(0Q-\033(0@",
/* rule */          	"\001_",
/* 1/4 */           	"\001\033(0Ew\033(0@",
/* 1/2 */           	"\001\033(0Ex\033(0@",
/* 3/4 */           	"\0033/4",
/* minus */         	"\001\033(0Q-\033(0@",
/* fi */            	"\202fi",
/* fl */            	"\202fl",
/* ff */            	"\202ff",
/* ffi */           	"\203ffi",
/* ffl */           	"\203ffl",
/* degree */        	"\001\033(0Q#\033(0@",
/* dagger */        	"\001\016>\017",
/* section */       	"\001\033(0E=\033(0@",
/* foot mark */     	"\001\033(0Q'\033(0@",
/* acute accent */  	"\001'",
/* grave accent */  	"\001`",
/* underrule */     	"\001_",
/* slash (longer) */	"\001/",
/* half narrow space */	"\200",
/* unpaddable space */	"\001 ",
/* alpha */         	"\001\016a\017",
/* beta */          	"\001\016b\017",
/* gamma */         	"\001\016q\017",
/* delta */         	"\001\016w\017",
/* epsilon */       	"\001\016e\017",
/* zeta */          	"\001\016z\017",
/* eta */           	"\001\016h\017",
/* theta */         	"\001\033(0Qh\033(0@",
/* iota */          	"\001\016i\017",
/* kappa */         	"\001\016k\017",
/* lambda */        	"\001\016g\017",
/* mu */            	"\001\016m\017",
/* nu */            	"\001\016n\017",
/* xi */            	"\001\016u\017",
/* omicron */       	"\001\033(0Qo\033(0@",
/* pi */            	"\001\016p\017",
/* rho */           	"\001\016o\017",
/* sigma */         	"\001\016s\017",
/* tau */           	"\001\016t\017",
/* upsilon */       	"\001\016y\017",
/* phi */           	"\001\016d\017",
/* chi */           	"\001\016k\017",
/* psi */           	"\001\016c\017",
/* omega */         	"\001\016l\017",
/* Gamma */         	"\001\016+\017",
/* Delta */         	"\001\016v\017",
/* Theta */         	"\001\016j\017",
/* Lambda */        	"\001\016;\017",
/* Xi */            	"\001\016/\017",
/* Pi */            	"\001\016*\017",
/* Sigma */         	"\001\016?\017",
/* Tau */           	"\001T",
/* Upsilon */       	"\001\016]\017",
/* Phi */           	"\001\016.\017",
/* Psi */           	"\001\016,\017",
/* Omega */         	"\001\016:\017",
/* square root */   	"\001\016!\017",
/* terminal sigma */	"\001\033(0Q[\033(0@",
/* root en */       	"\001\033(1Q0\033(0@",
/* >= */            	"\001\033(0Q^\033(0@",
/* <= */            	"\001\033(0Q\\\033(0@",
/* identically equal */	"\001\016-\017",
/* equation minus */	"\001\033(0Q-\033(0@",
/* approx = */      	"\001\033(0Q?\033(0@",
/* approximates */  	"\001~",
/* not equal */     	"\001\033(0Q]\033(0@",
/* right arrow */   	"\001\016|\017",
/* left arrow */    	"\001\016~\017",
/* up arrow */      	"\001\016{\017",
/* down arrow */    	"\001\016_\017",
/* eqn equals */    	"\001=",
/* multiply */      	"\001\033(0Q*\033(0@",
/* divide */        	"\001\016(\017",
/* plus-minus */    	"\001\016%\017",
/* cup (union) */   	"\001\033(1Q5\033(0@",
/* cap (intersection) */	"\001\033(1Q6\033(0@",
/* subset of */     	"\001\033(1Q:\033(0@",
/* superset of */   	"\001\033(1Q;\033(0@",
/* improper subset */	"\001\033(1Q>\033(0@",
/*  improper superset */	"\001\033(1Q?\033(0@",
/* infinity */      	"\001\016<\017",
/* pt deriv */      	"\001\016F\017",
/* gradient */      	"\001\016$\017",
/* not */           	"\001\033(1QH\033(0@",
/* integral */      	"\001\033(1QU\033(0@",
/* proportional to */	"\001\016&\017",
/* empty set */     	"\001\033(1QX\033(0@",
/* member of */     	"\001\033(1Q7\033(0@",
/* equation plus */ 	"\001+",
/* registration mk */	"\001\033(2Q,\033(0@",
/* copyright mk */  	"\001\033(2Q-\033(0@",
/* box rule */      	"\001\033(1Qv\033(0@",
/* cent sign */     	"\001\033(0E?\033(0@",
/* dbl dagger */    	"\001\033(1QO\033(0@",
/* right hand */    	"\001\033(1Q&\033(0@",
/* left hand */     	"\001\033(1Q(\033(0@",
/* math *  */       	"\001*",
/* bell system sign */	"\001\033(2QS\033(0@",
/* or (was star) */ 	"\001|",
/* circle */        	"\001\033(1QM\033(0@",
/* left top of big curly */	"\001\033(1Qb\033(0@",
/* left bottom of big curly */	"\001\033(1Qd\033(0@",
/* right top of big curly */	"\001\033(1Qr\033(0@",
/* right bottom of big curly */	"\001\033(1Qt\033(0@",
/* left center of big curly */	"\001\033(1Qc\033(0@",
/* right center of big curly */	"\001\033(1Qs\033(0@",
/* bold vertical rule */	"\001\033(1Qu\033(0@",
/* left bottom of big bracket */	"\001\033(1Qa\033(0@",
/* right bottom of big bracket */	"\001\033(1Qq\033(0@",
/* left top of big bracket */	"\001\033(1Q`\033(0@",
/* right top of big bracket */	"\001\033(1Qp\033(0@",
};
