/*
 * inserts - process form-letter-ish insertions
 *
 * $Log$
 */

#include <stdio.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <string.h>

#define	MAXSTR	500		/* For sizing strings -- DON'T use BUFSIZ! */
#define	STREQ(a, b)	(*(a) == *(b) && strcmp((a), (b)) == 0)

#ifndef lint
static char RCSid[] = "$Header$";
#endif

/* storage for document body */
#define	MAXBODY	30000
#define	MAXSEGS	100
char body[MAXBODY];		/* relies on initialization to 0 */
int nbody = 0;			/* chars in body */
char *segs[MAXSEGS] = { body };	/* ptrs to NUL-terminated body segments */
int nsegs = 1;

/* markers in text */
char *inspoint = ".RD";		/* insertion point in body */
char *endbody = ".INSERTS";	/* end of body */
char *separator = ".END";	/* separator between copies in output */
int dowarn = 1;			/* supply warnings? */

int debug = 0;
char *progname;

char **argvp;				/* scan pointer for nextfile() */
char *nullargv[] = { "-", NULL };	/* dummy argv for case of no args */
char *inname;				/* filename for messages etc. */
char *filename = NULL;			/* -f overrides inname for messages */
long lineno;				/* line number for messages etc. */
FILE *in = NULL;			/* current input file */

char *ifile = NULL;			/* -i file, if any */
int istart = 0;				/* just starting ifile? */

extern void error(), exit();
#ifdef UTZOOERR
extern char *mkprogname();
#else
#define	mkprogname(a)	(a)
#endif

char *nextfile();
void fail();
void getfirst();
void getins();

/*
 - main - parse arguments and handle options
 */
main(argc, argv)
int argc;
char *argv[];
{
	int c;
	int errflg = 0;
	extern int optind;
	extern char *optarg;
	void process();

	progname = mkprogname(argv[0]);

	while ((c = getopt(argc, argv, "p:e:s:wi:d")) != EOF)
		switch (c) {
		case 'p':	/* insertion-point marker */
			inspoint = optarg;
			break;
		case 'e':	/* end-of-body marker */
			endbody = optarg;
			break;
		case 's':	/* output separator */
			separator = optarg;
			break;
		case 'w':	/* suppress warnings */
			dowarn = 0;
			break;
		case 'i':	/* this is file of inserts */
			ifile = optarg;
			break;
		case 'd':	/* Debugging. */
			debug++;
			break;
		case '?':
		default:
			errflg++;
			break;
		}
	if (errflg) {
		fprintf(stderr, "usage: %s ", progname);
		fprintf(stderr, "[-i inspt] [-e end] [-s outsep] [file] ...\n");
		exit(2);
	}

	if (optind >= argc)
		argvp = nullargv;
	else
		argvp = &argv[optind];
	inname = nextfile();
	if (inname != NULL)
		process();
	exit(0);
}

/*
 - getline - get next line (internal version of fgets)
 */
char *
getline(ptr, size)
char *ptr;
int size;
{
	register char *namep;

	while (fgets(ptr, size, in) == NULL) {	/* while no more */
		namep = nextfile();		/* try next source */
		if (namep == NULL)
			return(NULL);		/* really no more */
		inname = namep;
		if (istart) {			/* transition to ifile */
			sprintf(ptr, "%s\n", endbody);
			return(ptr);
		}
	}
	lineno++;
	return(ptr);
}

/*
 - nextfile - switch files
 */
char *				/* filename */
nextfile()
{
	register char *namep;
	struct stat statbuf;
	extern FILE *efopen();

	namep = *argvp;
	if (namep == NULL) {	/* no more files */
		if (ifile == NULL)
			return(NULL);
		else if (istart) {	/* already done the end line */
			istart = 0;
			namep = ifile;
			ifile = NULL;
		} else {		/* supply end line before ifile */
			istart = 1;
			return(inname);
		}
	} else
		argvp++;

	if (in != NULL)
		(void) fclose(in);

	if (STREQ(namep, "-")) {
		in = stdin;
		namep = "stdin";
	} else {
		in = efopen(namep, "r");
		if (fstat(fileno(in), &statbuf) < 0)
			error("can't fstat `%s'", namep);
		if ((statbuf.st_mode & S_IFMT) == S_IFDIR)
			error("`%s' is directory!", namep);
	}

	lineno = 0;
	return(namep);
}

/*
 - fail - complain and die
 */
void
fail(s1, s2)
char *s1;
char *s2;
{
	fprintf(stderr, "%s: (file `%s', line %ld) ", progname,
			(filename != NULL) ? filename : inname, lineno);
	fprintf(stderr, s1, s2);
	fprintf(stderr, "\n");
	exit(1);
}

/*
 - warn - just complain
 */
void
warn(s1, s2)
char *s1;
char *s2;
{
	if (!dowarn)
		return;

	fprintf(stderr, "%s: (file `%s', line %ld) (warning) ", progname,
			(filename != NULL) ? filename : inname, lineno);
	fprintf(stderr, s1, s2);
	fprintf(stderr, "\n");
}

/*
 - process - process input data
 *
 * The MAXBODY check is over-conservative in that it will blow up a few
 * characters too early on an insertion-point or body-end line; big deal.
 */
void
process()
{
	char line[MAXSTR];
#	define	LINSIZ	((int)sizeof(line))
	register int len;
	register int seg;
	int firstbody;		/* first time body has been output? */
	int firstins;		/* first line of first insertion in body? */
	int firstline;		/* first line of an insertion? */

	/* pick up the body */
	while ((len = getbody(line, LINSIZ)) > 0) {
		if (nbody + len >= MAXBODY-1)	/* -1 for final NUL */
			fail("document too large", "");
		line[len-1] = '\0';		/* get rid of newline */
		if (STREQ(line, inspoint)) {
			nbody++;		/* NUL ends that segment */
			body[nbody] = '\0';	/* start new segment */
			segs[nsegs++] = body + nbody;
		} else {
			line[len-1] = '\n';	/* put newline back */
			(void) strcpy(body+nbody, line);
			nbody += len;
		}
	}
	if (nsegs <= 1)
		fail("no insertion points (%s's) found!", inspoint);

	/* insertions */
	firstbody = 1;
	while (getline(line, LINSIZ) != NULL) {
		if (!firstbody) {	/* first body doesn't need separator */
			(void) fputs(separator, stdout);
			(void) fputs("\n", stdout);
		}
		firstbody = 0;
		firstins = 1;
		(void) fputs(segs[0], stdout);
		for (seg = 1; seg < nsegs; seg++) {
			firstline = 1;
			for (;;) {
				if (!firstins) {	/* first line read */
					if (firstline)
						getfirst(line, LINSIZ);
					else
						getins(line, LINSIZ);
				}
				firstins = 0;
				firstline = 0;
				if (STREQ(line, "\n"))
					break;
				(void) fputs(line, stdout);
			}
			(void) fputs(segs[seg], stdout);
		}
	}
	if (firstbody)
		warn("no inserts supplied!", "");
}

/*
 - getbody - get a body line
 */
int				/* length of line; 0 means end of body */
getbody(buf, nbuf)
char *buf;
int nbuf;
{
	register int len;

	if (getline(buf, nbuf) == NULL)
		return(0);
	len = strlen(buf);
	if (buf[len-1] != '\n')
		fail("line too long", "");
	buf[len-1] = '\0';
	if (STREQ(buf, endbody))
		return(0);
	buf[len-1] = '\n';
	return(len);
}

/*
 - getfirst - get first line of insert, EOF turning into empty line
 */
void
getfirst(buf, nbuf)
char *buf;
int nbuf;
{
	static int grumped = 0;

	if (getline(buf, nbuf) == NULL) {
		if (!grumped)
			warn("ran out of inserts in mid-document!", "");
		grumped = 1;
		(void) strcpy(buf, "\n");
	}
}

/*
 - getins - get an insert line, EOF turning into empty line
 *
 * like getfirst except that EOF just ends the insert
 */
void
getins(buf, nbuf)
char *buf;
int nbuf;
{
	if (getline(buf, nbuf) == NULL)
		(void) strcpy(buf, "\n");
}
