/*
 *  ixformat - format an index file for output
 *
 *  Bill Davidsen, June 1986
 *
 *  This program is a filter which accepts the list of subjects
 *  for an index, and the page on which they occur. It then emits
 *  output in xroff format with all refs to a single subject on
 *  one line.
 */

#include <stdio.h>
#define MAXLINE 80		/* longest subject */
#define MAXREFS 10		/* refs to any one subject */

char  current[MAXLINE];		/* current subject */
int  refs[MAXREFS];		/* current refs */
int  nref = 0;			/* # of refs to current subj */

main ()
{
    char  line[MAXLINE];	/* next subject */
    int  page;			/* page of current ref */

    while (scanf ("%[^;];%d", line, &page) == 2)
    { /* see if this is a new subject */
	while (getchar () != '\n'); /* skip to EOL */

	if (nref == 0)
	{ /* this is the first one in */
	    strcpy (current, line);
	    refs[nref++] = page;
	/* get the proper footer on it */
	    printf (".PH \"\"\n.PF \"//- index %% -//\"\n.nf\n");
	    continue;
	}

	if (strcmp (line, current))
	{ /* starting a new subject, output this one */
	    flushref (0);

	/* copy the new subject and page in */
	    strcpy (current, line);
	    refs[0] = page;
	    nref = 1;
	}
	else
	{ /* add a reference to this subject */
	    if (nref == MAXREFS)
		flushref (1);
	    refs[nref++] = page;
	}
    }

 /* if there are references left, flush them */
    if (nref)
	flushref (0);
    exit (0);
}

X/*
 *  flushref - output a subject and all current references to it.
 */

flushref (flag)
    int  flag;
{
    int  ix;			/* loop index */

    printf ("%s  ", current);
    for (ix = 0; ix < nref;)
    { /* output a reference, and comma if more */
	printf ("%d", refs[ix++]);
	if (ix < nref)
	    putchar (',');
    }
    if (flag)
	putchar (',');
    putchar ('\n');
}
