#! /bin/sh
: shell  hyphen
if { [ \( -t 0 \)  -a  \( 0 = $# \) ] ; } then \
{ cat <<DATA ; }
/*
filter troff input, inserting conditional hyphenation
  
hyphen  [ file1 file2 ... ]
  
parameters:
	file		troff file(s) to conditionally hyphenate. Default is
			standard input.
discussion:
Some words are exceptions to troff's built in hyphenation rules.
While troff has a limited facility to handle such exceptions (the
.hw command), the facility is easily overloaded.  This program
is an alternative that inserts explicit conditional hyphenation
(\%) into a system dependent list of exceptions.
*/
DATA
else { sed -f $(LIB)hyphen $* ; }
fi
