#ifndef lint
static char rcsid[] = "$Header: lowtext.c,v 1.3 86/04/25 17:15:14 root Exp $";
#endif

#include "fmtr.h"

int ti_val;

/*  leadbl() deals with leading blanks, causes break, then sets
 *  ti_val to number of blanks, unless line is blank.  Then pulls
 *  line forewards, so text() now has line starting with text, with
 *  ti_val containing the needed indent.
 */

leadbl(line)
char *line;
{
    char *ip;

    n_brk();

    ip = line;
    while (*ip == ' ')
	ip++;
    if (*ip != '\n')
	ti_val += ip - line;
    (void) strcpy(line, ip);
}

/* n_brk() causes a break */

void n_brk()
{
    if (outp > outbuf) {
	    outp--;	/* back off from EOS */
	while (*outp == ' ' && outp >= outbuf)	/* remove trailing blanks */
	    outp--;
	*++outp  = '\0';
	put(outbuf);
    }
    outp = outbuf;
}

/*
 *	getword gets the next word plus trailing space
 *      from the array pointed to by pline and
 *	returns it in that pointed at by word.  If there are
 *	no further words on that line, it returns NULL.
 *	It returns a pointer to the start of the next word.
 */

char *getword(pline, word)
char *pline, *word;
{
    if (*pline == '\0') {
	*word = '\0';
	return(NULL);
    }

    while (*pline != ' ' && *pline != '\0') {
	if (*pline == '\\' && isspace(pline[1])) /* get escaped space in word */
	    *word++ = *pline++;
        *word++ = *pline++;
    }

    /*  get trailing spaces, and guarantee spaces at end of line;
     *  normally one but two at end of sentence.
     */

    if (*pline == '\0') {
	char *cptmp = pline;

	*word++ = ' ';
	while (any(*--cptmp, "\"']})"))
	    ;
	if (any(*cptmp, ".:!?"))
	    *word++ = ' ';
    }
    while (*pline == ' ')
	*word++ = *pline++;
    *word = '\0';
    return(pline);
}

putword(word)	/* put word into output buffer */
char *word;
{
    int s, t;	/* not needed, but greatly simplify if */

    t = strlen(word) - 1;	/* -1 for one trailing blank */
    s = outp - outbuf;
    if (s + t <= llength - ti_val) {
	for (; *word; *outp++ = *word++)
	    ;
	return;
    }
    n_brk();
    for (; *word; *outp++ = *word++)
	;
}

put(line)	/* output routine, separate as is more complex in original */
char *line;
{
    int i;

    for (i = 1; i <= ti_val; i++)
	putchar(' ');
    ti_val = 0;
    puts(line);
}

any(ch, string)	/* returns true if character is in string */
char ch;
char *string;
{
    while (*string)
	if (ch == *string++)
	    return(1);
    return(0);
}
