#ifndef lint
static char rcsid[] = "$Header: fmtr.c,v 1.4 86/05/05 14:09:41 root Exp $";
#endif

/*  fmtr, a formatter for roff source text respecting no fill mode.
 *  The code is derived from a translation to C of Kernighan and
 *  Plaugher's format program.
 */

#include "fmtr.h"

int optind, opterr;
char *optarg, *progname;		/* program name */

main(argc, argv)
int argc;
char *argv[];
{
    int i, c;
    char *sarray, *earray, *getenv();
    FILE *efopen(), *fp;

    progname = argv[0];
    outp = outbuf;
    sarray = earray = (char *) NULL;
    llength = 72;	/* default */

    sarray = getenv("FMTR_S");
    check(sarray, "environmental variable FMTR_S");
    earray = getenv("FMTR_E");
    check(earray, "environmental variable FMTR_E");

    mk_table(sarray, earray);	/* make table of commands from env var */
				/* we call mk_table whether the arrays */
				/* null or not */
    sarray = earray = (char *) 0;

    while ((c = getopt(argc, argv, "zw:s:e:")) != EOF)
	switch (c) {
	    case 'z':
		z_flag = 1;
		break;
	    case 'w':
		llength = atoi(optarg);
		if (llength <= 0 || llength >= BUFSIZ - 2) {
		    fprintf(stderr,"%s: bad line length: %s\n", progname, optarg);
		    exit (1);
		}
		break;
	    case 's':
		sarray = optarg;
		check(sarray, "-s flag");
		break;
	    case 'e':
		earray = optarg;
		check(earray, "-e flag");
		break;
	    case '?':
		usage();
		exit(1);
	}

    mk_table(sarray, earray);	/* make table of commands from flags */
				/* again, always call */

    argc -= optind;
    argv += optind;
    
    fp = stdin;
    i = 0;
    do {
	if (argc > 0)
	    fp = efopen(*argv, "r");
	do_fmt(fp);		/* does real work */
	argv++;
    } while (++i < argc);

    n_brk();
}

check(string, origin)	/* check format of string of macros */
char *string, *origin;
{
    if (string == NULL)
	return;
    if ((string[0] != '.') || strlen(string) % 3 != 0) {
	fprintf(stderr,
	"%s: list of macros '%s' supplied with %s is not in correct format\n",
	progname, string, origin);
	exit(1);
    }
}

/*  do_fmt is where work is done, or rather assigned.  Each line
 *  read has the terminatig newline, and any trailing blanks, removed.
 *  Then it is sent to either command() or text(), depending on whether
 *  it appears to be a command or not.
 */

do_fmt(fp)
FILE *fp;
{
    char *cp, line[10*BUFSIZ];
    int length;

    while (length = fgetsmod(line, sizeof line, fp)) {
	for (cp = &line[length - 2]; *cp == ' ' && cp >= line; cp--)
	    ;
	*++cp = '\0';
        if (*line == '.' || *line == '\'' ||
	  (z_flag && strncmp(line, "\\&.", 3) == 0) ||
	  (z_flag && strncmp(line, "\\&'", 3) == 0))
            command(line);
        else
            text(line);
    }
}

/*  text() checks for leading blanks or blank line, in which case causes
 *  break.  Blank lines output as is, others broken into words by getword()
 *  with words sent to outbuf by putword().
 */

text(line)
char *line;
{
    char *pline, wordbuf[BUFSIZ], *getword();

    if (ul_val || ce_val || nf_val) {
	puts(line);
	if (ul_val)
	    ul_val--;
	if (ce_val)
	    ce_val--;
	return;
    }

    if (*line == ' ' || *line == '\0')
	leadbl(line);
    if (*line == '\0')
	put(line);
    else {		/* main case */
	pline = line;
	do {
	    pline = getword(pline, wordbuf);
	    if (pline)
	        putword(wordbuf);
	} while (pline);
    }
}

usage()
{
    fprintf(stderr,
"usage: %s [ -z ] [ -wn ] [ -s start_string ] [ -e end_string] [ file ... ]\n",
    progname);
}
