/* Naturally when this goes "public" there is that little disclaimer about how
   I would like my name to go with it on its adventures.  It was not written for
   monetary gain, only as a personal convenience.  

		Written by Jeff Slaney November 1985 
				helped by Philip Gross
*/

/* man page - To get to the next page wait for the bell then hit carriage
   return.  Same goes for the end of the program.  It will clear when finished.
   Zoom and pan are permitted.  All pages are drawn as retained segment 1.  
   It may also be necessary to turn off the dialog area.  This is especially
   true on the 4112 and 4113.  Turn it back on at completion.   Also
   if the program is killed it leaves the terminal in graphics mode.  It will
   need to be reset.  Hopefully, there exists a proper host reset.  If not all
   that's needed is to be in setup mode and set the code to ansi 
   ( *code ansi).

	To use: ditroff | tk  -or-   cat <file> | tk

   Please feel free to make additions and corrections.  If you make 
   changes please ship a copy off to me, ihnp4!uiucdcs!uiucme!slaney.
*/


/* Program to allow ditroff output to be processed on any of the following
   Tektronix terminals:  
			  4107, 4109, 4113.
   The following terminals will work but for harware reasons lose certain
   features:
			  4105 - no retained segments, 8 colors
			  4112 - black and white
   This program should work on the 4111 and the 4115, however ....

   The features of this program are:

		complete device independence.  All output from ditroff is
		capable of being processed independent of what device it was
		intended for.  Naturally somethings aren't perfect.  That's why
		this is called a previewer.  It is not intended for
		publications purposes.  Only to give a good indication of
		correct form.  It provides a very convenient method of checking
		for widows at the top of pages.  

		complete character point size mapping.  This exceeds some
		previewers in capability.

		font changes are enabled by changing the color and displaying
		the ascii equivalent.

		currently only line drawing.  The routine for arcs/circles is
		in the library included but draws circles starting from the
		right and proceeding counterclockwise.  ditroff likes it from
		the left.  It may take some playing with.

		character slant is also possible.  The tek routine is included.
		Needs to be played with.

  Areas lacking for this program are:
		
		spline fits

		special characters other than underline

		forward and reverse paging
*/

/*
output language from ditroff:
all numbers are character strings

sn	size in points
fn	font as number from 1-n
cx	ascii character x
Cxyz	funny char xyz. terminated by white space
Hn	go to absolute horizontal position n
Vn	go to absolute vertical position n (down is positive)
hn	go n units horizontally (relative)
vn	ditto vertically
nnc	move right nn, then print c (exactly 2 digits!)
		(this wart is an optimization that shrinks output file size
		 about 35% and run-time about 15% while preserving ascii-ness)
Dt ...\n	draw operation 't':
	Dl x y		line from here by x,y
	Dc d		circle of diameter d with left side here
	De x y		ellipse of axes x,y with left side here
	Da x y r	arc counter-clockwise by x,y of radius r
	D~ x y x y ...	wiggly line by x,y then x,y ...
nb a	end of line (information only -- no action needed)
	b = space before line, a = after
p	new page begins -- set v to 0
#...\n	comment
x ...\n	device control functions:
	x i	init
	x T s	name of device is s
	x r n h v	resolution is n/inch
		h = min horizontal motion, v = min vert
	x p	pause (can restart)
	x s	stop -- done for ever
	x t	generate trailer
	x f n s	font position n contains font s
	x H n	set character height to n
	x S n	set slant to N

	Subcommands like "i" are often spelled out like "init".
*/

#define TOP 3132
#define ESC 27
#define EOL 10

#include <stdio.h>
#include <ctype.h>

char c;
int i;
int currentx, currenty;
int absx, absy;
int point_size, raster_size;
int char_width;
int resolution;
float rasters_per_point;

main(argc,argv)
int argc;
char *argv[];
{
	/* initialize */
	currentx = 0;
	currenty = 0;
	rasters_per_point = .6591;  /* set initially for a phototypesetter */

	/* initialize the terminal */
		/* put in tek mode */
		select_code(0);
		/* set the window */
		set_window(0,0,4095,TOP);
		page();
		/* set the graphtext precision to stroke */
		graphtx_prec(2);

	while ((c = getchar()) != EOF)
		switch(c){

		case 'p':
			/* close off all open segments for next page */
			if (ctoi() != 1) {
				end_segment();
				printf("%c",7);		/* signal end of page */
				fflush(stdout);
				readch();
			} /* if not first page */
			/* erase retained segments */
			del_segment(-1);
			page();
			/* don't clear screen: leave dialog area alone */
			/* open retained segment 1 */
			begin_seg(1);
			/* draw a line down the right margin */
			move(2420,0);
			draw(2420,TOP);
			move(currentx,currenty);
			break;

		case 's':
			/* point size */

			/*  The font size is determined only by the terminal
			being used.  The device formatted for does not enter
			in.   A simple conversion is all that is needed.
			72(points/inch) * 11(inches/page) = 792(points/page)
			3132(rasters/page) * 1/792(page/points) =
							3.95(rasters/point)
				point size 1 = raster size 3.95
			*/

			point_size = ctoi();
			raster_size = point_size * 3.95;
			char_width = raster_size * .5; /* it looks good */
			graphtx_size(char_width,raster_size,raster_size);
			break;

		case 'f':	/* font change */
			text_index(ctoi());		/* just change color */
			break;

		case 'h':	/* relative horizontal move */
			absx = absx + ctoi();
			currentx = absx * rasters_per_point;
			move(currentx,currenty);
			break;

		case 'v':	/* relative move vertical */
			absy = absy + ctoi();
			currenty = TOP - absy * rasters_per_point;
			move(currentx,currenty);
			break;

		case 'H':
			/* absolute horizontal move */
			absx = ctoi();
			currentx = absx * rasters_per_point;
			move (currentx,currenty);
			break;

		case 'V':
			/* absolute vertical */
			absy = ctoi();
			currenty = TOP - absy * rasters_per_point;
			move(currentx,currenty);
			break;

		case 'c':
			/* character */
			/* display next character */
			c = getchar();
			printf("%cLT1%c",ESC,c);
			break;

		case 'C':
			/* special character */
			switch(getchar()){
				case 'r':
					if (getchar() == 'u') printf("%cLT1_",ESC);
					break;
				default:
					while ((c = getchar()) != EOL );
					break;
			}
			break;

		case '0':
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9':
			/* horizontal relative displacement */
			absx = absx + (c - '0') * 10 + getchar() - '0';
			currentx = absx * rasters_per_point;
			move(currentx,currenty);
			printf("%cLT1%c",ESC,getchar());
			break;

		case 'x':
			c=getchar(); /* this should be a blank */
			switch(getchar()){
				case 'r':  /* set the resolution translation
						factor */
				   /* there are 3 numbers on this line.  they
				   are (1) resolution in points per inch
				       (2) minimum horizontal motion
				       (3) minimum vertical motion
				   Only concerned with the resolution in points
				   per inch.  Call the term "resolution".

				   How to determine the mapping from ANY device
				   to the Tek terminal.

		resolution(points/inch) * 11(inches/page) = (points/page)

		3132(rasters/page) * (page/points) = (rasters/point)

		motion of 1 point equals X rasters on the Tek.

				   */

				   while(isalpha(c=getchar()));
				   resolution = ctoi();
				   rasters_per_point = 3132.0 / (11.0 * resolution);
				   while ((c = getchar()) != EOL );
				       /* ignore the rest of line */
				   break;

				default:
				/* ignore all other device control for now */
				while ((c = getchar()) != EOL );
				break;
				} /* switch */
			break;

		case 'D':
			switch(getchar()){
				case 'l':
					/* draw line from current to x,y */
					move(currentx,currenty);
					absx = absx + ctoi();
				currentx = absx * rasters_per_point;
					absy = absy + ctoi();
				currenty = TOP - absy * rasters_per_point;
					draw(currentx,currenty);
					while ((c = getchar()) != EOL );
					break;

				default:
					break;
				}	/* switch */

			break;

		case 'n':
			while ((c = getchar()) != EOL );
			break;

		default:
			break;

	} /* switch */

/* set terminal back */
fflush(stdout);
end_segment();		/* close out segments */
printf("%c",7);		/* signal at the end with a bell (control G) */
fflush(stdout);
c = readch();
del_segment(-1); 	/* erase retained segments */
select_code(1);		/* put in ansi mode */
} /* tk */


ctoi()
{
	int i, n , sign;
	char s;

	s = ' ';
	for (i = 0; s == ' ' || s == '\n' || s == '\t'; i++)
		s = getchar();	/* skip white space */
	sign = 1;
	if (s == '+' || s == '-') {	/* sign */
		sign = (s == '+') ? 1 : -1;
		s = getchar();
	}
	for (n = 0; s >= '0' && s <= '9'; i++){
		n = 10 * n + s - '0';
		s = getchar();
	}
	ungetc(s,stdin);
	return(sign * n);
}


readch(){
	char c;
	if (read(2,&c,1)<1) c = 0;
	return(c);
}
