#!/usr/bin/perl
# original version by merlyn (Randal L. Schwartz @ Stonehenge)
# LastEditDate = "Wed Mar 15 14:54:56 1989"
# requires /usr/bin/diff that understands -D

($myname = $0) =~ s!.*/!!; # save this very early

sub usage {
	die join("\n",@_) .
	"\nusage: $myname [-aA] [-cC] [-dD] old-file new-file >marked-file\n";
}

# defaults:
$marka = "+"; # lines that are added
$markc = "|"; # lines that are changed
$markd = "*"; # deletions (near where they were deleted)

while ($_ = shift) {
	$marka = $1, next if /^-a(.+)$/;
	$markc = $1, next if /^-c(.+)$/;
	$markd = $1, next if /^-d(.+)$/;
	do usage("unknown flag: $1") if /^(-.*)$/;
	unshift (@ARGV,$_), last;
}

do usage("missing old-file") unless $#ARGV > -1;

do usage("cannot read old-file '$old': $!") unless -r ($old = shift);

do usage("missing new-file") unless $#ARGV > -1;

do usage("cannot read new-file '$new': $!") unless -r ($new = shift);

do usage("extra args") if $#ARGV > -1;

$zzz = "___A_VERY_UNLIKELY_STRING___"; # separator string

open(I,"exec /usr/bin/diff -D$zzz $old $new |") || die "cannot open diff: $!";

MAIN: while (<I>) {
	if (/^#ifdef $zzz/) {
		print ".mc $marka\n";
		print while ($_ = <I>) && !/^#endif $zzz/;
		print ".mc\n";
		last MAIN if eof;
		next MAIN;
	}
	if (/^#ifndef $zzz/) {
		while (<I>) {
			if (/^#else $zzz/) {
				print ".mc $markc\n";
				print while ($_ = <I>) && !/^#endif $zzz/;
				print ".mc\n";
				last MAIN if eof;
				next MAIN;
			}
			if (/^#endif $zzz/) {
				print ".mc $markd\n.mc\n";
				next MAIN;
			}
		}
	}
	print;
}

close(I);

exit 0;
