/* cpic.h */

#define POINT_RADIUS         0.02
#define PIC_RADIUS           0.4
#define PAGE_WIDTH           6.5
#define TITLE_SEP            0.25
#define BOUNDARY             0.2
#define CHAR_WIDTH           0.12
#define PIC_NAME_LIMIT       512
#define PIC_TITLE_LIMIT      512

#define RAD_ADJ ( 3.14159265 / 180.0 )
#define MAX 1024

#define GETLINE getline(in_f, MAX, line)
#define iscomment(s) (*s == '#')


typedef struct {
	double x;
	double y;
} point;

typedef struct edge_list_entry {
	int v1;
	int v2;
	int times;
	struct edge_list_entry *next_edge;
} edge_list;

typedef struct pict {
	int vertices;
	char fig_name[PIC_NAME_LIMIT];
	double label_width;
	edge_list *e_list;
	struct pict *next_pic;
} picture;

typedef struct plist_entry {
	int pic_limit;
	int pics_in_list;
	double total_label_width;
	char pic_title[PIC_TITLE_LIMIT];
	picture *pic;
} picture_list;


extern char *malloc();
extern char *calloc();
extern char *index();
