#! /bin/csh -f

#
# This script takes a file name as an argument and looks for misspellings.
# If you want to change the file, a sed script is provided, or you
# can change your personal dictionary. It will add one if you need it.
#
#   Author : G. Powell Seattle Silicon Co.  11/3/87
#

# extract the file name from the command line.
set text = $1

# Your personal dictionary, and lookup table file names.
set mylist = ~/.myhdict
set mylook = ~/.mylook

# Temp files for use while this script is running
set temptext = /tmp/$1.$$
set tempfile = /tmp/tmp_file.$$
set tmplist  = /tmp/myhdict_tmp.$$
set tmplook  = /tmp/mylook_tmp.$$
set sedfile  = /tmp/sed_spell.$$

# Delilimaters of a "word"
set delim = '\([\.,?\!(){}\[\]""";: 	]\)'

echo "Checking spelling in $text."

#
# if you have a personal dictionary use it.
#
if (-e $mylist) then
    set list = $mylist
else
    set list = /usr/dict/hlista
endif

set llook = $mylook

echo "Type h for help"

foreach i (`spell -d $list $text`)
    set word = $i
  Query:
    echo -n "< $word > ? "
    switch ($<)
    case 'a':
      Addword:
	echo "Adding $word to list $mylist."
#
# Add word to your personal dictionary
#
	if (! -e $tmplist) then
	    cp $list $tmplist
	    set list = $tmplist
	endif
	echo $word | spellin $list > $tempfile
	mv -f $tempfile $list
#
# Add word to your personal lookup list
#
	if (! -e $tmplook && -e $mylook) then
	    cp $mylook $tmplook
	endif
	set llook = $tmplook
	echo $word >> $tmplook
	cat $tmplook | sort | uniq > $tempfile
	mv -f $tempfile $tmplook
	breaksw
    case 'c':
	echo -n "New spelling? "
	set neword = ($<)
	echo "-> Changing occurances of $word to $neword in $text."
#
# Look for new word word in dictionary
#
	@ change = 0
	set foundword = `echo $neword | spellout $list`
	if ($foundword == $neword) then
	    echo "$neword was not found in your dictionary."
	    echo -n "Do you still want to change it? [y/n] "
	    if ('y' != $<) then
		goto Query
	    endif
	    @ change = 1
	endif

	if (! -e $temptext) then
	    cp $text $temptext
	endif
	echo /$word/s/'^'$word"$delim"/$neword'\1'/g > sedfile
	echo /$word/s/"$delim"$word'$'/'\1'$neword/g >> sedfile
	echo /$word/s/"$delim"$word"$delim"/'\1'$neword'\2'/g >> sedfile
	mv $temptext $tempfile
	sed -f sedfile $tempfile > $temptext
	/bin/rm sedfile
	/bin/rm $tempfile

	if ( $change == 1) then
	    echo -n "Do you want add $neword to your dictionary? [y/n] "
	    if ('y' == $<) then
		set word = $neword
		goto Addword
	    endif
	endif
	breaksw
    case 'd':
	if (-e $temptext) then
	    diff $text $temptext | less -emQ
	else
	    echo "You haven't made any changes yet."
	endif
	goto Query
	breaksw
    case 'h':
	echo " a    - add this word to your personal directory $mylist"
	echo " c    - change all occurances of this word in the file $text"
	echo " d    - diff file $text and the tempfile changes."
	echo " h    - help (this command)"
	echo " l    - look up the word for near spellings"
	echo " p    - print the context of the words."
	echo " q    - quit (you can save current changes.)"
	echo " r    - remove a word from your dictionary, $mylist."
	echo " s    - look up an entered word for near spellings"
	echo "<cr>  - skip to the next word."
	goto Query
	breaksw
    case 'l':
	set lookup = $word
      Lookup:
	@ ccount = `echo $lookup | wc -c`
      Lookagain:
	look $lookup > $tempfile
	if (-e $llook) then
	    look $lookup $llook >> $tempfile
	endif
	@ wcount = `cat $tempfile | wc -l`
	if ( $wcount <= 0 ) then
	    if ($ccount > 3) then
		@ ccount --
		set lookup = `echo $lookup | colrm $ccount`
		echo "Nothing found yet, trying...$lookup"
		goto Lookagain
	    else
		echo "No words found."
		/bin/rm $tempfile
		goto Query
	    endif
	endif
	cat $tempfile | sort | uniq | less -emQ
	/bin/rm $tempfile
	goto Query
	breaksw
    case 'p':
	set search = '\<'$word'\>'
	if (-e $temptext) then
	    grep "$search" $temptext | less -emQ
	else
	    grep "$search" $text | less -emQ
	endif
	goto Query
	breaksw
    case 'q':
	echo "quit."
	goto Done
	breaksw
    case 'r':
	if (-e $tmplook) then
	    /bin/rm $list
	    cp $mylist $list
	else
	    if (-e $mylook && -e $mydict) then
		cp $mylook $tmplook
		set llook = $tmplook
		cp /usr/dict/hlista $tmplist
		set list = $tmplist
	    else
		echo "You don't have a personal word list."
		goto Query
	    endif
	endif
	echo -n "Enter word to remove : "
	sed -e "/$</d" $llook > $tempfile
	mv -f $tempfile $llook
	foreach k (`cat $llook`)
	    echo $k | spellin $list > $tempfile
	    mv -f $tempfile $list 
	end
	goto Query
	breaksw
    case 's':
	echo -n "Enter word to find near derivations : "
	set lookup = $<
	goto Lookup
	breaksw
    endsw
end

#
#  Save changes
#
Done:
set answer = y
if (-e $temptext) then
    echo -n "Would you like to see your changes? "
    if ('y' == $<) then
	diff $text $temptext | less -emQ
    endif
    echo -n "Do you want to keep your changes? "
    set answer = $<
    if ('y' == $answer) then
	mv -f $temptext $text
    else
	/bin/rm $temptext
    endif
endif

#
#  Save new Dictionary
#
if (-e $tmplist && $answer == 'y') then
    echo -n "Do You want to save your updated dictionary? [y/n] "
    if ('n' == $<) then
	/bin/rm $tmplist
	/bin/rm $tmplook
    else
	mv -f $tmplist $mylist
	mv -f $tmplook $mylook
    endif
endif

echo "Done."
